/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.api.lubricant;

import java.util.Collection;
import mysticalmechanics.api.lubricant.ILubricant;
import mysticalmechanics.api.lubricant.LubricantStack;
import net.minecraft.nbt.NBTTagCompound;

public interface ILubricantCapability {
    public int lubricate(ILubricant var1, int var2, boolean var3);

    public Collection<LubricantStack> getAppliedLubricant();

    public int getCapacity();

    default public double getSpeedMod() {
        double speedMod = 1.0;
        for (LubricantStack stack : this.getAppliedLubricant()) {
            speedMod *= stack.getLubricant().getSpeedMod();
        }
        return speedMod;
    }

    default public double getFrictionMod() {
        double frictionMod = 1.0;
        for (LubricantStack stack : this.getAppliedLubricant()) {
            frictionMod *= stack.getLubricant().getFrictionMod();
        }
        return frictionMod;
    }

    default public double getHeatMod() {
        double heatMod = 1.0;
        for (LubricantStack stack : this.getAppliedLubricant()) {
            heatMod *= stack.getLubricant().getHeatMod();
        }
        return heatMod;
    }

    default public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        return tag;
    }

    default public void readFromNBT(NBTTagCompound tag) {
    }
}

