/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.api.lubricant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import mysticalmechanics.api.lubricant.DefaultLubricantCapability;
import mysticalmechanics.api.lubricant.ILubricant;
import mysticalmechanics.api.lubricant.LubricantStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileLubricantCapability
extends DefaultLubricantCapability {
    protected TileEntity tile;
    protected List<LubricantStack> lubricants = new ArrayList<LubricantStack>();
    protected int capacity;

    public TileLubricantCapability(TileEntity tile, int capacity) {
        this.tile = tile;
        this.capacity = capacity;
    }

    public TileEntity getTile() {
        return this.tile;
    }

    public void tick() {
        Iterator<LubricantStack> iterator = this.lubricants.iterator();
        while (iterator.hasNext()) {
            LubricantStack stack = iterator.next();
            stack.deplete(1);
            if (!stack.isEmpty()) continue;
            iterator.remove();
        }
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int lubricate(ILubricant lubricant, int amount, boolean simulate) {
        int capacity = this.getCapacity();
        for (LubricantStack existing : this.lubricants) {
            if (!existing.getLubricant().equals(lubricant)) continue;
            int toAdd = Math.min(capacity - existing.getAmount(), amount);
            if (!simulate) {
                existing.increment(toAdd);
            }
            return amount - toAdd;
        }
        int toAdd = Math.min(capacity, amount);
        if (!simulate) {
            this.lubricants.add(new LubricantStack(lubricant, toAdd));
        }
        return amount - toAdd;
    }

    @Override
    public Collection<LubricantStack> getAppliedLubricant() {
        return this.lubricants;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (LubricantStack stack : this.lubricants) {
            tagList.func_74742_a((NBTBase)stack.serializeNBT());
        }
        tag.func_74782_a("lubricants", (NBTBase)tagList);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList tagList = tag.func_150295_c("lubricants", 10);
        this.lubricants.clear();
        for (NBTBase compound : tagList) {
            this.lubricants.add(new LubricantStack((NBTTagCompound)compound));
        }
    }
}

