/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.apiimpl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mysticalmechanics.MysticalMechanics;
import mysticalmechanics.api.IConfigValue;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.IHasRotation;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.IMechUnit;
import mysticalmechanics.api.IMysticalMechanicsAPI;
import mysticalmechanics.api.MysticalMechanicsAPI;
import mysticalmechanics.api.lubricant.ILubricant;
import mysticalmechanics.api.lubricant.SimpleLubricant;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class MysticalMechanicsAPIImpl
implements IMysticalMechanicsAPI {
    public static LinkedHashMap<ResourceLocation, GearStruct> GEAR_REGISTRY = new LinkedHashMap();
    public static LinkedHashMap<String, IMechUnit> UNITS = new LinkedHashMap();
    private static HashMap<String, IConfigValue> CONFIG_VALUES = new HashMap();
    private static LinkedHashMap<ResourceLocation, Function<NBTTagCompound, ILubricant>> LUBRICANT_REGISTRY = new LinkedHashMap();
    private IMechUnit unitDefault;
    private boolean unitDirty;
    static int tick;

    public MysticalMechanicsAPIImpl() {
        MinecraftForge.EVENT_BUS.register(this.getClass());
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++tick;
        }
    }

    public void registerConfigValue(IConfigValue value) {
        CONFIG_VALUES.put(value.getKey(), value);
    }

    @Override
    public void registerGear(ResourceLocation resourceLocation, Ingredient matcher, IGearBehavior behavior) {
        GEAR_REGISTRY.put(resourceLocation, new GearStruct(matcher, behavior));
    }

    @Override
    public void unregisterGear(ResourceLocation resourceLocation) {
        GEAR_REGISTRY.remove(resourceLocation);
    }

    @Override
    public void modifyGear(ResourceLocation resourceLocation, Function<IGearBehavior, IGearBehavior> modifier) {
        GearStruct struct = GEAR_REGISTRY.get(resourceLocation);
        if (struct != null) {
            struct.behavior = modifier.apply(struct.behavior);
        }
    }

    @Override
    public Iterable<ResourceLocation> getGearKeys() {
        return GEAR_REGISTRY.keySet();
    }

    @Override
    public IGearBehavior getGearBehavior(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (GearStruct struct : GEAR_REGISTRY.values()) {
                if (!struct.ingredient.apply(stack)) continue;
                return struct.behavior;
            }
        }
        return IGearBehavior.NO_BEHAVIOR;
    }

    @Override
    @Nonnull
    public IGearBehavior getGearBehavior(ResourceLocation resourceLocation) {
        GearStruct gearStruct = GEAR_REGISTRY.get(resourceLocation);
        return gearStruct != null ? gearStruct.behavior : IGearBehavior.NO_BEHAVIOR;
    }

    @Override
    public boolean isValidGear(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (GearStruct struct : GEAR_REGISTRY.values()) {
                if (!struct.ingredient.apply(stack)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void registerLubricant(ResourceLocation resLoc, Function<NBTTagCompound, ILubricant> generator) {
        LUBRICANT_REGISTRY.put(resLoc, generator);
    }

    @Override
    public void registerSimpleLubricant(SimpleLubricant lubricant) {
        this.registerLubricant(lubricant.getType(), tag -> lubricant);
    }

    @Override
    public void unregisterLubricant(ResourceLocation resLoc) {
        LUBRICANT_REGISTRY.remove(resLoc);
    }

    @Override
    public ILubricant deserializeLubricant(NBTTagCompound tag) {
        ResourceLocation resLoc = new ResourceLocation(tag.func_74779_i("type"));
        Function<NBTTagCompound, ILubricant> generator = LUBRICANT_REGISTRY.get(resLoc);
        if (generator != null) {
            return generator.apply(tag);
        }
        return null;
    }

    @Override
    public void registerUnit(IMechUnit unit) {
        UNITS.put(unit.getName(), unit);
        this.unitDirty = true;
    }

    @Override
    public IMechUnit getDefaultUnit() {
        if (this.unitDirty) {
            if (!MysticalMechanics.FORCE_UNIT.isEmpty()) {
                this.unitDefault = this.getUnit(MysticalMechanics.FORCE_UNIT);
            }
            if (this.unitDefault == null) {
                this.unitDefault = this.getHighestPriorityUnit();
            }
            this.unitDirty = false;
        }
        return this.unitDefault;
    }

    private IMechUnit getHighestPriorityUnit() {
        return UNITS.values().stream().max(Comparator.comparingInt(IMechUnit::getPriority)).orElse(null);
    }

    @Override
    public IMechUnit getUnit(String name) {
        return UNITS.get(name);
    }

    @Override
    public Iterable<IMechUnit> getUnits() {
        return UNITS.values();
    }

    @Override
    public Map<String, IConfigValue> getConfigValues() {
        return CONFIG_VALUES;
    }

    @Override
    public IConfigValue getConfigValue(String key) {
        return CONFIG_VALUES.get(key);
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return MysticalMechanics.creativeTab;
    }

    @Override
    public void pushPower(TileEntity tileSelf, EnumFacing sideSelf, IMechCapability capSelf, boolean hasGear) {
        IMechCapability capOther;
        TileEntity tileOther = tileSelf.func_145831_w().func_175625_s(tileSelf.func_174877_v().func_177972_a(sideSelf));
        EnumFacing sideOther = sideSelf.func_176734_d();
        if (tileOther != null && (capOther = (IMechCapability)tileOther.getCapability(MysticalMechanicsAPI.MECH_CAPABILITY, sideOther)) != null && !capSelf.isInput(sideSelf)) {
            if (hasGear) {
                capOther.setPower(capSelf.getPower(sideSelf), sideOther);
            } else {
                capOther.setPower(0.0, sideOther);
            }
        }
    }

    @Override
    public void pullPower(TileEntity tileSelf, EnumFacing sideSelf, IMechCapability capSelf, boolean hasGear) {
        TileEntity tileOther = tileSelf.func_145831_w().func_175625_s(tileSelf.func_174877_v().func_177972_a(sideSelf));
        EnumFacing sideOther = sideSelf.func_176734_d();
        boolean hasValidTile = false;
        if (tileOther != null) {
            IMechCapability capOther = (IMechCapability)tileOther.getCapability(MysticalMechanicsAPI.MECH_CAPABILITY, sideOther);
            boolean bl = hasValidTile = capOther != null;
            if (capOther != null && !capSelf.isOutput(sideSelf)) {
                if (hasGear && capOther.isOutput(sideOther)) {
                    capSelf.setPower(capOther.getPower(sideOther), sideSelf);
                } else {
                    capSelf.setPower(0.0, sideSelf);
                }
            }
        }
        if (!hasValidTile) {
            capSelf.setPower(0.0, sideSelf);
        }
    }

    @Override
    public boolean isGearHit(TileEntity tile, EnumFacing facing) {
        return MysticalMechanics.proxy.isGearHit(tile, facing);
    }

    @Override
    public boolean shouldRenderHologram(ItemStack gear, boolean hasGear, boolean sideHit, boolean canAttach) {
        if (sideHit) {
            boolean gearFits;
            boolean isHoldingGear = MysticalMechanicsAPI.IMPL.isValidGear(gear);
            boolean bl = gearFits = isHoldingGear && canAttach;
            if (!hasGear && !gearFits) {
                return false;
            }
        }
        return sideHit;
    }

    @Override
    public void renderGear(ItemStack gear, ItemStack gearHologram, boolean renderHologram, float partialTicks, double offset, double scale, float angle) {
        float totalTick = (float)tick + partialTicks;
        MysticalMechanics.proxy.renderGear(gear, gearHologram, renderHologram, totalTick, offset, scale, angle);
    }

    @Override
    public void renderAxle(ModelResourceLocation resLoc, EnumFacing.Axis axis, float angle) {
        MysticalMechanics.proxy.renderAxle(resLoc, axis, angle);
    }

    @Override
    public void syncAngle(TileEntity tile, EnumFacing checkDirection) {
        IHasRotation axle;
        if (!(tile instanceof IHasRotation)) {
            return;
        }
        BlockPos axlePos = tile.func_174877_v().func_177972_a(checkDirection);
        TileEntity axleTile = tile.func_145831_w().func_175625_s(axlePos);
        if (axleTile instanceof IHasRotation && (axle = (IHasRotation)axleTile).hasRotation(checkDirection.func_176734_d())) {
            double angle = axle.getAngle(checkDirection.func_176734_d());
            double lastAngle = axle.getLastAngle(checkDirection.func_176734_d());
            ((IHasRotation)tile).setRotation(checkDirection, angle, lastAngle);
        }
    }

    static class GearStruct {
        Ingredient ingredient;
        IGearBehavior behavior;

        public GearStruct(Ingredient ingredient, IGearBehavior behavior) {
            this.ingredient = ingredient;
            this.behavior = behavior;
        }
    }
}

