/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.compat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mysticalmechanics.api.IAxle;
import mysticalmechanics.api.IGearbox;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import mysticalmechanics.api.lubricant.ILubricant;
import mysticalmechanics.api.lubricant.ILubricantCapability;
import mysticalmechanics.api.lubricant.LubricantStack;
import mysticalmechanics.compat.PowerUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class TheOneProbe
implements Function<ITheOneProbe, Void>,
IProbeInfoProvider {
    public static ITheOneProbe probe;
    public static int ELEMENT_POWERUNIT;

    public static void init() {
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"mysticalmechanics.compat.TheOneProbe");
    }

    @Override
    public Void apply(ITheOneProbe theOneProbe) {
        probe = theOneProbe;
        ELEMENT_POWERUNIT = probe.registerElementFactory((IElementFactory)new PowerUnit.Factory());
        probe.registerProvider((IProbeInfoProvider)this);
        return null;
    }

    public String getID() {
        return "mysticalmechanics";
    }

    /*
     * WARNING - void declaration
     */
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        block16: {
            Map<MechInfoType, List<MechInfoStruct>> grouped;
            boolean canLubricate;
            ArrayList<LubricantInfoStruct> infoLubricant;
            ArrayList<MechInfoStruct> info;
            EnumFacing currentFacing;
            block17: {
                void var15_17;
                TileEntity tile = world.func_175625_s(data.getPos());
                IGearbox gearbox = null;
                if (tile instanceof IGearbox) {
                    gearbox = (IGearbox)tile;
                }
                if (tile instanceof IAxle) {
                    IAxle axle = (IAxle)tile;
                    probeInfo.text(TextStyleClass.LABEL + "{*" + "mysticalmechanics.probe.axle_length" + "*}" + " " + TextStyleClass.INFO + axle.getLength());
                }
                currentFacing = data.getSideHit();
                if (tile == null) break block16;
                info = new ArrayList<MechInfoStruct>();
                infoLubricant = new ArrayList<LubricantInfoStruct>();
                canLubricate = false;
                if (mode != ProbeMode.EXTENDED) break block17;
                EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
                int n = enumFacingArray.length;
                boolean bl = false;
                while (var15_17 < n) {
                    block19: {
                        Object capability;
                        EnumFacing facing;
                        block20: {
                            MechInfoStruct struct;
                            ItemStack gear;
                            boolean forceWrite;
                            block22: {
                                double power;
                                boolean output;
                                block23: {
                                    boolean input;
                                    block21: {
                                        block18: {
                                            facing = enumFacingArray[var15_17];
                                            forceWrite = false;
                                            gear = ItemStack.field_190927_a;
                                            if (gearbox == null || !gearbox.canAttachGear(facing)) break block18;
                                            gear = gearbox.getGear(facing);
                                            if (gear.func_190926_b()) break block19;
                                            forceWrite = true;
                                        }
                                        if (!tile.hasCapability(MysticalMechanicsAPI.MECH_CAPABILITY, facing)) break block20;
                                        capability = (IMechCapability)tile.getCapability(MysticalMechanicsAPI.MECH_CAPABILITY, facing);
                                        input = capability.isInput(facing);
                                        output = capability.isOutput(facing);
                                        power = capability.getVisualPower(facing);
                                        if (!input || !output) break block21;
                                        struct = new MechInfoStruct(MechInfoType.Both, power, facing);
                                        break block22;
                                    }
                                    if (!input) break block23;
                                    struct = new MechInfoStruct(MechInfoType.Input, power, facing);
                                    break block22;
                                }
                                if (!output) break block19;
                                struct = new MechInfoStruct(MechInfoType.Output, power, facing);
                            }
                            if (forceWrite) {
                                this.addMechPowerData(mode, probeInfo, struct, gear, currentFacing);
                            } else {
                                info.add(struct);
                            }
                        }
                        if (tile.hasCapability(MysticalMechanicsAPI.LUBRICANT_CAPABILITY, facing)) {
                            canLubricate = true;
                            capability = (ILubricantCapability)tile.getCapability(MysticalMechanicsAPI.LUBRICANT_CAPABILITY, facing);
                            for (LubricantStack stack : capability.getAppliedLubricant()) {
                                infoLubricant.add(new LubricantInfoStruct(stack, capability.getCapacity()));
                            }
                        }
                    }
                    ++var15_17;
                }
            }
            if ((grouped = info.stream().collect(Collectors.groupingBy(mechInfoStruct -> mechInfoStruct.type))).entrySet().stream().allMatch(entry -> ((List)entry.getValue()).stream().distinct().count() <= 1L)) {
                for (List list : grouped.values()) {
                    if (list.isEmpty()) continue;
                    this.addMechPowerData(mode, probeInfo, (MechInfoStruct)list.get(0), ItemStack.field_190927_a, currentFacing);
                }
            } else {
                for (MechInfoStruct mechInfoStruct2 : info) {
                    this.addMechPowerData(mode, probeInfo, mechInfoStruct2, ItemStack.field_190927_a, currentFacing);
                }
            }
            if (canLubricate) {
                probeInfo.text("{*mysticalmechanics.probe.lubricant*}");
            }
            Map<LubricantStack, List<LubricantInfoStruct>> groupedLubricants = infoLubricant.stream().collect(Collectors.groupingBy(LubricantInfoStruct::getStack));
            for (Map.Entry<LubricantStack, List<LubricantInfoStruct>> entry2 : groupedLubricants.entrySet()) {
                LubricantStack stack = entry2.getKey();
                ILubricant lubricant = stack.getLubricant();
                int capacity = entry2.getValue().stream().mapToInt(LubricantInfoStruct::getCapacity).max().getAsInt();
                IProbeInfo part = probeInfo.horizontal(probeInfo.defaultLayoutStyle().spacing(3).alignment(ElementAlignment.ALIGN_BOTTOMRIGHT));
                part.progress(stack.getAmount(), capacity, probeInfo.defaultProgressStyle().width(32).filledColor(lubricant.getColor().getRGB()).alternateFilledColor(lubricant.getColor().getRGB()));
                part.text("{*" + stack.getUnlocalizedName() + "*}");
            }
        }
    }

    private void addMechPowerData(ProbeMode mode, IProbeInfo probeInfo, MechInfoStruct struct, ItemStack gear, EnumFacing facing) {
        boolean input = struct.type == MechInfoType.Input || struct.type == MechInfoType.Both;
        boolean output = struct.type == MechInfoType.Output || struct.type == MechInfoType.Both;
        probeInfo.element((IElement)new PowerUnit(struct.power, input, output, gear, struct.facing));
    }

    class LubricantInfoStruct {
        LubricantStack stack;
        int capacity;

        public LubricantInfoStruct(LubricantStack stack, int capacity) {
            this.stack = stack;
            this.capacity = capacity;
        }

        public LubricantStack getStack() {
            return this.stack;
        }

        public int getCapacity() {
            return this.capacity;
        }
    }

    class MechInfoStruct {
        MechInfoType type;
        double power;
        EnumFacing facing;

        public MechInfoStruct(MechInfoType type, double power, EnumFacing facing) {
            this.type = type;
            this.power = power;
            this.facing = facing;
        }

        public MechInfoType getType() {
            return this.type;
        }

        public double getPower() {
            return this.power;
        }

        public EnumFacing getFacing() {
            return this.facing;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MechInfoStruct) {
                return this.equals((MechInfoStruct)obj);
            }
            return super.equals(obj);
        }

        private boolean equals(MechInfoStruct struct) {
            return this.type.equals((Object)struct.type) && this.power == struct.power;
        }

        public int hashCode() {
            return this.type.hashCode() ^ Double.hashCode(this.power);
        }
    }

    static enum MechInfoType {
        Input,
        Output,
        Both;

    }
}

