/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mysticalmechanics.api.DefaultMechCapability;
import mysticalmechanics.api.IAxle;
import mysticalmechanics.api.IHasRotation;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import mysticalmechanics.block.BlockAxle;
import mysticalmechanics.util.Misc;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityAxle
extends TileEntity
implements ITickable,
IAxle,
IHasRotation {
    public double angle;
    public double lastAngle;
    private boolean isBroken;
    public AxleCapability capability = new AxleCapability();

    public void updatePower() {
        EnumFacing frontFacing = this.getForward();
        EnumFacing backFacing = this.getBackward();
        BlockPos front = this.field_174879_c.func_177972_a(frontFacing);
        BlockPos back = this.field_174879_c.func_177972_a(backFacing);
        TileEntity frontTile = this.field_145850_b.func_175625_s(front);
        TileEntity backTile = this.field_145850_b.func_175625_s(back);
        if (frontTile != null && frontTile.hasCapability(MysticalMechanicsAPI.MECH_CAPABILITY, backFacing) && ((IMechCapability)frontTile.getCapability(MysticalMechanicsAPI.MECH_CAPABILITY, backFacing)).isInput(backFacing)) {
            ((IMechCapability)frontTile.getCapability(MysticalMechanicsAPI.MECH_CAPABILITY, backFacing)).setPower(this.capability.forwardPower, backFacing);
        }
        if (backTile != null && backTile.hasCapability(MysticalMechanicsAPI.MECH_CAPABILITY, frontFacing) && ((IMechCapability)backTile.getCapability(MysticalMechanicsAPI.MECH_CAPABILITY, frontFacing)).isInput(frontFacing)) {
            ((IMechCapability)backTile.getCapability(MysticalMechanicsAPI.MECH_CAPABILITY, frontFacing)).setPower(this.capability.backwardPower, frontFacing);
        }
    }

    @Override
    public BlockPos getConnection(EnumFacing.AxisDirection dir) {
        BlockPos connectPos = dir == EnumFacing.AxisDirection.POSITIVE ? this.field_174879_c.func_177972_a(this.getForward()) : this.field_174879_c.func_177972_a(this.getBackward());
        TileEntity connectTile = this.field_145850_b.func_175625_s(connectPos);
        if (connectTile instanceof IAxle) {
            return ((IAxle)connectTile).getConnection(dir);
        }
        return connectPos;
    }

    public void updateNeighbors() {
        this.updatePower();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        IBlockState state;
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY && (state = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177230_c() instanceof BlockAxle && facing != null && this.isValidSide(facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY) {
            return (T)MysticalMechanicsAPI.MECH_CAPABILITY.cast((Object)this.capability);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.isBroken = true;
        this.capability.setPower(0.0, null);
    }

    public EnumFacing getForward() {
        EnumFacing.Axis axis = this.getAxis();
        return EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis);
    }

    public EnumFacing getBackward() {
        EnumFacing.Axis axis = this.getAxis();
        return EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis);
    }

    public boolean isForward(EnumFacing facing) {
        if (facing == null) {
            return false;
        }
        return facing.func_176740_k() == this.getAxis() && facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
    }

    public boolean isBackward(EnumFacing facing) {
        if (facing == null) {
            return false;
        }
        return facing.func_176740_k() == this.getAxis() && facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
    }

    public EnumFacing.Axis getAxis() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return (EnumFacing.Axis)state.func_177229_b(BlockAxle.axis);
    }

    public boolean isValidSide(EnumFacing facing) {
        if (facing == null) {
            return false;
        }
        return this.getAxis() == facing.func_176740_k();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void neighborChanged(BlockPos from) {
        this.updateNeighbors();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.lastAngle = this.angle;
            this.angle += this.capability.getPower(null);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this, this.isBroken);
    }

    public boolean isBroken() {
        return this.isBroken;
    }

    public void rotateTile(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing.Axis currentAxis = this.getAxis();
        currentAxis = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)currentAxis).func_176732_a(side.func_176740_k()).func_176740_k();
        this.capability.setPower(0.0, null);
        world.func_175656_a(pos, state.func_177226_a(BlockAxle.axis, (Comparable)currentAxis));
        this.updateNeighbors();
    }

    @Override
    public boolean hasRotation(@Nonnull EnumFacing side) {
        return this.isValidSide(side);
    }

    @Override
    public double getAngle(@Nonnull EnumFacing side) {
        return this.angle;
    }

    @Override
    public double getLastAngle(@Nonnull EnumFacing side) {
        return this.lastAngle;
    }

    @Override
    public void setRotation(@Nonnull EnumFacing side, double angle, double lastAngle) {
        this.angle = angle;
        this.lastAngle = lastAngle;
    }

    private class AxleCapability
    extends DefaultMechCapability {
        double forwardPower;
        double backwardPower;

        private AxleCapability() {
        }

        @Override
        public void onPowerChange() {
            TileEntityAxle.this.updateNeighbors();
            TileEntityAxle.this.func_70296_d();
        }

        @Override
        public double getPower(EnumFacing from) {
            if (from == null || TileEntityAxle.this.isValidSide(from)) {
                return this.getActualPower();
            }
            return 0.0;
        }

        private double getActualPower() {
            return Math.max(this.forwardPower, this.backwardPower);
        }

        @Override
        public void setPower(double value, EnumFacing from) {
            double oldPower;
            if (from == null) {
                this.forwardPower = 0.0;
                this.backwardPower = 0.0;
                this.onPowerChange();
            } else if (TileEntityAxle.this.isForward(from)) {
                double oldPower2 = this.backwardPower;
                if (oldPower2 != value) {
                    this.backwardPower = value;
                    this.onPowerChange();
                }
            } else if (TileEntityAxle.this.isBackward(from) && (oldPower = this.forwardPower) != value) {
                this.forwardPower = value;
                this.onPowerChange();
            }
        }

        @Override
        public boolean isInput(EnumFacing from) {
            return TileEntityAxle.this.isValidSide(from);
        }

        @Override
        public boolean isOutput(EnumFacing from) {
            return TileEntityAxle.this.isValidSide(from);
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74780_a("forwardPower", this.forwardPower);
            tag.func_74780_a("backwardPower", this.backwardPower);
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.forwardPower = tag.func_74769_h("forwardPower");
            this.backwardPower = tag.func_74769_h("backwardPower");
        }
    }
}

