/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.Nullable;
import mysticalmechanics.MysticalMechanics;
import mysticalmechanics.api.DefaultMechCapability;
import mysticalmechanics.api.GearHelperTile;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.IGearbox;
import mysticalmechanics.api.MysticalMechanicsAPI;
import mysticalmechanics.api.lubricant.TileLubricantCapability;
import mysticalmechanics.block.BlockGearbox;
import mysticalmechanics.handler.RegistryHandler;
import mysticalmechanics.util.ISoundController;
import mysticalmechanics.util.Misc;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityGearbox
extends TileEntity
implements ITickable,
IGearbox,
ISoundController {
    EnumFacing from = null;
    protected boolean isBroken;
    public int connections = 0;
    public GearHelperTile[] gears = new GearHelperTile[6];
    public DefaultMechCapability capability;
    public TileLubricantCapability lubricant;
    public static final int SOUND_SLOW_LV1 = 1;
    public static final int SOUND_SLOW_LV2 = 2;
    public static final int SOUND_SLOW_LV3 = 3;
    public static final int SOUND_MID_LV1 = 4;
    public static final int SOUND_MID_LV2 = 5;
    public static final int SOUND_MID_LV3 = 6;
    public static final int SOUND_FAST_LV1 = 7;
    public static final int SOUND_FAST_LV2 = 8;
    public static final int SOUND_FAST_LV3 = 9;
    public static final int[] SOUND_IDS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    HashMap<Integer, Integer> soundsPlaying = new HashMap();
    public boolean shouldUpdate;

    public TileEntityGearbox() {
        this.capability = this.createCapability();
        for (int i = 0; i < this.gears.length; ++i) {
            this.gears[i] = new GearHelperTile(this, EnumFacing.func_82600_a((int)i));
        }
        this.lubricant = new TileLubricantCapability(this, 1000);
    }

    public DefaultMechCapability createCapability() {
        return new GearboxMechCapability();
    }

    public void updateNeighbors() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockGearbox) {
            this.from = (EnumFacing)state.func_177229_b((IProperty)BlockGearbox.facing);
            MysticalMechanicsAPI.IMPL.pullPower(this, this.from, this.capability, !this.getGear(this.from).func_190926_b());
        }
        this.connections = 0;
        ArrayList<EnumFacing> toUpdate = new ArrayList<EnumFacing>();
        for (EnumFacing f : EnumFacing.values()) {
            TileEntity t;
            if (f == null || f == this.from || (t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f))) == null || !t.hasCapability(MysticalMechanicsAPI.MECH_CAPABILITY, f.func_176734_d())) continue;
            if (!this.getGear(f).func_190926_b() && this.capability.getPower(f) != 0.0) {
                ++this.connections;
            }
            toUpdate.add(f);
        }
        Iterator iterator = toUpdate.iterator();
        while (iterator.hasNext()) {
            EnumFacing f;
            MysticalMechanicsAPI.IMPL.pushPower(this, f, this.capability, !this.getGear(f = (EnumFacing)iterator.next()).func_190926_b());
        }
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        this.lubricant.writeToNBT(tag);
        if (this.from != null) {
            tag.func_74768_a("from", this.from.func_176745_a());
        }
        for (int i = 0; i < 6; ++i) {
            tag.func_74782_a("side" + i, (NBTBase)this.gears[i].writeToNBT(new NBTTagCompound()));
        }
        tag.func_74768_a("connections", this.connections);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        this.lubricant.readFromNBT(tag);
        if (tag.func_74764_b("from")) {
            this.from = EnumFacing.func_82600_a((int)tag.func_74762_e("from"));
        }
        for (int i = 0; i < 6; ++i) {
            this.gears[i].readFromNBT(tag.func_74775_l("side" + i));
        }
        this.readLegacyGears(tag);
        this.connections = tag.func_74762_e("connections");
    }

    private void readLegacyGears(NBTTagCompound tag) {
        for (int i = 0; i < 6; ++i) {
            if (!tag.func_74764_b("gear" + i)) continue;
            this.gears[i].setGear(new ItemStack(tag.func_74775_l("gear" + i)));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY) {
            return true;
        }
        if (capability == MysticalMechanicsAPI.LUBRICANT_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY) {
            DefaultMechCapability result = this.capability;
            return (T)result;
        }
        if (capability == MysticalMechanicsAPI.LUBRICANT_CAPABILITY) {
            return (T)this.lubricant;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void attachGear(EnumFacing facing, ItemStack stack, EntityPlayer player) {
        if (facing == null) {
            return;
        }
        int index = facing.func_176745_a();
        this.gears[index].attach(player, stack);
        this.capability.onPowerChange();
    }

    @Override
    public ItemStack detachGear(EnumFacing facing, EntityPlayer player) {
        if (facing == null) {
            return ItemStack.field_190927_a;
        }
        int index = facing.func_176745_a();
        ItemStack gear = this.gears[index].detach(player);
        this.capability.onPowerChange();
        return gear;
    }

    @Override
    public ItemStack getGear(EnumFacing facing) {
        if (facing == null) {
            return ItemStack.field_190927_a;
        }
        return this.gears[facing.func_176745_a()].getGear();
    }

    @Nullable
    public GearHelperTile getGearHelper(EnumFacing facing) {
        if (facing == null) {
            return null;
        }
        return this.gears[facing.func_176745_a()];
    }

    @Override
    public boolean canAttachGear(EnumFacing facing, ItemStack stack) {
        return this.gears[facing.func_176745_a()].canAttach(stack);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public int getConnections() {
        return this.connections;
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        EnumFacing attachSide = side;
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        if (player.func_70093_af()) {
            attachSide = attachSide.func_176734_d();
        }
        if (!heldItem.func_190926_b() && this.canAttachGear(attachSide, heldItem) && this.getGear(attachSide).func_190926_b() && MysticalMechanicsAPI.IMPL.isValidGear(heldItem)) {
            ItemStack gear = heldItem.func_77946_l();
            gear.func_190920_e(1);
            this.attachGear(attachSide, gear, player);
            heldItem.func_190918_g(1);
            if (heldItem.func_190926_b()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            return true;
        }
        if (!this.getGear(attachSide).func_190926_b()) {
            ItemStack gear = this.detachGear(attachSide, player);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v, gear));
            }
            return true;
        }
        return false;
    }

    @Override
    public void playSound(int id) {
        int playId = -this.getPlayId(id) + 1;
        switch (id) {
            case 1: {
                MysticalMechanics.proxy.playMachineSound(this, 1, playId, RegistryHandler.GEARBOX_SLOW_LV1, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                break;
            }
            case 2: {
                MysticalMechanics.proxy.playMachineSound(this, 2, playId, RegistryHandler.GEARBOX_SLOW_LV2, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                break;
            }
            case 3: {
                MysticalMechanics.proxy.playMachineSound(this, 3, playId, RegistryHandler.GEARBOX_SLOW_LV3, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                break;
            }
            case 4: {
                MysticalMechanics.proxy.playMachineSound(this, 4, playId, RegistryHandler.GEARBOX_MID_LV1, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                break;
            }
            case 5: {
                MysticalMechanics.proxy.playMachineSound(this, 5, playId, RegistryHandler.GEARBOX_MID_LV2, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                break;
            }
            case 6: {
                MysticalMechanics.proxy.playMachineSound(this, 6, playId, RegistryHandler.GEARBOX_MID_LV3, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                break;
            }
            case 7: {
                MysticalMechanics.proxy.playMachineSound(this, 7, playId, RegistryHandler.GEARBOX_FAST_LV1, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                break;
            }
            case 8: {
                MysticalMechanics.proxy.playMachineSound(this, 8, playId, RegistryHandler.GEARBOX_FAST_LV2, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                break;
            }
            case 9: {
                MysticalMechanics.proxy.playMachineSound(this, 8, playId, RegistryHandler.GEARBOX_FAST_LV3, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
            }
        }
        this.soundsPlaying.put(id, playId);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.put(id, -this.getPlayId(id));
    }

    @Override
    public int getPlayId(int id) {
        if (!this.soundsPlaying.containsKey(id)) {
            return 0;
        }
        return this.soundsPlaying.get(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        double power = this.capability.getVisualPower(null);
        int level = this.getSoundLevel();
        int speedindex = this.getSpeedindex(power);
        return speedindex > 0 && level > 0 && id == SOUND_IDS[speedindex - 1 + level];
    }

    private int getSpeedindex(double power) {
        int speedindex = 0;
        if (power > 50.0) {
            speedindex = 3;
        } else if (power > 25.0) {
            speedindex = 2;
        } else if (power > 0.0) {
            speedindex = 1;
        }
        return speedindex;
    }

    @Override
    public float getCurrentPitch(int id, float pitch) {
        double power = this.capability.getVisualPower(null);
        int speedindex = this.getSpeedindex(power);
        if (speedindex == 1) {
            return (float)(power * 2.0 / 25.0);
        }
        if (speedindex == 2) {
            return (float)(power * 2.0 / 50.0);
        }
        if (speedindex == 3) {
            return (float)(power * 2.0 / 100.0);
        }
        return 0.0f;
    }

    private int getSoundLevel() {
        int level = 0;
        for (EnumFacing.Axis axis : EnumFacing.Axis.values()) {
            if (this.getGear(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis)).func_190926_b() && this.getGear(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis)).func_190926_b()) continue;
            ++level;
        }
        return level;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this, this.isBroken);
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = this.gears[i].detach(player);
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        }
        this.isBroken = true;
        this.capability.setPower(0.0, this.from);
        this.updateNeighbors();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.handleSound();
        }
        if (this.shouldUpdate) {
            this.updateNeighbors();
            this.shouldUpdate = false;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            int i = facing.func_176745_a();
            if (this.field_145850_b.field_72995_K) {
                this.gears[i].visualUpdate(this.getGearInPower(facing), this.capability.getVisualPower(facing));
            }
            this.gears[i].tick(this.getGearInPower(facing), this.getGearOutPower(facing));
            if (!this.gears[i].isDirty()) continue;
            this.shouldUpdate = true;
        }
        this.lubricant.tick();
    }

    private double getGearInPower(EnumFacing facing) {
        if (this.capability.isInput(facing)) {
            return this.getExternalPower(facing);
        }
        return this.getInternalPower(facing);
    }

    private double getGearOutPower(EnumFacing facing) {
        if (this.capability.isOutput(facing)) {
            return this.capability.getPower(facing);
        }
        return this.getInternalPower(facing);
    }

    protected double getExternalPower(EnumFacing facing) {
        return ((GearboxMechCapability)this.capability).getExternalPower(facing);
    }

    protected double getInternalPower(EnumFacing facing) {
        return ((GearboxMechCapability)this.capability).getInternalPower(facing);
    }

    public void rotateTile(World world, BlockPos pos, EnumFacing side) {
        int i;
        IBlockState state = world.func_180495_p(pos);
        EnumFacing currentFacing = (EnumFacing)state.func_177229_b((IProperty)BlockGearbox.facing);
        this.capability.setPower(0.0, null);
        GearHelperTile[] temp = new GearHelperTile[this.gears.length];
        for (i = 0; i < this.gears.length; ++i) {
            temp[i] = this.gears[i];
        }
        for (i = 0; i < this.gears.length; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a((int)i).func_176732_a(side.func_176740_k());
            temp[i].setFacing(facing);
            this.gears[facing.func_176745_a()] = temp[i];
        }
        this.from = this.from.func_176732_a(side.func_176740_k());
        world.func_175656_a(pos, state.func_177226_a((IProperty)BlockGearbox.facing, (Comparable)currentFacing.func_176732_a(side.func_176740_k())));
        this.capability.onPowerChange();
    }

    private class GearboxMechCapability
    extends DefaultMechCapability {
        double powerExternal;

        private GearboxMechCapability() {
        }

        @Override
        public void onPowerChange() {
            TileEntityGearbox box = TileEntityGearbox.this;
            box.shouldUpdate = true;
            box.func_70296_d();
        }

        @Override
        public double getPower(EnumFacing from) {
            GearHelperTile gearHelper = TileEntityGearbox.this.getGearHelper(from);
            if (gearHelper != null && gearHelper.isEmpty()) {
                return 0.0;
            }
            double unchangedPower = this.getInternalPower(from);
            if (gearHelper == null) {
                return unchangedPower;
            }
            IGearBehavior behavior = gearHelper.getBehavior();
            return behavior.transformPower(TileEntityGearbox.this, from, gearHelper.getGear(), gearHelper.getData(), unchangedPower);
        }

        @Override
        public double getVisualPower(EnumFacing from) {
            GearHelperTile gearHelper = TileEntityGearbox.this.getGearHelper(from);
            if (gearHelper != null && gearHelper.isEmpty()) {
                return 0.0;
            }
            double unchangedPower = this.isInput(from) ? this.getExternalPower(from) : this.getInternalPower(from);
            if (gearHelper == null) {
                return unchangedPower;
            }
            IGearBehavior behavior = gearHelper.getBehavior();
            return behavior.transformVisualPower(TileEntityGearbox.this, from, gearHelper.getGear(), gearHelper.getData(), unchangedPower);
        }

        protected double getInternalPower(EnumFacing from) {
            if (this.isInput(from)) {
                return TileEntityGearbox.this.capability.power;
            }
            return this.power / (double)Math.max(1, TileEntityGearbox.this.getConnections());
        }

        protected double getExternalPower(EnumFacing from) {
            if (this.isInput(from)) {
                return this.powerExternal;
            }
            return 0.0;
        }

        @Override
        public void setPower(double value, EnumFacing from) {
            GearHelperTile gearHelper = TileEntityGearbox.this.getGearHelper(from);
            if (from == null) {
                this.power = 0.0;
                this.onPowerChange();
            }
            if (this.isInput(from) && (gearHelper == null || gearHelper.isEmpty()) && TileEntityGearbox.this.capability.power != 0.0) {
                this.power = 0.0;
                this.onPowerChange();
            }
            if (gearHelper != null && this.isInput(from) && !gearHelper.isEmpty()) {
                this.powerExternal = value;
                double oldPower = TileEntityGearbox.this.capability.power;
                IGearBehavior behavior = gearHelper.getBehavior();
                value = behavior.transformPower(TileEntityGearbox.this, from, gearHelper.getGear(), gearHelper.getData(), value);
                if (oldPower != value) {
                    TileEntityGearbox.this.capability.power = value;
                    this.onPowerChange();
                }
            }
        }

        @Override
        public boolean isInput(EnumFacing from) {
            return TileEntityGearbox.this.from == from;
        }

        @Override
        public boolean isOutput(EnumFacing from) {
            return TileEntityGearbox.this.from != from;
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            super.writeToNBT(tag);
            tag.func_74780_a("powerExternal", this.powerExternal);
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            super.readFromNBT(tag);
            this.powerExternal = tag.func_74769_h("powerExternal");
        }
    }
}

