/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.tileentity;

import java.util.ArrayList;
import mysticalmechanics.api.DefaultMechCapability;
import mysticalmechanics.api.GearHelperTile;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.MysticalMechanicsAPI;
import mysticalmechanics.block.BlockGearbox;
import mysticalmechanics.tileentity.TileEntityGearbox;
import mysticalmechanics.util.Misc;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileEntityMergebox
extends TileEntityGearbox {
    @Override
    public DefaultMechCapability createCapability() {
        return new MergeboxMechCapability();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        ((MergeboxMechCapability)this.capability).reduceWait();
    }

    @Override
    protected double getInternalPower(EnumFacing facing) {
        return ((MergeboxMechCapability)this.capability).getInternalPower(facing);
    }

    @Override
    protected double getExternalPower(EnumFacing facing) {
        return ((MergeboxMechCapability)this.capability).getExternalPower(facing);
    }

    @Override
    public void updateNeighbors() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        for (EnumFacing f : EnumFacing.field_82609_l) {
            MysticalMechanicsAPI.IMPL.pullPower(this, f, this.capability, !this.getGear(f).func_190926_b());
        }
        this.connections = 0;
        ArrayList<EnumFacing> toUpdate = new ArrayList<EnumFacing>();
        for (EnumFacing f : EnumFacing.field_82609_l) {
            TileEntity t;
            if (f == this.from || (t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f))) == null || !t.hasCapability(MysticalMechanicsAPI.MECH_CAPABILITY, f.func_176734_d())) continue;
            if (!this.getGear(f).func_190926_b() && !toUpdate.contains(f)) {
                toUpdate.add(f);
                ++this.connections;
                continue;
            }
            if (!this.getGear(f).func_190926_b() || !toUpdate.contains(f)) continue;
            toUpdate.remove(f);
            --this.connections;
        }
        if (state.func_177230_c() instanceof BlockGearbox) {
            this.from = (EnumFacing)state.func_177229_b((IProperty)BlockGearbox.facing);
            MysticalMechanicsAPI.IMPL.pushPower(this, this.from, this.capability, !this.getGear(this.from).func_190926_b());
        }
        this.func_70296_d();
    }

    @Override
    public int getConnections() {
        return this.connections;
    }

    private class MergeboxMechCapability
    extends DefaultMechCapability {
        public double[] powerValues = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        public double[] powerValuesExternal = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        public int waitTime;

        private MergeboxMechCapability() {
        }

        public void reduceWait() {
            if (this.waitTime > 0) {
                --this.waitTime;
                if (this.waitTime <= 0) {
                    TileEntityMergebox.this.updateNeighbors();
                }
            }
        }

        @Override
        public void onPowerChange() {
            TileEntityMergebox box = TileEntityMergebox.this;
            box.shouldUpdate = true;
            box.func_70296_d();
        }

        @Override
        public double getPower(EnumFacing from) {
            GearHelperTile gearHelper = TileEntityMergebox.this.getGearHelper(from);
            if (gearHelper != null && gearHelper.isEmpty()) {
                return 0.0;
            }
            double unchangedPower = this.getInternalPower(from);
            if (gearHelper == null) {
                return unchangedPower;
            }
            IGearBehavior behavior = gearHelper.getBehavior();
            return behavior.transformPower(TileEntityMergebox.this, from, gearHelper.getGear(), gearHelper.getData(), unchangedPower);
        }

        @Override
        public double getVisualPower(EnumFacing from) {
            GearHelperTile gearHelper = TileEntityMergebox.this.getGearHelper(from);
            if (gearHelper != null && gearHelper.isEmpty()) {
                return 0.0;
            }
            double unchangedPower = this.isInput(from) ? this.getExternalPower(from) : this.getInternalPower(from);
            if (gearHelper == null) {
                return unchangedPower;
            }
            IGearBehavior behavior = gearHelper.getBehavior();
            return behavior.transformVisualPower(TileEntityMergebox.this, from, gearHelper.getGear(), gearHelper.getData(), unchangedPower);
        }

        private double getInternalPower(EnumFacing from) {
            if (this.isOutput(from) && !TileEntityMergebox.this.getGear(from).func_190926_b() && TileEntityMergebox.this.getConnections() != 0) {
                return Math.max(0.0, this.getPowerInternal());
            }
            if (from != null && !TileEntityMergebox.this.getGear(from).func_190926_b()) {
                return this.powerValues[from.func_176745_a()];
            }
            return 0.0;
        }

        private double getExternalPower(EnumFacing from) {
            if (from != null && this.isInput(from)) {
                return this.powerValuesExternal[from.func_176745_a()];
            }
            return 0.0;
        }

        @Override
        public void setPower(double value, EnumFacing from) {
            GearHelperTile gearHelper = TileEntityMergebox.this.getGearHelper(from);
            if (from == null) {
                for (int i = 0; i < this.powerValues.length; ++i) {
                    this.powerValues[i] = 0.0;
                }
                this.onPowerChange();
            }
            if (from != null && gearHelper != null && !this.isOutput(from)) {
                double oldPower = this.powerValues[from.func_176745_a()];
                this.powerValuesExternal[from.func_176745_a()] = value;
                if (!gearHelper.isEmpty()) {
                    IGearBehavior behavior = gearHelper.getBehavior();
                    value = behavior.transformPower(TileEntityMergebox.this, from, gearHelper.getGear(), gearHelper.getData(), value);
                }
                if (!(oldPower == value || value != 0.0 && gearHelper.isEmpty())) {
                    this.powerValues[from.func_176745_a()] = value;
                    this.waitTime = 20;
                    this.onPowerChange();
                }
            } else if (from == null && TileEntityMergebox.this.isBroken) {
                for (EnumFacing face : EnumFacing.values()) {
                    this.powerValues[face.func_176745_a()] = 0.0;
                    this.onPowerChange();
                }
            }
        }

        private double getPowerInternal() {
            double adjustedPower;
            if (this.waitTime > 0) {
                adjustedPower = 0.0;
            } else {
                double power;
                adjustedPower = 0.0;
                double equalPower = Double.POSITIVE_INFINITY;
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    if (this.isOutput(facing) || !((power = this.powerValues[facing.func_176745_a()]) > 0.0)) continue;
                    equalPower = Math.min(equalPower, power);
                }
                for (EnumFacing face : EnumFacing.values()) {
                    power = this.powerValues[face.func_176745_a()];
                    if (this.isOutput(face) || !Misc.isRoughlyEqual(equalPower, power)) continue;
                    adjustedPower += power;
                }
            }
            if (this.power != adjustedPower) {
                this.power = adjustedPower;
                TileEntityMergebox.this.func_70296_d();
            }
            return this.power;
        }

        @Override
        public boolean isInput(EnumFacing from) {
            return TileEntityMergebox.this.from != from;
        }

        @Override
        public boolean isOutput(EnumFacing from) {
            return TileEntityMergebox.this.from == from;
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            super.readFromNBT(tag);
            this.waitTime = tag.func_74762_e("waitTime");
            this.powerValues[EnumFacing.UP.func_176745_a()] = tag.func_74769_h("mechPowerUp");
            this.powerValues[EnumFacing.DOWN.func_176745_a()] = tag.func_74769_h("mechPowerDown");
            this.powerValues[EnumFacing.NORTH.func_176745_a()] = tag.func_74769_h("mechPowerNorth");
            this.powerValues[EnumFacing.SOUTH.func_176745_a()] = tag.func_74769_h("mechPowerSouth");
            this.powerValues[EnumFacing.EAST.func_176745_a()] = tag.func_74769_h("mechPowerEast");
            this.powerValues[EnumFacing.WEST.func_176745_a()] = tag.func_74769_h("mechPowerWest");
            this.powerValuesExternal[EnumFacing.UP.func_176745_a()] = tag.func_74769_h("mechPowerExternalUp");
            this.powerValuesExternal[EnumFacing.DOWN.func_176745_a()] = tag.func_74769_h("mechPowerExternalDown");
            this.powerValuesExternal[EnumFacing.NORTH.func_176745_a()] = tag.func_74769_h("mechPowerExternalNorth");
            this.powerValuesExternal[EnumFacing.SOUTH.func_176745_a()] = tag.func_74769_h("mechPowerExternalSouth");
            this.powerValuesExternal[EnumFacing.EAST.func_176745_a()] = tag.func_74769_h("mechPowerExternalEast");
            this.powerValuesExternal[EnumFacing.WEST.func_176745_a()] = tag.func_74769_h("mechPowerExternalWest");
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            super.writeToNBT(tag);
            tag.func_74768_a("waitTime", this.waitTime);
            tag.func_74780_a("mechPowerUp", this.powerValues[EnumFacing.UP.func_176745_a()]);
            tag.func_74780_a("mechPowerDown", this.powerValues[EnumFacing.DOWN.func_176745_a()]);
            tag.func_74780_a("mechPowerNorth", this.powerValues[EnumFacing.NORTH.func_176745_a()]);
            tag.func_74780_a("mechPowerSouth", this.powerValues[EnumFacing.SOUTH.func_176745_a()]);
            tag.func_74780_a("mechPowerEast", this.powerValues[EnumFacing.EAST.func_176745_a()]);
            tag.func_74780_a("mechPowerWest", this.powerValues[EnumFacing.WEST.func_176745_a()]);
            tag.func_74780_a("mechPowerExternalUp", this.powerValuesExternal[EnumFacing.UP.func_176745_a()]);
            tag.func_74780_a("mechPowerExternalDown", this.powerValuesExternal[EnumFacing.DOWN.func_176745_a()]);
            tag.func_74780_a("mechPowerExternalNorth", this.powerValuesExternal[EnumFacing.NORTH.func_176745_a()]);
            tag.func_74780_a("mechPowerExternalSouth", this.powerValuesExternal[EnumFacing.SOUTH.func_176745_a()]);
            tag.func_74780_a("mechPowerExternalEast", this.powerValuesExternal[EnumFacing.EAST.func_176745_a()]);
            tag.func_74780_a("mechPowerExternalWest", this.powerValuesExternal[EnumFacing.WEST.func_176745_a()]);
        }
    }
}

