/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.util;

import java.util.List;
import javax.annotation.Nullable;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.IGearData;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class FanBehavior
implements IGearBehavior {
    @Override
    public double transformPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, double power) {
        return 0.0;
    }

    @Override
    public double transformVisualPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, double power) {
        return power;
    }

    @Override
    public void visualUpdate(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear) {
    }

    @Override
    public boolean canTick(ItemStack gear) {
        return true;
    }

    @Override
    public void tick(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double powerIn, double powerOut) {
        IMechCapability capability = (IMechCapability)tile.getCapability(MysticalMechanicsAPI.MECH_CAPABILITY, facing);
        if (capability != null && capability.isOutput(facing)) {
            World world = tile.func_145831_w();
            AxisAlignedBB aabb = new AxisAlignedBB(tile.func_174877_v().func_177972_a(facing));
            double distance = this.getBlowDistance(powerIn);
            double vx = facing.func_82601_c();
            double vy = facing.func_96559_d();
            double vz = facing.func_82599_e();
            double blowVelocity = this.getBlowVelocity(powerIn);
            aabb = aabb.func_72321_a(vx * distance, vy * distance, vz * distance);
            List entities = world.func_72872_a(Entity.class, aabb);
            for (Entity entity : entities) {
                entity.func_70024_g(vx * blowVelocity, vy * blowVelocity, vz * blowVelocity);
            }
        }
    }

    private double getBlowVelocity(double power) {
        return power / 800.0;
    }

    private double getBlowDistance(double power) {
        return Math.sqrt(power) / 3.0;
    }
}

