/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.util;

import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.IGearData;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class VarGearBehavior
implements IGearBehavior {
    @Override
    public double transformPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double power) {
        if (data instanceof Data) {
            Data lastPower = (Data)data;
            if (lastPower.size() == 0) {
                return 0.0;
            }
            double sum = lastPower.sum();
            return sum / (double)lastPower.size();
        }
        return 0.0;
    }

    @Override
    public double transformVisualPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double power) {
        if (data instanceof Data) {
            Data lastPower = (Data)data;
            if (lastPower.size() == 0) {
                return 0.0;
            }
            double sum = lastPower.sum();
            return sum / (double)lastPower.size();
        }
        return 0.0;
    }

    @Override
    public void tick(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double powerIn, double powerOut) {
        if (data instanceof Data) {
            ((Data)data).add(powerIn);
        }
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public IGearData createData() {
        return new Data();
    }

    static class Data
    implements IGearData {
        LinkedList<Double> lastPower = new LinkedList();

        Data() {
        }

        public double sum() {
            double sum = 0.0;
            Iterator iterator = this.lastPower.iterator();
            while (iterator.hasNext()) {
                double power = (Double)iterator.next();
                sum += power;
            }
            return sum;
        }

        public int size() {
            return this.lastPower.size();
        }

        public void add(double power) {
            this.lastPower.add(power);
            if (this.lastPower.size() > 60) {
                this.lastPower.removeFirst();
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            NBTTagList tagPowers = tag.func_150295_c("lastPower", 6);
            this.lastPower.clear();
            for (NBTBase base : tagPowers) {
                this.lastPower.add(((NBTTagDouble)base).func_150286_g());
            }
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            NBTTagList tagPowers = new NBTTagList();
            Iterator iterator = this.lastPower.iterator();
            while (iterator.hasNext()) {
                double power = (Double)iterator.next();
                tagPowers.func_74742_a((NBTBase)new NBTTagDouble(power));
            }
            tag.func_74782_a("lastPower", (NBTBase)tagPowers);
            return tag;
        }

        @Override
        public boolean isDirty() {
            return true;
        }
    }
}

