/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.api;

import javax.annotation.Nullable;
import mysticalmechanics.api.GearHelper;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.MysticalMechanicsAPI;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;

public class GearHelperTile
extends GearHelper {
    TileEntity tile;
    EnumFacing facing;
    double angle;
    double lastAngle;

    public GearHelperTile(TileEntity tile, EnumFacing facing) {
        this.tile = tile;
        this.facing = facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getLastAngle() {
        return this.lastAngle;
    }

    public double getPartialAngle(double partialTicks) {
        return MathHelper.func_151238_b((double)this.getLastAngle(), (double)this.getAngle(), (double)partialTicks);
    }

    @Override
    public void attach(@Nullable EntityPlayer player, ItemStack stack) {
        super.attach(player, stack);
        IGearBehavior behavior = this.getBehavior();
        behavior.onAttach(this.tile, this.getFacing(), this.gear, this.data, player);
        this.tile.func_145831_w().func_184133_a(null, this.tile.func_174877_v(), MysticalMechanicsAPI.GEAR_ADD, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public ItemStack detach(@Nullable EntityPlayer player) {
        IGearBehavior behavior = this.getBehavior();
        ItemStack stack = behavior.onDetach(this.tile, this.getFacing(), this.gear, this.data, player);
        super.detach(player);
        this.tile.func_145831_w().func_184133_a(null, this.tile.func_174877_v(), MysticalMechanicsAPI.GEAR_REMOVE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.angle = 0.0;
        this.lastAngle = 0.0;
        return stack;
    }

    public void tick(double in, double out) {
        IGearBehavior behavior = this.getBehavior();
        behavior.tick(this.tile, this.getFacing(), this.gear, this.data, in, out);
    }

    public void visualUpdate(double in, double out) {
        IGearBehavior behavior = this.getBehavior();
        behavior.visualUpdate(this.tile, this.getFacing(), this.gear, this.data, in, out);
        this.updateAngle(out);
    }

    private void updateAngle(double power) {
        this.lastAngle = this.angle;
        this.angle += power;
    }
}

