/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.api.lubricant;

import mysticalmechanics.api.MysticalMechanicsAPI;
import mysticalmechanics.api.lubricant.ILubricant;
import net.minecraft.nbt.NBTTagCompound;

public class LubricantStack {
    private ILubricant lubricant;
    private int amount;

    public LubricantStack(ILubricant lubricant, int amount) {
        this.lubricant = lubricant;
        this.amount = amount;
    }

    public LubricantStack(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public ILubricant getLubricant() {
        return this.lubricant;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public boolean isEmpty() {
        return this.amount <= 0;
    }

    public void increment(int n) {
        this.amount += n;
    }

    public void deplete(int n) {
        this.amount -= n;
    }

    NBTTagCompound writeToNBT(NBTTagCompound tag) {
        this.lubricant.writeToNBT(tag);
        tag.func_74768_a("amount", this.amount);
        return tag;
    }

    void readFromNBT(NBTTagCompound tag) {
        this.lubricant = MysticalMechanicsAPI.IMPL.deserializeLubricant(tag);
        this.amount = tag.func_74762_e("amount");
    }

    public NBTTagCompound serializeNBT() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public String getUnlocalizedName() {
        return this.lubricant.getUnlocalizedName();
    }
}

