/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.compat;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mysticalmechanics.api.IMechUnit;
import mysticalmechanics.api.MysticalMechanicsAPI;
import mysticalmechanics.compat.TheOneProbe;
import mysticalmechanics.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PowerUnit
implements IElement {
    public double power;
    public boolean input;
    public boolean output;
    public ItemStack gear;
    public EnumFacing facing;

    public PowerUnit(double power, boolean input, boolean output, ItemStack gear, EnumFacing facing) {
        this.power = power;
        this.input = input;
        this.output = output;
        this.gear = gear;
        this.facing = facing;
    }

    @SideOnly(value=Side.CLIENT)
    private String format() {
        IMechUnit unit = MysticalMechanicsAPI.IMPL.getDefaultUnit();
        if (this.input == this.output) {
            return I18n.func_135052_a((String)"mysticalmechanics.probe.power", (Object[])new Object[]{unit.format(this.power)});
        }
        if (this.input) {
            return I18n.func_135052_a((String)"mysticalmechanics.probe.input_power", (Object[])new Object[]{unit.format(this.power)});
        }
        return I18n.func_135052_a((String)"mysticalmechanics.probe.output_power", (Object[])new Object[]{unit.format(this.power)});
    }

    @SideOnly(value=Side.CLIENT)
    public void render(int x, int y) {
        String text = this.format();
        if (!this.gear.func_190926_b()) {
            RenderUtil.renderItemStack(Minecraft.func_71410_x(), Minecraft.func_71410_x().func_175599_af(), this.gear, x, y, this.facing.func_176610_l().toUpperCase().substring(0, 1));
        }
        RenderUtil.renderText(Minecraft.func_71410_x(), x + 10, y, text);
    }

    @SideOnly(value=Side.CLIENT)
    public int getWidth() {
        String text = this.format();
        return Minecraft.func_71410_x().field_71466_p.func_78256_a(text) + 10;
    }

    @SideOnly(value=Side.CLIENT)
    public int getHeight() {
        return 10;
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer wrapper = new PacketBuffer(buf);
        wrapper.writeDouble(this.power);
        wrapper.writeBoolean(this.input);
        wrapper.writeBoolean(this.output);
        wrapper.func_150788_a(this.gear);
        wrapper.func_179249_a((Enum)this.facing);
    }

    public int getID() {
        return TheOneProbe.ELEMENT_POWERUNIT;
    }

    public static class Factory
    implements IElementFactory {
        public IElement createElement(ByteBuf buf) {
            PacketBuffer wrapper = new PacketBuffer(buf);
            double power = wrapper.readDouble();
            boolean input = wrapper.readBoolean();
            boolean output = wrapper.readBoolean();
            ItemStack gear = null;
            try {
                gear = wrapper.func_150791_c();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            EnumFacing facing = (EnumFacing)wrapper.func_179257_a(EnumFacing.class);
            return new PowerUnit(power, input, output, gear, facing);
        }
    }
}

