/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.tileentity;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import javax.annotation.Nullable;
import mysticalmechanics.api.DefaultMechCapability;
import mysticalmechanics.api.GearHelperTile;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.IGearbox;
import mysticalmechanics.api.MysticalMechanicsAPI;
import mysticalmechanics.block.BlockConverterBWM;
import mysticalmechanics.util.Misc;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityConverterBWM
extends TileEntity
implements ITickable,
IGearbox {
    protected boolean isBroken;
    ConverterMystMechCapability capabilityMystMech;
    ConverterBWMCapability capabilityBWM = new ConverterBWMCapability();
    GearHelperTile gear;
    public boolean shouldUpdate;

    public TileEntityConverterBWM() {
        this.capabilityMystMech = new ConverterMystMechCapability();
        this.gear = new GearHelperTile(this, null){

            @Override
            public EnumFacing getFacing() {
                return TileEntityConverterBWM.this.getSideMystMech();
            }
        };
    }

    public boolean canConvertToBWM() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockConverterBWM) {
            return (Boolean)state.func_177229_b((IProperty)BlockConverterBWM.on) == false;
        }
        return false;
    }

    public boolean canConvertToMM() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockConverterBWM) {
            return (Boolean)state.func_177229_b((IProperty)BlockConverterBWM.on);
        }
        return false;
    }

    private int convertToBWM() {
        if (this.canConvertToBWM() && this.capabilityMystMech.power >= 1.0) {
            return (int)Math.ceil(Math.log(this.capabilityMystMech.power * 0.1 + 1.0) / Math.log(2.0));
        }
        return 0;
    }

    private double convertToMystMech() {
        if (this.canConvertToMM()) {
            return Math.pow(2.0, this.capabilityBWM.power) - 1.0;
        }
        return 0.0;
    }

    private double getGearInPower(EnumFacing facing) {
        if (this.capabilityMystMech.isInput(facing)) {
            return this.capabilityMystMech.getExternalPower(facing);
        }
        return this.capabilityMystMech.getInternalPower(facing);
    }

    private double getGearOutPower(EnumFacing facing) {
        if (this.capabilityMystMech.isOutput(facing)) {
            return this.capabilityMystMech.getExternalPower(facing);
        }
        return this.capabilityMystMech.getInternalPower(facing);
    }

    public EnumFacing getSideBWM() {
        return this.getFacing().func_176734_d();
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return (EnumFacing)state.func_177229_b((IProperty)BlockConverterBWM.facing);
    }

    public EnumFacing getSideMystMech() {
        return this.getFacing();
    }

    public void func_73660_a() {
        int powerBWM;
        if (this.shouldUpdate) {
            this.updateNeighbors();
            this.shouldUpdate = false;
        }
        if (!this.field_145850_b.field_72995_K && this.capabilityBWM.power != (powerBWM = this.capabilityBWM.calculateInput())) {
            this.capabilityBWM.power = powerBWM;
            this.capabilityMystMech.onPowerChange();
        }
        double powerIn = this.getGearInPower(this.gear.getFacing());
        double powerOut = this.getGearOutPower(this.gear.getFacing());
        this.gear.tick(powerIn, powerOut);
        if (this.gear.isDirty()) {
            this.shouldUpdate = true;
        }
        if (this.field_145850_b.field_72995_K) {
            this.gear.visualUpdate(powerIn, this.capabilityMystMech.getVisualPower(this.getSideMystMech()));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capabilityMystMech.writeToNBT(tag);
        tag.func_74768_a("bwmPower", this.capabilityBWM.power);
        tag.func_74782_a("side", (NBTBase)this.gear.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capabilityMystMech.readFromNBT(tag);
        this.capabilityBWM.power = tag.func_74762_e("bwmPower");
        this.gear.readFromNBT(tag.func_74775_l("side"));
        if (tag.func_74764_b("gear")) {
            this.gear.setGear(new ItemStack(tag.func_74775_l("gear")));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY && (facing == null || facing == this.getSideMystMech())) {
            return true;
        }
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER && facing == this.getSideBWM()) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY && (facing == null || facing == this.getSideMystMech())) {
            return (T)MysticalMechanicsAPI.MECH_CAPABILITY.cast((Object)this.capabilityMystMech);
        }
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER && facing == this.getSideBWM()) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this.capabilityBWM);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void updateNeighbors() {
        EnumFacing from = this.getSideMystMech();
        if (this.capabilityMystMech.isInput(from)) {
            MysticalMechanicsAPI.IMPL.pullPower(this, from, this.capabilityMystMech, !this.getGear(from).func_190926_b());
        }
        if (this.capabilityMystMech.isOutput(from)) {
            MysticalMechanicsAPI.IMPL.pushPower(this, from, this.capabilityMystMech, !this.getGear(from).func_190926_b());
        }
        this.func_70296_d();
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        EnumFacing attachSide = side;
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        if (side == this.getSideBWM()) {
            boolean newOn;
            this.capabilityBWM.power = 0;
            this.capabilityMystMech.power = 0.0;
            this.capabilityMystMech.onPowerChange();
            boolean bl = newOn = (Boolean)state.func_177229_b((IProperty)BlockConverterBWM.on) == false;
            if (newOn) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("mysticalmechanics.tooltip.bwm_converter.on", new Object[0]), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("mysticalmechanics.tooltip.bwm_converter.off", new Object[0]), true);
            }
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockConverterBWM.on, (Comparable)Boolean.valueOf(newOn)));
            return true;
        }
        if (player.func_70093_af()) {
            attachSide = attachSide.func_176734_d();
        }
        if (!heldItem.func_190926_b() && this.canAttachGear(attachSide, heldItem) && this.getGear(attachSide).func_190926_b() && MysticalMechanicsAPI.IMPL.isValidGear(heldItem)) {
            ItemStack gear = heldItem.func_77946_l();
            gear.func_190920_e(1);
            this.attachGear(attachSide, gear, player);
            heldItem.func_190918_g(1);
            if (heldItem.func_190926_b()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            return true;
        }
        if (!this.getGear(attachSide).func_190926_b()) {
            ItemStack gear = this.detachGear(attachSide, player);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v, gear));
            }
            return true;
        }
        return false;
    }

    public void rotateTile(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing currentFacing = (EnumFacing)state.func_177229_b((IProperty)BlockConverterBWM.facing);
        this.capabilityMystMech.setPower(0.0, null);
        world.func_175656_a(pos, state.func_177226_a((IProperty)BlockConverterBWM.facing, (Comparable)currentFacing.func_176732_a(side.func_176740_k())));
        this.capabilityMystMech.onPowerChange();
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        ItemStack stack = this.gear.detach(player);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        }
        this.isBroken = true;
        this.capabilityMystMech.setPower(0.0, null);
        this.updateNeighbors();
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this, this.isBroken);
    }

    @Override
    public void attachGear(EnumFacing facing, ItemStack stack, EntityPlayer player) {
        if (!this.canAttachGear(facing, stack)) {
            return;
        }
        this.gear.attach(null, stack);
        this.capabilityMystMech.onPowerChange();
        this.field_145850_b.func_190524_a(this.field_174879_c.func_177972_a(this.getSideMystMech()), this.field_145854_h, this.field_174879_c);
    }

    @Override
    public ItemStack detachGear(EnumFacing facing, EntityPlayer player) {
        if (!this.canAttachGear(facing)) {
            return ItemStack.field_190927_a;
        }
        ItemStack removed = this.gear.detach(null);
        this.capabilityMystMech.onPowerChange();
        this.field_145850_b.func_190524_a(this.field_174879_c.func_177972_a(this.getSideMystMech()), this.field_145854_h, this.field_174879_c);
        return removed;
    }

    @Override
    public ItemStack getGear(EnumFacing facing) {
        return this.gear.getGear();
    }

    @Override
    public boolean canAttachGear(EnumFacing facing, ItemStack stack) {
        return this.canAttachGear(facing) && this.gear.canAttach(stack);
    }

    @Override
    public boolean canAttachGear(EnumFacing facing) {
        return facing == this.getSideMystMech();
    }

    @Override
    public int getConnections() {
        return 1;
    }

    private class ConverterMystMechCapability
    extends DefaultMechCapability {
        double powerExternal;

        private ConverterMystMechCapability() {
        }

        @Override
        public double getPower(EnumFacing from) {
            if (from == null) {
                return super.getPower(from);
            }
            GearHelperTile gearHelper = TileEntityConverterBWM.this.gear;
            if (gearHelper.isEmpty() || !TileEntityConverterBWM.this.canConvertToMM()) {
                return 0.0;
            }
            IGearBehavior behavior = gearHelper.getBehavior();
            return behavior.transformPower(TileEntityConverterBWM.this, from, gearHelper.getGear(), gearHelper.getData(), this.getInternalPower(from));
        }

        private double getInternalPower(EnumFacing from) {
            if (from == TileEntityConverterBWM.this.getSideMystMech()) {
                return TileEntityConverterBWM.this.canConvertToMM() ? TileEntityConverterBWM.this.convertToMystMech() : this.power;
            }
            return 0.0;
        }

        public double getExternalPower(EnumFacing from) {
            if (from == TileEntityConverterBWM.this.getSideMystMech()) {
                return this.powerExternal;
            }
            return 0.0;
        }

        @Override
        public void setPower(double value, EnumFacing from) {
            if (from == null) {
                super.setPower(value, from);
            }
            if (from == TileEntityConverterBWM.this.getSideMystMech()) {
                double transformedPower;
                this.powerExternal = value;
                GearHelperTile gearHelper = TileEntityConverterBWM.this.gear;
                if (gearHelper.isEmpty()) {
                    transformedPower = 0.0;
                } else {
                    IGearBehavior behavior = gearHelper.getBehavior();
                    transformedPower = behavior.transformPower(TileEntityConverterBWM.this, from, gearHelper.getGear(), gearHelper.getData(), value);
                }
                if (transformedPower != this.power) {
                    super.setPower(transformedPower, from);
                    TileEntityConverterBWM.this.field_145850_b.func_190524_a(TileEntityConverterBWM.this.field_174879_c.func_177972_a(TileEntityConverterBWM.this.getSideBWM()), TileEntityConverterBWM.this.field_145854_h, TileEntityConverterBWM.this.field_174879_c);
                }
            }
        }

        @Override
        public double getVisualPower(EnumFacing from) {
            if (from == null) {
                return super.getPower(from);
            }
            if (from != TileEntityConverterBWM.this.getSideMystMech()) {
                return 0.0;
            }
            GearHelperTile gearHelper = TileEntityConverterBWM.this.gear;
            if (gearHelper.isEmpty()) {
                return 0.0;
            }
            IGearBehavior behavior = gearHelper.getBehavior();
            return behavior.transformVisualPower(TileEntityConverterBWM.this, from, gearHelper.getGear(), gearHelper.getData(), this.getInternalPower(from));
        }

        @Override
        public void onPowerChange() {
            TileEntityConverterBWM.this.shouldUpdate = true;
            TileEntityConverterBWM.this.func_70296_d();
        }

        @Override
        public boolean isInput(EnumFacing from) {
            return from == TileEntityConverterBWM.this.getSideMystMech() && TileEntityConverterBWM.this.canConvertToBWM();
        }

        @Override
        public boolean isOutput(EnumFacing from) {
            return from == TileEntityConverterBWM.this.getSideMystMech() && TileEntityConverterBWM.this.canConvertToMM();
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            super.readFromNBT(tag);
            this.powerExternal = tag.func_74769_h("powerExternal");
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            super.writeToNBT(tag);
            tag.func_74780_a("powerExternal", this.powerExternal);
        }
    }

    private class ConverterBWMCapability
    extends CapabilityMechanicalPower.Default {
        int power;

        private ConverterBWMCapability() {
        }

        public int getMechanicalInput(EnumFacing facing) {
            if (facing == TileEntityConverterBWM.this.getSideBWM()) {
                return BWMAPI.IMPLEMENTATION.getPowerOutput(TileEntityConverterBWM.this.field_145850_b, TileEntityConverterBWM.this.field_174879_c.func_177972_a(facing), facing.func_176734_d());
            }
            return 0;
        }

        public int getMechanicalOutput(EnumFacing facing) {
            if (facing == TileEntityConverterBWM.this.getSideBWM()) {
                return TileEntityConverterBWM.this.convertToBWM();
            }
            return -1;
        }

        public int getMaximumInput(EnumFacing facing) {
            return Integer.MAX_VALUE;
        }

        public int getMinimumInput(EnumFacing facing) {
            return 0;
        }

        public Block getBlock() {
            return TileEntityConverterBWM.this.func_145838_q();
        }

        public BlockPos getBlockPos() {
            return TileEntityConverterBWM.this.func_174877_v();
        }

        public World getBlockWorld() {
            return TileEntityConverterBWM.this.func_145831_w();
        }
    }
}

