/*
 * Decompiled with CFR 0.152.
 */
package mysticalmechanics.tileentity;

import javax.annotation.Nullable;
import mysticalmechanics.api.DefaultMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityCreativeMechSource
extends TileEntity
implements ITickable {
    int ticksExisted = 0;
    private double[] wantedPower = new double[]{10.0, 20.0, 40.0, 80.0, 160.0, 320.0};
    private double currentPower = 10.0;
    private int wantedPowerIndex = 0;
    private boolean isBroken;
    public DefaultMechCapability capability = new DefaultMechCapability(){

        @Override
        public double getPower(EnumFacing from) {
            return TileEntityCreativeMechSource.this.currentPower;
        }

        @Override
        public void setPower(double value, EnumFacing from) {
            if (from == null) {
                TileEntityCreativeMechSource.this.currentPower = value;
                this.onPowerChange();
            }
        }

        @Override
        public boolean isOutput(EnumFacing face) {
            return true;
        }

        @Override
        public boolean isInput(EnumFacing face) {
            return false;
        }

        @Override
        public void onPowerChange() {
            TileEntityCreativeMechSource.this.updateNeighbors();
            TileEntityCreativeMechSource.this.func_70296_d();
        }
    };

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74780_a("mech_power", this.wantedPower[this.wantedPowerIndex]);
        tag.func_74768_a("level", this.wantedPowerIndex);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("mech_power")) {
            this.capability.power = tag.func_74769_h("mech_power");
        }
        this.wantedPowerIndex = tag.func_74762_e("level") % this.wantedPower.length;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY) {
            DefaultMechCapability result = this.capability;
            return (T)result;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.wantedPowerIndex = player.func_70093_af() ? (this.wantedPowerIndex + this.wantedPower.length - 1) % this.wantedPower.length : (this.wantedPowerIndex + 1) % this.wantedPower.length;
        player.func_146105_b((ITextComponent)new TextComponentTranslation("mysticalmechanics.tooltip.creative_source.set", new Object[]{this.wantedPower[this.wantedPowerIndex]}), true);
        return true;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.capability.setPower(0.0, null);
        this.updateNeighbors();
    }

    public void updateNeighbors() {
        for (EnumFacing f : EnumFacing.values()) {
            MysticalMechanicsAPI.IMPL.pushPower(this, f, this.capability, true);
        }
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        double wantedPower = this.wantedPower[this.wantedPowerIndex];
        if (this.capability.getPower(null) != wantedPower) {
            this.capability.setPower(wantedPower, null);
        }
    }

    public boolean isBroken() {
        return this.isBroken;
    }
}

