/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.world;

import logictechcorp.netherex.block.BlockNetherPortal;
import logictechcorp.netherex.init.NetherExBlocks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;

public class TeleporterNetherEx
extends Teleporter {
    public TeleporterNetherEx(WorldServer world) {
        super(world);
    }

    public void func_180266_a(Entity entity, float rotationYaw) {
        if (!this.func_180620_b(entity, rotationYaw)) {
            this.func_85188_a(entity);
            this.func_180620_b(entity, rotationYaw);
        }
    }

    public boolean func_180620_b(Entity entity, float rotationYaw) {
        double portalDistanceSq = -1.0;
        boolean portalExists = true;
        BlockPos portalPos = BlockPos.field_177992_a;
        long portalChunk = ChunkPos.func_77272_a((int)MathHelper.func_76128_c((double)entity.field_70165_t), (int)MathHelper.func_76128_c((double)entity.field_70161_v));
        if (this.field_85191_c.containsKey(portalChunk)) {
            Teleporter.PortalPosition portalPosition = (Teleporter.PortalPosition)this.field_85191_c.get(portalChunk);
            portalDistanceSq = 0.0;
            portalPos = portalPosition;
            portalPosition.field_85087_d = this.field_85192_a.func_82737_E();
            portalExists = false;
        } else {
            BlockPos entityPos = new BlockPos(entity);
            for (int x = -128; x <= 128; ++x) {
                for (int z = -128; z <= 128; ++z) {
                    BlockPos currentPos = entityPos.func_177982_a(x, this.field_85192_a.func_72940_L() - 1 - entityPos.func_177956_o(), z);
                    while (currentPos.func_177956_o() >= 0) {
                        BlockPos newPos = currentPos.func_177977_b();
                        if (this.field_85192_a.func_180495_p(currentPos).func_177230_c() == NetherExBlocks.NETHER_PORTAL) {
                            newPos = currentPos.func_177977_b();
                            while (this.field_85192_a.func_180495_p(newPos).func_177230_c() == NetherExBlocks.NETHER_PORTAL) {
                                currentPos = newPos;
                                newPos = newPos.func_177977_b();
                            }
                            double distanceSqToEntity = currentPos.func_177951_i((Vec3i)entityPos);
                            if (portalDistanceSq < 0.0 || distanceSqToEntity < portalDistanceSq) {
                                portalDistanceSq = distanceSqToEntity;
                                portalPos = currentPos;
                            }
                        }
                        currentPos = newPos;
                    }
                }
            }
        }
        if (portalDistanceSq >= 0.0) {
            boolean spawnPosCCWBlocked;
            if (portalExists) {
                this.field_85191_c.put(portalChunk, (Object)new Teleporter.PortalPosition((Teleporter)this, portalPos, this.field_85192_a.func_82737_E()));
            }
            double teleportPosX = (double)portalPos.func_177958_n() + 0.5;
            double teleportPosY = portalPos.func_177956_o();
            double teleportPosZ = (double)portalPos.func_177952_p() + 0.5;
            EnumFacing teleportFacing = this.field_85192_a.func_180495_p(portalPos.func_177978_c()).func_177230_c() == NetherExBlocks.NETHER_PORTAL && this.field_85192_a.func_180495_p(portalPos.func_177974_f()).func_177230_c() == NetherExBlocks.NETHER_PORTAL ? EnumFacing.SOUTH : (this.field_85192_a.func_180495_p(portalPos.func_177974_f()).func_177230_c() == NetherExBlocks.NETHER_PORTAL && this.field_85192_a.func_180495_p(portalPos.func_177968_d()).func_177230_c() == NetherExBlocks.NETHER_PORTAL ? EnumFacing.WEST : (this.field_85192_a.func_180495_p(portalPos.func_177968_d()).func_177230_c() == NetherExBlocks.NETHER_PORTAL && this.field_85192_a.func_180495_p(portalPos.func_177976_e()).func_177230_c() == NetherExBlocks.NETHER_PORTAL ? EnumFacing.NORTH : (this.field_85192_a.func_180495_p(portalPos.func_177976_e()).func_177230_c() == NetherExBlocks.NETHER_PORTAL && this.field_85192_a.func_180495_p(portalPos.func_177978_c()).func_177230_c() == NetherExBlocks.NETHER_PORTAL ? EnumFacing.EAST : (this.field_85192_a.func_180495_p(portalPos.func_177978_c()).func_177230_c() == NetherExBlocks.NETHER_PORTAL ? EnumFacing.EAST : (this.field_85192_a.func_180495_p(portalPos.func_177974_f()).func_177230_c() == NetherExBlocks.NETHER_PORTAL ? EnumFacing.SOUTH : (this.field_85192_a.func_180495_p(portalPos.func_177968_d()).func_177230_c() == NetherExBlocks.NETHER_PORTAL ? EnumFacing.WEST : (this.field_85192_a.func_180495_p(portalPos.func_177976_e()).func_177230_c() == NetherExBlocks.NETHER_PORTAL ? EnumFacing.NORTH : entity.func_184172_bi())))))));
            EnumFacing horizontalFacing = EnumFacing.func_176731_b((int)(MathHelper.func_76141_d((float)(rotationYaw * 4.0f / 360.0f + 0.5f)) & 3));
            EnumFacing teleportFacingCCW = teleportFacing.func_176735_f();
            BlockPos spawnPos = portalPos.func_177972_a(teleportFacing);
            BlockPos spawnPosCCW = spawnPos.func_177972_a(teleportFacingCCW);
            boolean spawnPosBlocked = !this.field_85192_a.func_175623_d(spawnPos) || !this.field_85192_a.func_175623_d(spawnPos.func_177984_a());
            boolean bl = spawnPosCCWBlocked = !this.field_85192_a.func_175623_d(spawnPosCCW) || !this.field_85192_a.func_175623_d(spawnPosCCW.func_177984_a());
            if (spawnPosCCWBlocked && spawnPosBlocked) {
                portalPos = portalPos.func_177972_a(teleportFacingCCW);
                teleportFacing = teleportFacing.func_176734_d();
                teleportFacingCCW = teleportFacingCCW.func_176734_d();
                BlockPos spawnPosTest = portalPos.func_177972_a(teleportFacing);
                BlockPos spawnPosCCWTest = spawnPosTest.func_177972_a(teleportFacingCCW);
                spawnPosBlocked = !this.field_85192_a.func_175623_d(spawnPosTest) || !this.field_85192_a.func_175623_d(spawnPosTest.func_177984_a());
                spawnPosCCWBlocked = !this.field_85192_a.func_175623_d(spawnPosCCWTest) || !this.field_85192_a.func_175623_d(spawnPosCCWTest.func_177984_a());
            }
            float offsetX = 0.5f;
            float offsetZ = 0.5f;
            if (!spawnPosCCWBlocked && spawnPosBlocked) {
                offsetX = 1.0f;
            } else if (spawnPosCCWBlocked && !spawnPosBlocked) {
                offsetX = 0.0f;
            } else if (spawnPosCCWBlocked) {
                offsetZ = 0.0f;
            }
            teleportPosX += (double)((float)teleportFacingCCW.func_82601_c() * offsetX + (float)teleportFacing.func_82601_c() * offsetZ);
            teleportPosZ += (double)((float)teleportFacingCCW.func_82599_e() * offsetX + (float)teleportFacing.func_82599_e() * offsetZ);
            float motionXPositive = 0.0f;
            float motionXNegative = 0.0f;
            float motionZPositive = 0.0f;
            float motionZNegative = 0.0f;
            if (teleportFacing == horizontalFacing) {
                motionXPositive = 1.0f;
                motionXNegative = 1.0f;
            } else if (teleportFacing == horizontalFacing.func_176734_d()) {
                motionXPositive = -1.0f;
                motionXNegative = -1.0f;
            } else if (teleportFacing == horizontalFacing.func_176746_e()) {
                motionZPositive = 1.0f;
                motionZNegative = -1.0f;
            } else {
                motionZPositive = -1.0f;
                motionZNegative = 1.0f;
            }
            double motionX = entity.field_70159_w;
            double motionZ = entity.field_70179_y;
            entity.field_70159_w = motionX * (double)motionXPositive + motionZ * (double)motionZNegative;
            entity.field_70179_y = motionX * (double)motionZPositive + motionZ * (double)motionXNegative;
            entity.field_70177_z = rotationYaw - (float)(horizontalFacing.func_176736_b() * 90) + (float)(teleportFacing.func_176736_b() * 90);
            entity.func_70012_b(teleportPosX, teleportPosY, teleportPosZ, entity.field_70177_z, entity.field_70125_A);
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entity) {
        int x;
        int y;
        double adjustedPosZ;
        int z;
        double adjustedPosX;
        int x2;
        double portalDistance = -1.0;
        int entityPosX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityPosY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int entityPosZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        int adjustedEntityPosX = entityPosX;
        int adjustedEntityPosY = entityPosY;
        int adjustedEntityPosZ = entityPosZ;
        int offset = 0;
        int randomOffset = this.field_77187_a.nextInt(4);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (x2 = entityPosX - 16; x2 <= entityPosX + 16; ++x2) {
            adjustedPosX = (double)x2 + 0.5 - entity.field_70165_t;
            for (z = entityPosZ - 16; z <= entityPosZ + 16; ++z) {
                adjustedPosZ = (double)z + 0.5 - entity.field_70161_v;
                block2: for (y = this.field_85192_a.func_72940_L() - 1; y >= 0; --y) {
                    if (!this.field_85192_a.func_175623_d((BlockPos)mutableBlockPos.func_181079_c(x2, y, z))) continue;
                    while (y > 0 && this.field_85192_a.func_175623_d((BlockPos)mutableBlockPos.func_181079_c(x2, y - 1, z))) {
                        --y;
                    }
                    for (int k3 = randomOffset; k3 < randomOffset + 4; ++k3) {
                        int l3 = k3 % 2;
                        int i4 = 1 - l3;
                        if (k3 % 4 >= 2) {
                            l3 = -l3;
                            i4 = -i4;
                        }
                        for (int offsetZ = 0; offsetZ < 3; ++offsetZ) {
                            for (int offsetX = 0; offsetX < 4; ++offsetX) {
                                for (int offsetY = -1; offsetY < 4; ++offsetY) {
                                    int posX = x2 + (offsetX - 1) * l3 + offsetZ * i4;
                                    int posY = y + offsetY;
                                    int posZ = z + (offsetX - 1) * i4 - offsetZ * l3;
                                    mutableBlockPos.func_181079_c(posX, posY, posZ);
                                    if (offsetY < 0 && !this.field_85192_a.func_180495_p((BlockPos)mutableBlockPos).func_185904_a().func_76220_a() || offsetY >= 0 && !this.field_85192_a.func_175623_d((BlockPos)mutableBlockPos)) continue block2;
                                }
                            }
                        }
                        double adjustedPosY = (double)y + 0.5 - entity.field_70163_u;
                        double adjustedPos = adjustedPosX * adjustedPosX + adjustedPosY * adjustedPosY + adjustedPosZ * adjustedPosZ;
                        if (!(portalDistance < 0.0) && !(adjustedPos < portalDistance)) continue;
                        portalDistance = adjustedPos;
                        adjustedEntityPosX = x2;
                        adjustedEntityPosY = y;
                        adjustedEntityPosZ = z;
                        offset = k3 % 4;
                    }
                }
            }
        }
        if (portalDistance < 0.0) {
            for (x2 = entityPosX - 16; x2 <= entityPosX + 16; ++x2) {
                adjustedPosX = (double)x2 + 0.5 - entity.field_70165_t;
                for (z = entityPosZ - 16; z <= entityPosZ + 16; ++z) {
                    adjustedPosZ = (double)z + 0.5 - entity.field_70161_v;
                    block10: for (y = this.field_85192_a.func_72940_L() - 1; y >= 0; --y) {
                        if (!this.field_85192_a.func_175623_d((BlockPos)mutableBlockPos.func_181079_c(x2, y, z))) continue;
                        while (y > 0 && this.field_85192_a.func_175623_d((BlockPos)mutableBlockPos.func_181079_c(x2, y - 1, z))) {
                            --y;
                        }
                        for (int offsetZ = randomOffset; offsetZ < randomOffset + 2; ++offsetZ) {
                            int j8 = offsetZ % 2;
                            int j9 = 1 - j8;
                            for (int offsetX = 0; offsetX < 4; ++offsetX) {
                                for (int offsetY = -1; offsetY < 4; ++offsetY) {
                                    int posX = x2 + (offsetX - 1) * j8;
                                    int posY = y + offsetY;
                                    int posZ = z + (offsetX - 1) * j9;
                                    mutableBlockPos.func_181079_c(posX, posY, posZ);
                                    if (offsetY < 0 && !this.field_85192_a.func_180495_p((BlockPos)mutableBlockPos).func_185904_a().func_76220_a() || offsetY >= 0 && !this.field_85192_a.func_175623_d((BlockPos)mutableBlockPos)) continue block10;
                                }
                            }
                            double adjustedPosY = (double)y + 0.5 - entity.field_70163_u;
                            double adjustedPos = adjustedPosX * adjustedPosX + adjustedPosY * adjustedPosY + adjustedPosZ * adjustedPosZ;
                            if (!(portalDistance < 0.0) && !(adjustedPos < portalDistance)) continue;
                            portalDistance = adjustedPos;
                            adjustedEntityPosX = x2;
                            adjustedEntityPosY = y;
                            adjustedEntityPosZ = z;
                            offset = offsetZ % 2;
                        }
                    }
                }
            }
        }
        int i6 = adjustedEntityPosX;
        int k2 = adjustedEntityPosY;
        int k6 = adjustedEntityPosZ;
        int l6 = offset % 2;
        int i3 = 1 - l6;
        if (offset % 4 >= 2) {
            l6 = -l6;
            i3 = -i3;
        }
        if (portalDistance < 0.0) {
            k2 = adjustedEntityPosY = MathHelper.func_76125_a((int)adjustedEntityPosY, (int)70, (int)(this.field_85192_a.func_72940_L() - 10));
            for (int z2 = -1; z2 <= 1; ++z2) {
                for (x = 1; x < 3; ++x) {
                    for (int y2 = -1; y2 < 3; ++y2) {
                        int posX = i6 + (x - 1) * l6 + z2 * i3;
                        int posY = k2 + y2;
                        int posZ = k6 + (x - 1) * i3 - z2 * l6;
                        boolean beneathWorld = y2 < 0;
                        this.field_85192_a.func_175656_a(new BlockPos(posX, posY, posZ), beneathWorld ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        IBlockState state = NetherExBlocks.NETHER_PORTAL.func_176223_P().func_177226_a((IProperty)BlockNetherPortal.AXIS, (Comparable)(l6 == 0 ? EnumFacing.Axis.X : EnumFacing.Axis.Z));
        for (x = 0; x < 4; ++x) {
            int posZ;
            int posY;
            int posX;
            int y3;
            for (int z3 = 0; z3 < 4; ++z3) {
                for (y3 = -1; y3 < 4; ++y3) {
                    posX = i6 + (z3 - 1) * l6;
                    posY = k2 + y3;
                    posZ = k6 + (z3 - 1) * i3;
                    boolean beneathWorld = z3 == 0 || z3 == 3 || y3 == -1 || y3 == 3;
                    this.field_85192_a.func_180501_a(new BlockPos(posX, posY, posZ), beneathWorld ? Blocks.field_150343_Z.func_176223_P() : state, 2);
                }
            }
            for (int zx = 0; zx < 4; ++zx) {
                for (y3 = -1; y3 < 4; ++y3) {
                    posX = i6 + (zx - 1) * l6;
                    posY = k2 + y3;
                    posZ = k6 + (zx - 1) * i3;
                    BlockPos pos = new BlockPos(posX, posY, posZ);
                    this.field_85192_a.func_175685_c(pos, this.field_85192_a.func_180495_p(pos).func_177230_c(), false);
                }
            }
        }
        return true;
    }

    public static TeleporterNetherEx getTeleporterForWorld(MinecraftServer minecraftServer, int dimension) {
        WorldServer worldServer = minecraftServer.func_71218_a(dimension);
        for (Teleporter teleporter : worldServer.customTeleporters) {
            if (!(teleporter instanceof TeleporterNetherEx)) continue;
            return (TeleporterNetherEx)teleporter;
        }
        TeleporterNetherEx teleporter = new TeleporterNetherEx(worldServer);
        worldServer.customTeleporters.add(teleporter);
        return teleporter;
    }
}

