/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.world.biome.design;

import logictechcorp.netherex.world.generation.layer.GenLayerNetherBiome;
import logictechcorp.netherex.world.generation.layer.GenLayerNetherSubBiome;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Biomes;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.IntCache;

public class BiomeProviderNetherEx
extends BiomeProvider {
    public BiomeProviderNetherEx(World world) {
        GenLayer[] genLayers = this.createGenLayers(world.func_175624_G(), world.func_72905_C());
        this.field_76944_d = genLayers[0];
        this.field_76945_e = genLayers[1];
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        int[] biomeIds = this.field_76944_d.func_75904_a(x, z, width, height);
        try {
            for (int i = 0; i < width * height; ++i) {
                biomes[i] = Biome.func_180276_a((int)biomeIds[i], (Biome)Biomes.field_76778_j);
            }
            return biomes;
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashReportCategory = crashReport.func_85058_a("RawBiomeBlock");
            crashReportCategory.func_71507_a("biomes[] size", (Object)biomes.length);
            crashReportCategory.func_71507_a("x", (Object)x);
            crashReportCategory.func_71507_a("z", (Object)z);
            crashReportCategory.func_71507_a("w", (Object)width);
            crashReportCategory.func_71507_a("h", (Object)height);
            throw new ReportedException(crashReport);
        }
    }

    private GenLayer[] createGenLayers(WorldType worldType, long worldSeed) {
        Object baseLayer = new GenLayerIsland(1L);
        GenLayerNetherBiome biomeLayer = new GenLayerNetherBiome(200L, (GenLayer)baseLayer);
        GenLayerRiverInit subBiomeLayer = new GenLayerRiverInit(200L, (GenLayer)biomeLayer);
        biomeLayer = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)biomeLayer, (int)2);
        subBiomeLayer = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)subBiomeLayer, (int)2);
        baseLayer = new GenLayerNetherSubBiome(1000L, biomeLayer, (GenLayer)subBiomeLayer);
        baseLayer = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)baseLayer, (int)GenLayer.getModdedBiomeSize((WorldType)worldType, (int)3));
        baseLayer = new GenLayerSmooth(1000L, (GenLayer)baseLayer);
        GenLayerVoronoiZoom zoomedLayer = new GenLayerVoronoiZoom(10L, (GenLayer)baseLayer);
        baseLayer.func_75905_a(worldSeed);
        zoomedLayer.func_75905_a(worldSeed);
        return new GenLayer[]{baseLayer, zoomedLayer};
    }
}

