/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.entity.monster;

import javax.annotation.Nullable;
import logictechcorp.libraryex.utility.EntityHelper;
import logictechcorp.netherex.entity.projectile.EntityBlueFireball;
import logictechcorp.netherex.init.NetherExLootTables;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFrost
extends EntityMob {
    private static final DataParameter<Byte> ON_FIRE = EntityDataManager.func_187226_a(EntityBlaze.class, (DataSerializer)DataSerializers.field_187191_a);
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;

    public EntityFrost(World worldIn) {
        super(worldIn);
        this.func_184644_a(PathNodeType.WATER, 8.0f);
        this.func_184644_a(PathNodeType.LAVA, -1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70728_aV = 10;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIBlueFireballAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ON_FIRE, (Object)0);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187594_A;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return NetherExLootTables.FROST;
    }

    protected void func_70619_bc() {
        EntityLivingBase attackTarget;
        if (EntityHelper.isInBlock((Entity)this, (IBlockState[])new IBlockState[]{Blocks.field_150480_ab.func_176223_P(), Blocks.field_150353_l.func_176223_P(), Blocks.field_150356_k.func_176223_P()})) {
            this.func_70097_a(DamageSource.field_76370_b, 1.0f);
        }
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 100;
            this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
        }
        if ((attackTarget = this.func_70638_az()) != null && attackTarget.field_70163_u + (double)attackTarget.func_70047_e() > this.field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset) {
            this.field_70181_x += ((double)0.3f - this.field_70181_x) * (double)0.3f;
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_70027_ad() {
        return this.isCharged();
    }

    public boolean isCharged() {
        return ((Byte)this.field_70180_af.func_187225_a(ON_FIRE) & 1) != 0;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(24) == 0 && !this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187597_B, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        super.func_70636_d();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187603_D;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187600_C;
    }

    protected boolean func_70814_o() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void setOnFire(boolean onFire) {
        byte fire = (Byte)this.field_70180_af.func_187225_a(ON_FIRE);
        fire = onFire ? (byte)(fire | 1) : (byte)(fire & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(ON_FIRE, (Object)fire);
    }

    static class EntityAIBlueFireballAttack
    extends EntityAIBase {
        private final EntityFrost frost;
        private int attackStep;
        private int attackTime;

        public EntityAIBlueFireballAttack(EntityFrost frost) {
            this.frost = frost;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase attackTarget = this.frost.func_70638_az();
            return attackTarget != null && attackTarget.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.frost.setOnFire(false);
        }

        public void func_75246_d() {
            if (this.func_75250_a()) {
                World world = this.frost.func_130014_f_();
                EntityLivingBase attackTarget = this.frost.func_70638_az();
                double distanceSq = this.frost.func_70068_e((Entity)attackTarget);
                --this.attackTime;
                if (distanceSq < 4.0) {
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.frost.func_70652_k((Entity)attackTarget);
                    }
                    this.frost.func_70605_aq().func_75642_a(attackTarget.field_70165_t, attackTarget.field_70163_u, attackTarget.field_70161_v, 1.0);
                } else if (distanceSq < this.getFollowDistance() * this.getFollowDistance()) {
                    double posX = attackTarget.field_70165_t - this.frost.field_70165_t;
                    double posY = attackTarget.func_174813_aQ().field_72338_b + (double)(attackTarget.field_70131_O / 2.0f) - (this.frost.field_70163_u + (double)(this.frost.field_70131_O / 2.0f));
                    double posZ = attackTarget.field_70161_v - this.frost.field_70161_v;
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                            this.frost.setOnFire(true);
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                            this.frost.setOnFire(false);
                        }
                        if (this.attackStep > 1) {
                            float distanceSq2 = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)distanceSq)) * 0.5f;
                            this.frost.field_70170_p.func_180498_a(null, 1018, new BlockPos((int)this.frost.field_70165_t, (int)this.frost.field_70163_u, (int)this.frost.field_70161_v), 0);
                            for (int i = 0; i < 1; ++i) {
                                EntityBlueFireball blueFireball = new EntityBlueFireball(world, (EntityLivingBase)this.frost, posX + this.frost.func_70681_au().nextGaussian() * (double)distanceSq2, posY, posZ + this.frost.func_70681_au().nextGaussian() * (double)distanceSq2);
                                blueFireball.field_70163_u = this.frost.field_70163_u + (double)(this.frost.field_70131_O / 2.0f) + 0.5;
                                world.func_72838_d((Entity)blueFireball);
                            }
                        }
                    }
                    this.frost.func_70671_ap().func_75651_a((Entity)attackTarget, 10.0f, 10.0f);
                } else {
                    this.frost.func_70661_as().func_75499_g();
                    this.frost.func_70605_aq().func_75642_a(attackTarget.field_70165_t, attackTarget.field_70163_u, attackTarget.field_70161_v, 1.0);
                }
                super.func_75246_d();
            }
        }

        private double getFollowDistance() {
            IAttributeInstance attribute = this.frost.func_110148_a(SharedMonsterAttributes.field_111265_b);
            return attribute == null ? 16.0 : attribute.func_111126_e();
        }
    }
}

