/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.item;

import java.util.List;
import logictechcorp.libraryex.item.ItemMod;
import logictechcorp.libraryex.utility.NBTHelper;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.init.NetherExItems;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class ItemDullMirror
extends ItemMod {
    public ItemDullMirror() {
        super(NetherEx.getResource("dull_mirror"), NetherExItems.getDefaultItemProperties().copy().maxDamage(6));
        this.func_185043_a(new ResourceLocation("on"), (stack, world, entity) -> !stack.func_77942_o() ? 0.0f : (stack.func_77978_p().func_74764_b("SpawnPoint") ? 1.0f : 0.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            if (compound.func_74764_b("SpawnDimension")) {
                DimensionType type = DimensionManager.getProviderType((int)compound.func_74762_e("SpawnDimension"));
                tooltip.add(I18n.func_135052_a((String)"tooltip.netherex:dull_mirror.spawn_dimension", (Object[])new Object[]{StringUtils.capitalize((String)type.func_186065_b())}));
            }
            if (compound.func_74764_b("SpawnPoint")) {
                BlockPos spawnPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("SpawnPoint"));
                tooltip.add(I18n.func_135052_a((String)"tooltip.netherex:dull_mirror.spawn_point", (Object[])new Object[]{spawnPos.func_177958_n() + " " + spawnPos.func_177956_o() + " " + spawnPos.func_177952_p()}));
            }
            if (compound.func_74764_b("DeathPoint")) {
                BlockPos deathPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("DeathPoint"));
                tooltip.add(I18n.func_135052_a((String)"tooltip.netherex:dull_mirror.death_point", (Object[])new Object[]{deathPos.func_177958_n() + " " + deathPos.func_177956_o() + " " + deathPos.func_177952_p()}));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        NBTTagCompound compound;
        if (stack.func_77952_i() == this.getMaxDamage(stack) - 1 && !(compound = NBTHelper.ensureTagExists((ItemStack)stack)).func_74767_n("RemovedSpawn") && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (compound.func_74764_b("SpawnDimension") && compound.func_74764_b("SpawnPoint")) {
                int bedDimension = compound.func_74762_e("BedDimension");
                player.setSpawnDimension(Integer.valueOf(bedDimension));
                player.setSpawnChunk(NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("BedPoint")), true, bedDimension);
                compound.func_74757_a("RemovedSpawn", true);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && stack.func_77952_i() < this.getMaxDamage(stack) && player.func_70093_af()) {
            int spawnDimension = world.field_73011_w.getDimension();
            BlockPos spawnPoint = player.func_180425_c();
            NBTTagCompound compound = NBTHelper.ensureTagExists((ItemStack)stack);
            if (!compound.func_74764_b("SpawnDimension") || !compound.func_74764_b("SpawnPoint")) {
                int bedDimension = player.getSpawnDimension();
                BlockPos bedPos = player.getBedLocation(bedDimension);
                if (bedPos == null) {
                    bedPos = world.func_73046_m().func_71218_a(bedDimension).func_175694_M();
                }
                compound.func_74768_a("BedDimension", bedDimension);
                compound.func_74782_a("BedPoint", (NBTBase)NBTUtil.func_186859_a((BlockPos)bedPos));
                compound.func_74768_a("SpawnDimension", spawnDimension);
                compound.func_74782_a("SpawnPoint", (NBTBase)NBTUtil.func_186859_a((BlockPos)spawnPoint));
                player.setSpawnDimension(Integer.valueOf(spawnDimension));
                player.setSpawnChunk(spawnPoint, true, spawnDimension);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("tooltip.netherex:dull_mirror.spawn_point_set", new Object[]{spawnPoint.func_177958_n() + " " + spawnPoint.func_177956_o() + " " + spawnPoint.func_177952_p()}));
                world.func_184134_a((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o() + 0.5, (double)spawnPoint.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.4f + 0.8f, false);
            } else {
                int bedDimension = compound.func_74762_e("BedDimension");
                compound.func_82580_o("SpawnDimension");
                compound.func_82580_o("SpawnPoint");
                player.setSpawnDimension(Integer.valueOf(bedDimension));
                player.setSpawnChunk(NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("BedPoint")), true, bedDimension);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("tooltip.netherex:dull_mirror.spawn_point_removed", new Object[]{spawnPoint.func_177958_n() + " " + spawnPoint.func_177956_o() + " " + spawnPoint.func_177952_p()}));
                world.func_184134_a((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o() + 0.5, (double)spawnPoint.func_177952_p() + 0.5, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.4f + 0.8f, false);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)stack.func_77952_i() / ((double)stack.func_77958_k() - 1.0);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage < this.getMaxDamage(stack)) {
            super.setDamage(stack, damage);
        }
    }
}

