/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.block;

import com.yurtmod.block.BlockBedouinWall;
import com.yurtmod.block.BlockLayered;
import com.yurtmod.block.BlockShamianaWall;
import com.yurtmod.block.BlockTepeeWall;
import com.yurtmod.block.BlockYurtRoof;
import com.yurtmod.init.NomadicTents;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCosmetic
extends Block {
    public BlockCosmetic(Material blockMaterialIn, MapColor blockMapColorIn, String name) {
        super(blockMaterialIn, blockMapColorIn);
        BlockCosmetic.undoUnbreakable(this);
        this.setRegistryName("yurtmod", name);
        this.func_149663_c(name);
    }

    public BlockCosmetic(Material blockMaterialIn, String name) {
        this(blockMaterialIn, blockMaterialIn.func_151565_r(), name);
    }

    protected static final Block undoUnbreakable(Block blockIn) {
        blockIn.func_149647_a(NomadicTents.TAB);
        blockIn.setHarvestLevel("pickaxe", -1);
        blockIn.func_149752_b(0.2f);
        blockIn.func_149711_c(0.6f);
        return blockIn;
    }

    public static boolean isCosmetic(Block block) {
        return block.getRegistryName() != null && block.getRegistryName().toString().contains("cos_") || block instanceof Layered || block instanceof BedouinWall || block instanceof TepeeWall || block instanceof YurtRoof || block instanceof BlockCosmetic;
    }

    public static class ShamianaWall
    extends BlockShamianaWall {
        public ShamianaWall(EnumDyeColor colorIn) {
            super(colorIn, "cos_shamiana_".concat(colorIn.func_176610_l()));
            BlockCosmetic.undoUnbreakable(this);
        }

        @Override
        public Item func_180660_a(IBlockState state, Random rand, int fortune) {
            return Item.func_150898_a((Block)this);
        }

        @Override
        public int func_149745_a(Random random) {
            return 1;
        }

        @Override
        public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
            return true;
        }

        @Override
        public EnumPushReaction func_149656_h(IBlockState state) {
            return this.field_149764_J.func_186274_m();
        }

        public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
            return ShamianaWall.getShamianaState(this.getColor(), placer != null && placer.func_70093_af(), false);
        }
    }

    public static class TepeeWall
    extends BlockTepeeWall {
        public TepeeWall(String name) {
            super(name);
            BlockCosmetic.undoUnbreakable(this);
        }

        @Override
        public Item func_180660_a(IBlockState state, Random rand, int fortune) {
            return Item.func_150898_a((Block)this);
        }

        @Override
        public int func_149745_a(Random random) {
            return 1;
        }

        @Override
        public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
            return true;
        }

        @Override
        public EnumPushReaction func_149656_h(IBlockState state) {
            return this.field_149764_J.func_186274_m();
        }
    }

    public static class YurtRoof
    extends BlockYurtRoof {
        public YurtRoof(String name) {
            this.setRegistryName("yurtmod", name);
            this.func_149663_c(name);
            BlockCosmetic.undoUnbreakable(this);
            this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)OUTSIDE, (Comparable)Boolean.valueOf(true)));
        }

        public void func_176213_c(World worldIn, BlockPos pos, IBlockState stateIn) {
            super.func_176213_c(worldIn, pos, stateIn);
            worldIn.func_175656_a(pos, stateIn.func_177226_a((IProperty)OUTSIDE, (Comparable)Boolean.valueOf(true)));
        }

        @Override
        public Item func_180660_a(IBlockState state, Random rand, int fortune) {
            return Item.func_150898_a((Block)this);
        }

        @Override
        public int func_149745_a(Random random) {
            return 1;
        }

        @Override
        public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
            return true;
        }

        @Override
        public EnumPushReaction func_149656_h(IBlockState state) {
            return this.field_149764_J.func_186274_m();
        }
    }

    public static class BedouinWall
    extends BlockBedouinWall {
        public BedouinWall(String name) {
            this.setRegistryName("yurtmod", name);
            this.func_149663_c(name);
            BlockCosmetic.undoUnbreakable(this);
        }

        @Override
        public Item func_180660_a(IBlockState state, Random rand, int fortune) {
            return Item.func_150898_a((Block)this);
        }

        @Override
        public int func_149745_a(Random random) {
            return 1;
        }

        @Override
        public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
            return true;
        }

        @Override
        public EnumPushReaction func_149656_h(IBlockState state) {
            return this.field_149764_J.func_186274_m();
        }
    }

    public static class Layered
    extends BlockLayered {
        public Layered(Material m, MapColor c, String name) {
            super(m, c);
            BlockCosmetic.undoUnbreakable(this);
            this.setRegistryName("yurtmod", name);
            this.func_149663_c(name);
        }

        public Layered(Material m, String name) {
            this(m, m.func_151565_r(), name);
        }

        @Override
        public Item func_180660_a(IBlockState state, Random rand, int fortune) {
            return Item.func_150898_a((Block)this);
        }

        @Override
        public int func_149745_a(Random random) {
            return 1;
        }

        @Override
        public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
            return true;
        }

        @Override
        public EnumPushReaction func_149656_h(IBlockState state) {
            return this.field_149764_J.func_186274_m();
        }
    }
}

