/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.block;

import com.yurtmod.block.BlockCosmetic;
import com.yurtmod.block.BlockTentDoor;
import com.yurtmod.block.BlockUnbreakable;
import com.yurtmod.block.Categories;
import com.yurtmod.block.TileEntityTentDoor;
import com.yurtmod.dimension.TentDimension;
import com.yurtmod.init.Content;
import com.yurtmod.init.NomadicTents;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockShamianaWall
extends BlockUnbreakable
implements Categories.IShamianaBlock {
    public static final PropertyBool PATTERN = PropertyBool.func_177716_a((String)"pattern");
    private final EnumDyeColor color;
    private static final Block[] blockColors = new Block[16];
    private static final Block[] blockColorsCosmetic = new Block[16];

    public BlockShamianaWall(EnumDyeColor colorIn, String name) {
        super(Material.field_151580_n, MapColor.field_193575_b[colorIn.ordinal()]);
        this.color = colorIn;
        this.setRegistryName("yurtmod", name);
        this.func_149663_c(name);
        this.func_149647_a(NomadicTents.TAB);
        this.func_149713_g(7);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)PATTERN, (Comparable)Boolean.valueOf(false)));
        if (BlockCosmetic.isCosmetic(this)) {
            BlockShamianaWall.blockColorsCosmetic[colorIn.ordinal()] = this;
        } else {
            BlockShamianaWall.blockColors[colorIn.ordinal()] = this;
        }
    }

    public BlockShamianaWall(EnumDyeColor colorIn) {
        this(colorIn, "shamiana_".concat(colorIn.func_176610_l()));
    }

    public EnumDyeColor getColor() {
        return this.color;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PATTERN});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PATTERN, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)PATTERN) != false ? 1 : 0;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState stateIn) {
        super.func_176213_c(worldIn, pos, stateIn);
        if (!TentDimension.isTentDimension(worldIn) && stateIn.func_177230_c() == Content.SHAMIANA_WALL_WHITE) {
            BlockPos doorPos = BlockShamianaWall.traceToDoorNearby(worldIn, pos);
            IBlockState state = null;
            if (doorPos != null && worldIn.func_175625_s(doorPos) instanceof TileEntityTentDoor) {
                EnumDyeColor colorCur = ((TileEntityTentDoor)worldIn.func_175625_s(doorPos)).getTentData().getColor();
                state = BlockShamianaWall.getShamianaState(colorCur, BlockShamianaWall.shouldBePattern(pos, doorPos), true);
            }
            if (state != null) {
                worldIn.func_180501_a(pos, state, 2);
            }
        }
    }

    public static boolean shouldBePattern(BlockPos myPos, BlockPos doorPos) {
        return (myPos.func_177956_o() - doorPos.func_177956_o()) % 3 == 0;
    }

    private static BlockPos traceToDoorNearby(World world, BlockPos posIn) {
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        BlockPos pos = posIn;
        while (pos != null && !(world.func_180495_p(pos).func_177230_c() instanceof BlockTentDoor)) {
            pos = BlockShamianaWall.traceNextShamianaBlock(world, checked, pos);
        }
        if (pos == null) {
            return null;
        }
        boolean isLower = world.func_180495_p(pos).func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER;
        return isLower ? pos : pos.func_177979_c(1);
    }

    private static BlockPos traceNextShamianaBlock(World worldIn, Set<BlockPos> exclude, BlockPos pos) {
        int radius = 1;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    IBlockState stateAt = worldIn.func_180495_p(checkPos);
                    if (exclude.contains(checkPos) || !(stateAt.func_177230_c() instanceof Categories.IShamianaBlock) && !(stateAt.func_177230_c() instanceof Categories.IFrameBlock)) continue;
                    exclude.add(checkPos);
                    return checkPos;
                }
            }
        }
        return null;
    }

    public static Block getShamianaBlock(EnumDyeColor color, boolean indestructible) {
        if (color == null) {
            return Content.SHAMIANA_WALL_WHITE;
        }
        if (indestructible) {
            return blockColors[color.ordinal()] != null ? blockColors[color.ordinal()] : Content.SHAMIANA_WALL_WHITE;
        }
        return blockColorsCosmetic[color.ordinal()] != null ? blockColorsCosmetic[color.ordinal()] : Content.COS_SHAMIANA_WALL_WHITE;
    }

    public static IBlockState getShamianaState(EnumDyeColor color, boolean pattern, boolean indestructible) {
        return BlockShamianaWall.getShamianaBlock(color, indestructible).func_176223_P().func_177226_a((IProperty)PATTERN, (Comparable)Boolean.valueOf(pattern));
    }
}

