/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.block;

import com.yurtmod.block.BlockUnbreakable;
import com.yurtmod.block.Categories;
import com.yurtmod.block.TileEntityTentDoor;
import com.yurtmod.dimension.TentDimension;
import com.yurtmod.event.TentEvent;
import com.yurtmod.init.NomadicTents;
import com.yurtmod.init.TentConfig;
import com.yurtmod.item.ItemMallet;
import com.yurtmod.structure.StructureBase;
import com.yurtmod.structure.util.StructureData;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockTentDoor
extends BlockUnbreakable
implements ITileEntityProvider,
Categories.ITepeeBlock,
Categories.IYurtBlock,
Categories.IBedouinBlock,
Categories.IIndluBlock,
Categories.IShamianaBlock {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    public static final int DECONSTRUCT_DAMAGE = 5;
    private static final double aabbDis = 0.375;
    public static final AxisAlignedBB AABB_X = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    public static final AxisAlignedBB AABB_Z = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    public final boolean isCube;

    public BlockTentDoor(String name, boolean isFull) {
        super(Material.field_151575_d);
        this.setRegistryName("yurtmod", name);
        this.func_149663_c(name);
        this.isCube = isFull;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X));
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        Material m1 = world.func_180495_p(pos).func_185904_a();
        Material m2 = world.func_180495_p(pos.func_177981_b(1)).func_185904_a();
        return !(m1 != Material.field_151579_a && m1 != Material.field_151586_h || m2 != Material.field_151579_a && m2 != Material.field_151586_h);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) return false;
        BlockPos base = state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177979_c(1);
        TileEntity te = worldIn.func_175625_s(base);
        if (te instanceof TileEntityTentDoor) {
            EnumFacing dir;
            TileEntityTentDoor teyd = (TileEntityTentDoor)te;
            StructureData data = teyd.getTentData();
            StructureBase struct = data.getStructure();
            ItemStack held = player.func_184586_b(hand);
            if ((player.field_71075_bZ.field_75098_d || !TentConfig.GENERAL.COPY_CREATIVE_ONLY) && held != null && held.func_77942_o() && held.func_77978_p().func_74764_b("TentCopyTool") && held.func_77978_p().func_74767_n("TentCopyTool")) {
                ItemStack copyStack = teyd.getTentData().getDropStack();
                if (copyStack == null) return true;
                EntityItem dropItem = new EntityItem(worldIn, player.field_70165_t, player.field_70163_u, player.field_70161_v, copyStack);
                dropItem.func_174867_a(0);
                worldIn.func_72838_d((Entity)dropItem);
                player.field_71088_bW = player.func_82147_ab();
                return true;
            }
            EnumFacing enumFacing = dir = TentDimension.isTentDimension(worldIn) ? TentDimension.STRUCTURE_DIR : struct.getValidFacing(worldIn, base, data.getWidth().getOverworldSize());
            if (dir == null) {
                return false;
            }
            if (held == null || !(held.func_77973_b() instanceof ItemMallet) || TentDimension.isTentDimension(worldIn)) return ((TileEntityTentDoor)te).onPlayerActivate(player);
            if (TentConfig.GENERAL.OWNER_PICKUP && teyd.hasOwner() && !teyd.isOwner(player)) {
                return false;
            }
            TentEvent.Deconstruct event = new TentEvent.Deconstruct(teyd, player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            ItemStack toDrop = event.getTentStack();
            if (toDrop == null) return false;
            EntityItem dropItem = new EntityItem(worldIn, player.field_70165_t, player.field_70163_u, player.field_70161_v, toDrop);
            dropItem.func_174867_a(0);
            worldIn.func_72838_d((Entity)dropItem);
            if (TentConfig.GENERAL.ALLOW_OVERWORLD_SETSPAWN) {
                teyd.onPlayerRemove(player);
            }
            struct.remove(worldIn, base, dir, data.getWidth().getOverworldSize());
            player.func_184586_b(hand).func_77972_a(5, (EntityLivingBase)player);
            return true;
        }
        NomadicTents.LOGGER.error("Error! Failed to retrieve TileEntityTentDoor at " + pos);
        return false;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.func_180634_a(worldIn, pos, worldIn.func_180495_p(pos), entityIn);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileEntity te;
        if (!worldIn.field_72995_K && worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER && (te = worldIn.func_175625_s(pos)) instanceof TileEntityTentDoor) {
            EnumFacing dir;
            TileEntityTentDoor teDoor = (TileEntityTentDoor)te;
            StructureData type = teDoor.getTentData();
            StructureBase struct = type.getStructure();
            EnumFacing enumFacing = dir = TentDimension.isTentDimension(worldIn) ? TentDimension.STRUCTURE_DIR : struct.getValidFacing(worldIn, pos, type.getWidth().getOverworldSize());
            if (dir != null) {
                teDoor.onEntityCollide(entityIn, dir);
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), 3);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.isCube) {
            return field_185505_j;
        }
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (axis == EnumFacing.Axis.X) {
            return AABB_X;
        }
        return AABB_Z;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.isCube;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.isCube;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.isCube ? BlockRenderLayer.SOLID : BlockRenderLayer.CUTOUT;
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            worldIn.func_175698_g(pos.func_177981_b(1));
        } else {
            worldIn.func_175698_g(pos.func_177979_c(1));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDoor.field_176523_O, AXIS});
    }

    public IBlockState func_176203_a(int meta) {
        BlockDoor.EnumDoorHalf half = meta % 2 == 0 ? BlockDoor.EnumDoorHalf.LOWER : BlockDoor.EnumDoorHalf.UPPER;
        int metaDiv2 = Math.floorDiv(meta, 2);
        EnumFacing.Axis axis = metaDiv2 < 8 && metaDiv2 % 2 == 1 ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
        return this.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)half).func_177226_a(AXIS, (Comparable)axis);
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            ++meta;
        }
        if (state.func_177229_b(AXIS) == EnumFacing.Axis.Z) {
            meta += 2;
        }
        return meta;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        TileEntityTentDoor ret = new TileEntityTentDoor();
        ret.func_145834_a(worldIn);
        return ret;
    }
}

