/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.block;

import com.yurtmod.block.BlockUnbreakable;
import com.yurtmod.block.BlockYurtRoof;
import com.yurtmod.block.Categories;
import com.yurtmod.init.Content;
import com.yurtmod.init.TentConfig;
import com.yurtmod.item.ItemMallet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTentFrame
extends BlockUnbreakable
implements Categories.IFrameBlock {
    public static final int MAX_META = 7;
    public static final int CONSTRUCT_DAMAGE = 1;
    public static final int BASE_EFFECTIVENESS = 2;
    public static final PropertyInteger PROGRESS = PropertyInteger.func_177719_a((String)"progress", (int)0, (int)7);
    public static final AxisAlignedBB AABB_PROGRESS_0 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    public static final AxisAlignedBB AABB_PROGRESS_1 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    public static final AxisAlignedBB AABB_PROGRESS_2 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private final BlockToBecome TO_BECOME;

    public BlockTentFrame(BlockToBecome type, String name) {
        super(Material.field_151575_d);
        this.TO_BECOME = type;
        this.setRegistryName("yurtmod", name);
        this.func_149663_c(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem;
        ItemStack itemStack = heldItem = hand != null && playerIn != null ? playerIn.func_184586_b(hand) : null;
        if (!worldIn.field_72995_K && heldItem != null && heldItem.func_77973_b() instanceof ItemMallet) {
            if (heldItem.func_77973_b() == Content.ITEM_SUPER_MALLET) {
                return this.onSuperMalletUsed(worldIn, pos, state, heldItem, playerIn);
            }
            return this.onMalletUsed(worldIn, pos, state, heldItem, playerIn);
        }
        return false;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int meta = (Integer)state.func_177229_b((IProperty)PROGRESS);
        if (meta <= 1) {
            return AABB_PROGRESS_0;
        }
        if (meta <= 3) {
            return AABB_PROGRESS_1;
        }
        return AABB_PROGRESS_2;
    }

    @Deprecated
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROGRESS});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PROGRESS, (Comparable)Integer.valueOf(Math.min(meta, 7)));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)PROGRESS);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getEffectiveness(World worldIn, BlockPos pos, ItemStack mallet, EntityPlayer player) {
        return 2;
    }

    public boolean becomeReal(World worldIn, BlockPos pos, ItemStack mallet, EntityPlayer player) {
        mallet.func_77972_a(1, (EntityLivingBase)player);
        return !worldIn.field_72995_K && worldIn.func_180501_a(pos, this.TO_BECOME.getBlock(), 3);
    }

    public BlockToBecome getEnumBlockToBecome() {
        return this.TO_BECOME;
    }

    public boolean onMalletUsed(World worldIn, BlockPos pos, IBlockState state, ItemStack mallet, EntityPlayer player) {
        int meta = this.func_176201_c(state);
        int nextMeta = meta + this.getEffectiveness(worldIn, pos, mallet, player);
        worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)PROGRESS, (Comparable)Integer.valueOf(Math.min(nextMeta, 7))), 3);
        if (nextMeta >= 7) {
            this.becomeReal(worldIn, pos, mallet, player);
        }
        return true;
    }

    public boolean onSuperMalletUsed(World worldIn, BlockPos pos, IBlockState state, ItemStack mallet, EntityPlayer player) {
        if (TentConfig.GENERAL.SUPER_MALLET_CREATIVE_ONLY && !player.func_184812_l_()) {
            return false;
        }
        this.becomeReal(worldIn, pos, mallet, player);
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    BlockPos curPos = new BlockPos(pos.func_177958_n() + i, pos.func_177956_o() + j, pos.func_177952_p() + k);
                    Block current = worldIn.func_180495_p(curPos).func_177230_c();
                    if (!(current instanceof BlockTentFrame)) continue;
                    ((BlockTentFrame)current).onSuperMalletUsed(worldIn, curPos, state, mallet, player);
                }
            }
        }
        return true;
    }

    public static enum BlockToBecome {
        YURT_WALL_INNER{

            @Override
            public IBlockState getBlock() {
                return Content.YURT_WALL_INNER.func_176223_P();
            }
        }
        ,
        YURT_WALL_OUTER{

            @Override
            public IBlockState getBlock() {
                return Content.YURT_WALL_OUTER.func_176223_P();
            }
        }
        ,
        YURT_ROOF{

            @Override
            public IBlockState getBlock() {
                return Content.YURT_ROOF.func_176223_P().func_177226_a((IProperty)BlockYurtRoof.OUTSIDE, (Comparable)Boolean.valueOf(true));
            }
        }
        ,
        TEPEE_WALL{

            @Override
            public IBlockState getBlock() {
                return Content.TEPEE_WALL_BLANK.func_176223_P();
            }
        }
        ,
        BEDOUIN_WALL{

            @Override
            public IBlockState getBlock() {
                return Content.BEDOUIN_WALL.func_176223_P();
            }
        }
        ,
        BEDOUIN_ROOF{

            @Override
            public IBlockState getBlock() {
                return Content.BEDOUIN_ROOF.func_176223_P();
            }
        }
        ,
        INDLU_WALL{

            @Override
            public IBlockState getBlock() {
                return Content.INDLU_WALL_OUTER.func_176223_P();
            }
        }
        ,
        SHAMIANA_WALL{

            @Override
            public IBlockState getBlock() {
                return Content.SHAMIANA_WALL_WHITE.func_176223_P();
            }
        };


        public abstract IBlockState getBlock();
    }
}

