/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.block;

import com.yurtmod.block.BlockTentDoor;
import com.yurtmod.block.BlockUnbreakable;
import com.yurtmod.block.Categories;
import com.yurtmod.block.TileEntityTentDoor;
import com.yurtmod.dimension.TentDimension;
import com.yurtmod.init.Content;
import com.yurtmod.init.NomadicTents;
import com.yurtmod.init.TentConfig;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockTepeeWall
extends BlockUnbreakable
implements Categories.ITepeeBlock {
    public BlockTepeeWall(String name) {
        super(Material.field_151580_n, MapColor.field_151658_d);
        this.func_149647_a(NomadicTents.TAB);
        this.setRegistryName("yurtmod", name);
        this.func_149663_c(name);
        this.func_149713_g(7);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState stateIn) {
        super.func_176213_c(worldIn, pos, stateIn);
        if (stateIn.func_177230_c() == Content.TEPEE_WALL_BLANK) {
            BlockPos doorPos = BlockTepeeWall.traceToDoorNearby(worldIn, pos);
            IBlockState state = BlockTepeeWall.getStateForRandomDesignWithChance(worldIn.field_73012_v, true);
            if (!TentDimension.isTentDimension(worldIn) && doorPos != null && Math.abs(pos.func_177956_o() - doorPos.func_177956_o()) % 2 == 0 && worldIn.func_175625_s(doorPos) instanceof TileEntityTentDoor) {
                TileEntityTentDoor te = (TileEntityTentDoor)worldIn.func_175625_s(doorPos);
                int id = (int)te.getTentData().getID();
                int randSeed = pos.func_177956_o() + doorPos.func_177958_n() + doorPos.func_177952_p() + id * 123 + te.getTentData().getWidth().getId() * 101;
                state = BlockTepeeWall.getStateForRandomPattern(new Random(randSeed), true);
            }
            if (state != null) {
                worldIn.func_180501_a(pos, state, 2);
            }
        }
    }

    public static IBlockState getStateForBase(boolean indestructible) {
        return indestructible ? Content.TEPEE_WALL_BLANK.func_176223_P() : Content.COS_TEPEE_WALL_BLANK.func_176223_P();
    }

    public static IBlockState getStateForRandomPattern(Random rand, boolean indestructible) {
        Block[] PATTERNS_INDEST = new Block[]{Content.TEPEE_WALL_BLACK, Content.TEPEE_WALL_ORANGE, Content.TEPEE_WALL_RED, Content.TEPEE_WALL_WHITE, Content.TEPEE_WALL_YELLOW};
        Block[] PATTERNS_COSM = new Block[]{Content.COS_TEPEE_WALL_BLACK, Content.COS_TEPEE_WALL_ORANGE, Content.COS_TEPEE_WALL_RED, Content.COS_TEPEE_WALL_WHITE, Content.COS_TEPEE_WALL_YELLOW};
        int index = rand.nextInt(PATTERNS_INDEST.length);
        return indestructible ? PATTERNS_INDEST[index].func_176223_P() : PATTERNS_COSM[index].func_176223_P();
    }

    public static IBlockState getStateForRandomDesignWithChance(Random rand, boolean indestructible) {
        return rand.nextInt(100) < TentConfig.GENERAL.TEPEE_DECORATED_CHANCE ? BlockTepeeWall.getStateForRandomDesign(rand, indestructible) : BlockTepeeWall.getStateForBase(indestructible);
    }

    public static IBlockState getStateForRandomDesign(Random rand, boolean indestructible) {
        Block[] TEXTURES_INDEST = new Block[]{Content.TEPEE_WALL_CREEPER, Content.TEPEE_WALL_DREAMCATCHER, Content.TEPEE_WALL_EAGLE, Content.TEPEE_WALL_HOPE, Content.TEPEE_WALL_MAGIC, Content.TEPEE_WALL_RAIN, Content.TEPEE_WALL_SUN, Content.TEPEE_WALL_TRIFORCE, Content.TEPEE_WALL_UNIVERSE};
        Block[] TEXTURES_COSM = new Block[]{Content.COS_TEPEE_WALL_CREEPER, Content.COS_TEPEE_WALL_DREAMCATCHER, Content.COS_TEPEE_WALL_EAGLE, Content.COS_TEPEE_WALL_HOPE, Content.COS_TEPEE_WALL_MAGIC, Content.COS_TEPEE_WALL_RAIN, Content.COS_TEPEE_WALL_SUN, Content.COS_TEPEE_WALL_TRIFORCE, Content.COS_TEPEE_WALL_UNIVERSE};
        int index = rand.nextInt(TEXTURES_INDEST.length);
        return indestructible ? TEXTURES_INDEST[index].func_176223_P() : TEXTURES_COSM[index].func_176223_P();
    }

    private static BlockPos traceToDoorNearby(World world, BlockPos pos) {
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        while (pos != null && !(world.func_180495_p(pos).func_177230_c() instanceof BlockTentDoor)) {
            pos = BlockTepeeWall.traceNextTepeeBlock(world, checked, pos);
        }
        if (pos == null) {
            return null;
        }
        boolean isLower = world.func_180495_p(pos).func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER;
        return isLower ? pos : pos.func_177979_c(1);
    }

    private static BlockPos traceNextTepeeBlock(World worldIn, Set<BlockPos> exclude, BlockPos pos) {
        int radius = 1;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    IBlockState stateAt = worldIn.func_180495_p(checkPos);
                    if (exclude.contains(checkPos) || !(stateAt.func_177230_c() instanceof Categories.ITepeeBlock) && !(stateAt.func_177230_c() instanceof Categories.IFrameBlock)) continue;
                    exclude.add(checkPos);
                    return checkPos;
                }
            }
        }
        return null;
    }
}

