/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.block;

import com.yurtmod.dimension.TentDimension;
import com.yurtmod.dimension.TentTeleporter;
import com.yurtmod.event.TentEvent;
import com.yurtmod.init.NomadicTents;
import com.yurtmod.init.TentConfig;
import com.yurtmod.init.TentSaveData;
import com.yurtmod.item.ItemTent;
import com.yurtmod.structure.util.StructureData;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TileEntityTentDoor
extends TileEntity {
    private static final String S_TENT_DATA = "TentData";
    private static final String S_PLAYER_X = "PlayerPrevX";
    private static final String S_PLAYER_Y = "PlayerPrevY";
    private static final String S_PLAYER_Z = "PlayerPrevZ";
    private static final String S_PLAYER_YAW = "PlayerPrevFacing";
    private static final String S_PLAYER_UUID = "PlayerUUID";
    private static final String S_PLAYER_DIM = "PreviousPlayerDimension";
    private StructureData tent;
    private double prevX;
    private double prevY;
    private double prevZ;
    private float prevFacing;
    private int prevDimID;
    private UUID owner;

    public TileEntityTentDoor() {
        if (this.tent == null) {
            this.tent = new StructureData();
        }
    }

    public static BlockPos getTentDoorPos(long tentID) {
        int x = (int)(tentID % 64L) * 32;
        int y = 70;
        int z = (int)(tentID / 64L) * 32;
        return new BlockPos(x, y, z);
    }

    public static long getTentID(BlockPos pos) {
        return (long)(pos.func_177958_n() / 32) + (long)(pos.func_177952_p() / 32) * 64L;
    }

    public void setTentData(StructureData tentData) {
        this.tent = tentData;
    }

    public StructureData getTentData() {
        return this.tent;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound tentData = nbt.func_74775_l(S_TENT_DATA);
        if (ItemTent.shouldFixOldStructureData(tentData)) {
            tentData = ItemTent.makeStructureDataFromOld(this.func_145831_w(), tentData);
        }
        this.tent = new StructureData(tentData);
        this.prevX = nbt.func_74769_h(S_PLAYER_X);
        this.prevY = nbt.func_74769_h(S_PLAYER_Y);
        this.prevZ = nbt.func_74769_h(S_PLAYER_Z);
        this.prevFacing = nbt.func_74760_g(S_PLAYER_YAW);
        this.prevDimID = nbt.func_74762_e(S_PLAYER_DIM);
        this.owner = nbt.func_74764_b(S_PLAYER_UUID) ? nbt.func_186857_a(S_PLAYER_UUID) : null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a(S_TENT_DATA, (NBTBase)this.tent.serializeNBT());
        nbt.func_74780_a(S_PLAYER_X, this.prevX);
        nbt.func_74780_a(S_PLAYER_Y, this.prevY);
        nbt.func_74780_a(S_PLAYER_Z, this.prevZ);
        nbt.func_74776_a(S_PLAYER_YAW, this.prevFacing);
        nbt.func_74768_a(S_PLAYER_DIM, this.getPrevDimension());
        if (this.owner != null) {
            nbt.func_186854_a(S_PLAYER_UUID, this.owner);
        }
        return nbt;
    }

    public BlockPos getDoorPos() {
        return TileEntityTentDoor.getTentDoorPos(this.getTentData().getID());
    }

    public void setOverworldXYZ(double posX, double posY, double posZ) {
        this.prevX = posX;
        this.prevY = posY;
        this.prevZ = posZ;
    }

    public void setPrevDimension(int dimID) {
        this.prevDimID = dimID;
    }

    public void setPrevFacing(float facing) {
        this.prevFacing = facing;
    }

    public int getPrevDimension() {
        return this.prevDimID;
    }

    public double getPrevX() {
        return this.prevX;
    }

    public double getPrevY() {
        return this.prevY;
    }

    public double getPrevZ() {
        return this.prevZ;
    }

    public float getPrevFacing() {
        return this.prevFacing;
    }

    public void setOwner(@Nullable UUID uuid) {
        this.owner = uuid;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public boolean isOwner(EntityPlayer player) {
        return !this.hasOwner() || EntityPlayer.func_175147_b((String)player.func_70005_c_()).equals(this.owner) || player.field_71075_bZ.field_75098_d;
    }

    @Nullable
    public UUID getOwnerId() {
        return this.owner;
    }

    @Nullable
    public EntityPlayer getOwner() {
        if (this.hasOwner() && !this.field_145850_b.field_72995_K) {
            return this.field_145850_b.func_73046_m().func_184103_al().func_177451_a(this.owner);
        }
        return null;
    }

    private boolean teleport(Entity entity) {
        TentEvent.PreEnter event;
        EntityPlayerMP player;
        int dimFrom = entity.func_130014_f_().field_73011_w.getDimension();
        int dimTo = TentDimension.isTentDimension(dimFrom) ? this.getPrevDimension() : TentDimension.DIMENSION_ID;
        EntityPlayerMP entityPlayerMP = player = entity instanceof EntityPlayerMP ? (EntityPlayerMP)entity : null;
        if (TentDimension.isTentDimension(dimTo) && MinecraftForge.EVENT_BUS.post((Event)(event = new TentEvent.PreEnter(this, entity)))) {
            return false;
        }
        entity.func_181015_d(this.func_174877_v());
        if (entity.field_71088_bW <= 0) {
            entity.field_71088_bW = entity.func_82147_ab();
            MinecraftServer mcServer = entity.func_184102_h();
            WorldServer worldTo = mcServer.func_71218_a(dimTo);
            TentTeleporter tel = new TentTeleporter(dimFrom, worldTo, this);
            if (player != null && TentConfig.GENERAL.ALLOW_OVERWORLD_SETSPAWN && dimFrom == TentDimension.DIMENSION_ID && dimTo == TentConfig.GENERAL.RESPAWN_DIMENSION) {
                TileEntityTentDoor.attemptSetSpawn(this.func_145831_w(), player, this.func_174877_v().func_177982_a(this.tent.getWidth().getDoorZ(), 0, 0), this.prevX, this.prevY, this.prevZ);
            }
            if (player != null && !TentConfig.GENERAL.SAFE_TELEPORT) {
                try {
                    ReflectionHelper.setPrivateValue(EntityPlayerMP.class, (Object)player, (Object)true, (String[])new String[]{"field_184851_cj", "invulnerableDimensionChange"});
                    mcServer.func_184103_al().transferPlayerToDimension(player, dimTo, (ITeleporter)tel);
                }
                catch (ReflectionHelper.UnableToFindFieldException e) {
                    NomadicTents.LOGGER.error("Failed to update 'invulnerableDimensionChange' for player!");
                    NomadicTents.LOGGER.catching((Throwable)e);
                    return false;
                }
            } else {
                entity.changeDimension(dimTo, (ITeleporter)tel);
            }
            return true;
        }
        entity.field_71088_bW = entity.func_82147_ab();
        return false;
    }

    private static boolean attemptSetSpawn(World worldFrom, EntityPlayerMP player, BlockPos tentCenter, double prevX, double prevY, double prevZ) {
        BlockPos bedSpawn;
        int overworldId = TentConfig.GENERAL.RESPAWN_DIMENSION;
        WorldServer overworld = worldFrom.func_73046_m().func_71218_a(overworldId);
        BlockPos prevCoords = new BlockPos(prevX, prevY, prevZ);
        TentSaveData data = TentSaveData.forWorld(worldFrom);
        UUID uuid = EntityPlayer.func_175147_b((String)player.func_70005_c_());
        BlockPos oldSpawn = player.getBedLocation(overworldId);
        BlockPos blockPos = bedSpawn = oldSpawn != null ? EntityPlayer.func_180467_a((World)overworld, (BlockPos)oldSpawn, (boolean)false) : null;
        if (bedSpawn == null) {
            oldSpawn = overworld.field_73011_w.getRandomizedSpawnPoint();
        }
        if (TileEntityTentDoor.isSpawnInTent((EntityPlayer)player, tentCenter, true) && !data.containsSpawn(uuid) && overworld.field_73011_w.func_76567_e()) {
            data.putSpawn(uuid, oldSpawn);
            player.setSpawnChunk(prevCoords, true, overworldId);
            return true;
        }
        if (TileEntityTentDoor.isSpawnInTent((EntityPlayer)player, tentCenter, false)) {
            TileEntityTentDoor.resetOverworldSpawn((EntityPlayer)player);
        }
        return false;
    }

    public void onPlayerRemove(EntityPlayer playerIn) {
        if (TentConfig.GENERAL.ALLOW_OVERWORLD_SETSPAWN) {
            BlockPos tentCenter = this.getDoorPos().func_177982_a(this.getTentData().getWidth().getDoorZ(), 0, 0);
            MinecraftServer mcServer = playerIn.func_130014_f_().func_73046_m();
            for (EntityPlayerMP player : mcServer.func_184103_al().func_181057_v()) {
                if (player == null || !TileEntityTentDoor.isSpawnInTent((EntityPlayer)player, tentCenter, false)) continue;
                TileEntityTentDoor.resetOverworldSpawn((EntityPlayer)player);
            }
        }
    }

    private static void resetOverworldSpawn(EntityPlayer player) {
        WorldServer overworld = player.func_130014_f_().func_73046_m().func_71218_a(TentConfig.GENERAL.RESPAWN_DIMENSION);
        UUID uuid = EntityPlayer.func_175147_b((String)player.func_70005_c_());
        TentSaveData data = TentSaveData.forWorld((World)overworld);
        BlockPos posToSet = player.getBedLocation(TentConfig.GENERAL.RESPAWN_DIMENSION);
        if (posToSet == null || EntityPlayer.func_180467_a((World)overworld, (BlockPos)posToSet, (boolean)false) == null) {
            BlockPos oldSpawn = data.getSpawn(uuid);
            posToSet = oldSpawn == null || EntityPlayer.func_180467_a((World)overworld, (BlockPos)oldSpawn, (boolean)false) == null ? player.func_130014_f_().field_73011_w.getRandomizedSpawnPoint() : oldSpawn;
        }
        player.func_180473_a(posToSet, false);
        data.removeSpawn(uuid);
    }

    private static boolean isSpawnInTent(EntityPlayer player, BlockPos tentCenter, boolean andBed) {
        BlockPos tentSpawn = player.getBedLocation(TentDimension.DIMENSION_ID);
        if (andBed && tentSpawn != null) {
            tentSpawn = EntityPlayer.func_180467_a((World)player.func_184102_h().func_71218_a(TentDimension.DIMENSION_ID), (BlockPos)tentSpawn, (boolean)false);
        }
        double maxDistanceSq = Math.pow(25.6, 2.0) + 1.0;
        return tentSpawn != null && tentCenter.func_177951_i((Vec3i)tentSpawn) < maxDistanceSq;
    }

    public boolean onEntityCollide(Entity entity, EnumFacing tentDir) {
        if (this.canTeleportEntity(entity) && (entity instanceof EntityPlayer && TentConfig.GENERAL.ALLOW_PLAYER_COLLIDE || !(entity instanceof EntityPlayer) && TentConfig.GENERAL.ALLOW_NONPLAYER_COLLIDE)) {
            if (!TentDimension.isTentDimension(entity.func_130014_f_())) {
                BlockPos respawn = this.func_174877_v().func_177967_a(tentDir.func_176734_d(), 1);
                double posX = (double)respawn.func_177958_n() + 0.5;
                double posY = (double)respawn.func_177956_o() + 0.01;
                double posZ = (double)respawn.func_177952_p() + 0.5;
                this.setOverworldXYZ(posX, posY, posZ);
                this.setPrevFacing(tentDir.func_185119_l());
            }
            return this.teleport(entity);
        }
        return false;
    }

    public boolean onPlayerActivate(EntityPlayer player) {
        if (this.canTeleportEntity((Entity)player)) {
            if (!TentDimension.isTentDimension(player.func_130014_f_())) {
                double posX = player.field_70165_t;
                double posY = player.field_70163_u;
                double posZ = player.field_70161_v;
                this.setOverworldXYZ(posX, posY, posZ);
                this.setPrevFacing(player.func_70079_am());
            }
            return this.teleport((Entity)player);
        }
        return false;
    }

    public boolean canTeleportEntity(Entity entity) {
        if (entity == null || entity.func_130014_f_().field_72995_K) {
            return false;
        }
        if (!TentDimension.isTentDimension(entity.func_130014_f_()) && TentConfig.GENERAL.OWNER_ENTRANCE && entity instanceof EntityPlayer && !this.isOwner((EntityPlayer)entity)) {
            return false;
        }
        boolean ridingFlag = entity.func_184218_aH() || entity.func_184207_aI();
        boolean isInvalidClass = entity instanceof EntityEnderman;
        return !ridingFlag && !isInvalidClass && entity.func_184222_aU();
    }
}

