/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.crafting;

import com.google.gson.JsonObject;
import com.yurtmod.crafting.RecipeUpgradeWidth;
import com.yurtmod.structure.util.StructureData;
import com.yurtmod.structure.util.StructureDepth;
import com.yurtmod.structure.util.StructureTent;
import com.yurtmod.structure.util.StructureWidth;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class RecipeUpgradeColor
extends ShapedRecipes
implements IRecipe {
    public static final String CATEGORY = "tentcraftingcolor";
    public static final RecipeUpgradeColor EMPTY = new RecipeUpgradeColor();
    private final EnumDyeColor colorOut;

    public RecipeUpgradeColor(EnumDyeColor color, NonNullList<Ingredient> ingredients, boolean hasWater) {
        super(CATEGORY, hasWater ? 1 : 3, hasWater ? 2 : 3, ingredients, new StructureData().setColor(color).setAll(StructureTent.SHAMIANA, StructureWidth.SMALL, StructureDepth.NORMAL).getDropStack());
        this.colorOut = color;
    }

    private RecipeUpgradeColor() {
        super(CATEGORY, 3, 3, NonNullList.func_191196_a(), ItemStack.field_190927_a);
        this.colorOut = EnumDyeColor.WHITE;
    }

    public static boolean hasWaterBucket(NonNullList<Ingredient> ingredients) {
        for (Ingredient i : ingredients) {
            for (ItemStack s : i.func_193365_a()) {
                if (s.func_190926_b() || s.func_77973_b() != Items.field_151131_as) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        if (this != EMPTY && super.func_77569_a(inv, worldIn)) {
            ItemStack tentStack = RecipeUpgradeWidth.getTentStack(inv);
            if (tentStack.func_190926_b()) {
                return false;
            }
            StructureData data = new StructureData(tentStack.func_190925_c("TentData"));
            if (data.getTent() == StructureTent.SHAMIANA && (this.colorOut == EnumDyeColor.WHITE || data.getColor() == EnumDyeColor.WHITE)) {
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        NBTTagCompound resultTag;
        if (this == EMPTY) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = super.func_77572_b(inv);
        ItemStack inputTent = RecipeUpgradeWidth.getTentStack(inv);
        NBTTagCompound nBTTagCompound = resultTag = result.func_77942_o() ? result.func_77978_p() : new NBTTagCompound();
        if (inputTent != null && inputTent.func_77942_o()) {
            StructureData tentData = new StructureData(inputTent);
            tentData.setColor(this.colorOut);
            resultTag.func_74782_a("TentData", (NBTBase)tentData.serializeNBT());
        }
        result.func_77982_d(resultTag);
        return result;
    }

    public boolean func_192399_d() {
        return true;
    }

    public EnumDyeColor getColorOut() {
        return this.colorOut;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            if (json.has("disabled")) {
                return EMPTY;
            }
            ShapedRecipes recipe = ShapedRecipes.func_193362_a((JsonObject)json);
            String colorName = JsonUtils.func_151200_h((JsonObject)json, (String)"result_color");
            EnumDyeColor color = EnumDyeColor.WHITE;
            for (EnumDyeColor c : EnumDyeColor.values()) {
                if (!c.func_176610_l().equals(colorName)) continue;
                color = c;
                break;
            }
            return new RecipeUpgradeColor(color, (NonNullList<Ingredient>)recipe.func_192400_c(), RecipeUpgradeColor.hasWaterBucket((NonNullList<Ingredient>)recipe.func_192400_c()));
        }
    }
}

