/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.crafting;

import com.google.gson.JsonObject;
import com.yurtmod.crafting.RecipeUpgradeWidth;
import com.yurtmod.item.ItemDepthUpgrade;
import com.yurtmod.structure.util.StructureData;
import com.yurtmod.structure.util.StructureDepth;
import com.yurtmod.structure.util.StructureTent;
import com.yurtmod.structure.util.StructureWidth;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class RecipeUpgradeDepth
extends ShapedRecipes
implements IRecipe {
    public static final String CATEGORY = "tentcraftingdepth";
    public static final RecipeUpgradeDepth EMPTY = new RecipeUpgradeDepth();
    private final StructureTent tent;
    private final StructureWidth widthIn;
    private final StructureDepth depthIn;
    private final StructureDepth depthOut;

    public RecipeUpgradeDepth(StructureDepth depthFrom, StructureDepth depthTo, StructureTent tentType, StructureWidth minSize, NonNullList<Ingredient> ingredients) {
        super(CATEGORY, 3, 3, ingredients, new StructureData().setAll(tentType, minSize, depthTo).getDropStack());
        this.depthIn = depthFrom;
        this.depthOut = depthTo;
        this.tent = tentType;
        this.widthIn = minSize;
    }

    private RecipeUpgradeDepth() {
        super(CATEGORY, 3, 3, NonNullList.func_191196_a(), ItemStack.field_190927_a);
        this.tent = StructureTent.YURT;
        this.widthIn = StructureWidth.SMALL;
        this.depthIn = StructureDepth.NORMAL;
        this.depthOut = StructureDepth.NORMAL;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        if (this != EMPTY && super.func_77569_a(inv, worldIn)) {
            ItemStack tentStack = RecipeUpgradeWidth.getTentStack(inv);
            ItemStack upgradeStack = RecipeUpgradeWidth.getStackMatching(inv, ItemDepthUpgrade.class);
            if (tentStack.func_190926_b() || upgradeStack.func_190926_b()) {
                return false;
            }
            StructureData data = new StructureData(tentStack.func_190925_c("TentData"));
            if (data.getTent() == this.tent && data.getDepth() == this.depthIn && data.getWidth().getId() >= this.widthIn.getId() && this.depthOut.getId() < data.getWidth().getMaxDepth()) {
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        NBTTagCompound resultTag;
        if (this == EMPTY) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = super.func_77572_b(inv);
        ItemStack inputTent = RecipeUpgradeWidth.getTentStack(inv);
        NBTTagCompound nBTTagCompound = resultTag = result.func_77942_o() ? result.func_77978_p() : new NBTTagCompound();
        if (inputTent != null && inputTent.func_77942_o()) {
            StructureData tentData = new StructureData(inputTent);
            tentData.setDepth(this.depthOut);
            resultTag.func_74782_a("TentData", (NBTBase)tentData.serializeNBT());
        }
        result.func_77982_d(resultTag);
        return result;
    }

    public boolean func_192399_d() {
        return true;
    }

    public StructureTent getTentType() {
        return this.tent;
    }

    public StructureWidth getMinSize() {
        return this.widthIn;
    }

    public StructureDepth getDepthIn() {
        return this.depthIn;
    }

    public StructureDepth getDepthOut() {
        return this.depthOut;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            if (json.has("disabled")) {
                return EMPTY;
            }
            ShapedRecipes recipe = ShapedRecipes.func_193362_a((JsonObject)json);
            StructureTent tentIn = StructureTent.getByName(JsonUtils.func_151200_h((JsonObject)json, (String)"tent_type"));
            StructureWidth minWidth = StructureWidth.getByName(JsonUtils.func_151200_h((JsonObject)json, (String)"min_size"));
            StructureDepth depthIn = StructureDepth.getById((byte)JsonUtils.func_151203_m((JsonObject)json, (String)"input_depth"));
            StructureDepth depthOut = StructureDepth.getById((byte)JsonUtils.func_151203_m((JsonObject)json, (String)"result_depth"));
            return new RecipeUpgradeDepth(depthIn, depthOut, tentIn, minWidth, (NonNullList<Ingredient>)recipe.func_192400_c());
        }
    }
}

