/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.crafting;

import com.google.gson.JsonObject;
import com.yurtmod.init.Content;
import com.yurtmod.item.ItemTent;
import com.yurtmod.structure.util.StructureData;
import com.yurtmod.structure.util.StructureDepth;
import com.yurtmod.structure.util.StructureTent;
import com.yurtmod.structure.util.StructureWidth;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class RecipeUpgradeWidth
extends ShapedRecipes
implements IRecipe {
    public static final String CATEGORY = "tentcraftingwidth";
    public static final RecipeUpgradeWidth EMPTY = new RecipeUpgradeWidth();
    private final StructureTent tent;
    private final StructureWidth widthIn;
    private final StructureWidth widthOut;

    public RecipeUpgradeWidth(StructureTent type, @Nullable StructureWidth widthFrom, StructureWidth widthTo, NonNullList<Ingredient> ingredients) {
        super(CATEGORY, 3, RecipeUpgradeWidth.calcRecipeHeight(type, widthTo), ingredients, new StructureData().setAll(type, widthTo, StructureDepth.NORMAL).writeTo(new ItemStack(Content.ITEM_TENT)));
        this.tent = type;
        this.widthIn = widthFrom;
        this.widthOut = widthTo;
    }

    private RecipeUpgradeWidth() {
        super(CATEGORY, 3, 3, NonNullList.func_191196_a(), ItemStack.field_190927_a);
        this.tent = StructureTent.YURT;
        this.widthIn = StructureWidth.SMALL;
        this.widthOut = StructureWidth.SMALL;
    }

    private static int calcRecipeHeight(StructureTent type, StructureWidth widthTo) {
        if (type == StructureTent.YURT || type == StructureTent.SHAMIANA && widthTo.getId() < StructureWidth.HUGE.getId()) {
            return 2;
        }
        return 3;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        if (this != EMPTY && super.func_77569_a(inv, worldIn)) {
            ItemStack tentStack = RecipeUpgradeWidth.getTentStack(inv);
            if (tentStack.func_190926_b() && null == this.widthIn) {
                return true;
            }
            StructureData data = new StructureData(tentStack);
            if (data.getTent() == this.tent && data.getWidth() == this.widthIn && this.widthOut.getId() < data.getTent().getMaxSize()) {
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        if (this == EMPTY) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = super.func_77572_b(inv);
        NBTTagCompound resultTag = result.func_77942_o() ? result.func_77978_p() : new NBTTagCompound();
        ItemStack inputTent = RecipeUpgradeWidth.getTentStack(inv);
        if (!inputTent.func_190926_b() && inputTent.func_77942_o()) {
            StructureData tentData = new StructureData(inputTent);
            tentData.setWidth(this.widthOut);
            resultTag.func_74782_a("TentData", (NBTBase)tentData.serializeNBT());
        } else {
            StructureData data = new StructureData().setAll(this.tent, this.widthOut, StructureDepth.NORMAL);
            resultTag.func_74782_a("TentData", (NBTBase)data.serializeNBT());
        }
        result.func_77982_d(resultTag);
        return result;
    }

    public boolean func_192399_d() {
        return true;
    }

    public StructureTent getTent() {
        return this.tent;
    }

    public StructureWidth getWidthIn() {
        return this.widthIn;
    }

    public StructureWidth getWidthOut() {
        return this.widthOut;
    }

    public static ItemStack getStackMatching(InventoryCrafting inv, Class<? extends Item> itemClass) {
        int l = inv.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() == null || !itemClass.isAssignableFrom(stack.func_77973_b().getClass())) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getTentStack(InventoryCrafting inv) {
        return RecipeUpgradeWidth.getStackMatching(inv, ItemTent.class);
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            if (json.has("disabled")) {
                return EMPTY;
            }
            ShapedRecipes recipe = ShapedRecipes.func_193362_a((JsonObject)json);
            StructureTent tentType = StructureTent.getByName(JsonUtils.func_151200_h((JsonObject)json, (String)"tent_type"));
            StructureWidth widthIn = StructureWidth.getByName(JsonUtils.func_151200_h((JsonObject)json, (String)"input_size"));
            StructureWidth widthOut = StructureWidth.getByName(JsonUtils.func_151200_h((JsonObject)json, (String)"result_size"));
            return new RecipeUpgradeWidth(tentType, widthIn, widthOut, (NonNullList<Ingredient>)recipe.func_192400_c());
        }
    }
}

