/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.dimension;

import com.yurtmod.block.TileEntityTentDoor;
import com.yurtmod.dimension.TentDimension;
import com.yurtmod.event.TentEvent;
import com.yurtmod.init.TentConfig;
import com.yurtmod.structure.util.StructureData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TentTeleporter
extends Teleporter {
    private final StructureData tentData;
    private final BlockPos tentDoorPos;
    private final EnumDyeColor color;
    private final double prevX;
    private final double prevY;
    private final double prevZ;
    private final float prevYaw;
    private final int prevDimID;
    private final WorldServer worldServerTo;

    public TentTeleporter(int dimensionFrom, WorldServer worldTo, BlockPos doorPos, EnumDyeColor colorIn, double oldX, double oldY, double oldZ, float oldYaw, StructureData data) {
        super(worldTo);
        this.prevDimID = dimensionFrom;
        this.worldServerTo = worldTo;
        this.tentDoorPos = doorPos;
        this.color = colorIn;
        this.prevX = oldX;
        this.prevY = oldY;
        this.prevZ = oldZ;
        this.prevYaw = oldYaw;
        this.tentData = data;
    }

    public TentTeleporter(int worldFrom, WorldServer worldTo, TileEntityTentDoor te) {
        this(worldFrom, worldTo, te.getDoorPos(), te.getTentData().getColor(), te.getPrevX(), te.getPrevY(), te.getPrevZ(), te.getPrevFacing(), te.getTentData());
    }

    public void func_180266_a(Entity entity, float rotationYaw) {
        double entityX = this.getX();
        double entityY = this.getY();
        double entityZ = this.getZ();
        float yaw = this.getYaw();
        float pitch = entity.field_70125_A;
        entity.field_70179_y = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70159_w = 0.0;
        TentEvent.TentResult result = TentEvent.TentResult.NONE;
        if (TentDimension.isTentDimension((World)this.worldServerTo)) {
            entityX += (double)entity.field_70130_N;
            result = this.tentData.getStructure().generateInTentDimension(this.prevDimID, (World)this.worldServerTo, this.tentDoorPos, this.prevX, this.prevY, this.prevZ, this.prevYaw, this.color);
            this.worldServerTo.func_72912_H().func_76068_b(entity.func_184102_h().func_71218_a(TentConfig.GENERAL.RESPAWN_DIMENSION).func_72820_D());
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.field_71135_a.func_147364_a(entityX, entityY, entityZ, yaw, pitch);
            player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            player.field_71134_c.func_73080_a(this.worldServerTo);
            player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        } else {
            entity.func_70012_b(entityX, entityY, entityZ, yaw, pitch);
        }
        if (TentDimension.isTentDimension((World)this.worldServerTo) && this.worldServerTo.func_175625_s(this.tentDoorPos) instanceof TileEntityTentDoor) {
            TentEvent.PostEnter event = new TentEvent.PostEnter((TileEntityTentDoor)this.worldServerTo.func_175625_s(this.tentDoorPos), entity, result);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    public boolean func_180620_b(Entity entity, float f) {
        this.func_180266_a(entity, f);
        return true;
    }

    public double getX() {
        return TentDimension.isTentDimension((World)this.worldServerTo) ? (double)this.tentDoorPos.func_177958_n() + 0.9 : this.prevX;
    }

    public double getY() {
        return TentDimension.isTentDimension((World)this.worldServerTo) ? (double)this.tentDoorPos.func_177956_o() + 0.01 : this.prevY;
    }

    public double getZ() {
        return TentDimension.isTentDimension((World)this.worldServerTo) ? (double)this.tentDoorPos.func_177952_p() + 0.5 : this.prevZ;
    }

    public float getYaw() {
        return TentDimension.isTentDimension((World)this.worldServerTo) ? -90.0f : MathHelper.func_76142_g((float)(this.prevYaw + 180.0f));
    }

    public String toString() {
        String out = "\n[TentTeleporter]\nstructure=" + this.tentData + "\ntentDoorPos=" + this.tentDoorPos + "\nprevX=" + this.prevX + "\nprevY=" + this.prevY + "\nprevZ=" + this.prevZ + "\nprevFacing=" + this.prevYaw + "\nprevDimID=" + this.prevDimID + "\nnextDimID=" + this.worldServerTo.field_73011_w.getDimension() + "\n";
        return out;
    }
}

