/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.event;

import com.yurtmod.block.TileEntityTentDoor;
import com.yurtmod.dimension.TentDimension;
import com.yurtmod.structure.util.StructureData;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TentEvent
extends Event {
    private final TileEntityTentDoor teDoor;

    public TentEvent(TileEntityTentDoor door) {
        this.teDoor = door;
    }

    public TileEntityTentDoor getDoor() {
        return this.teDoor;
    }

    @Nullable
    public StructureData getData() {
        return this.teDoor != null ? this.teDoor.getTentData() : null;
    }

    @Nullable
    public BlockPos getDoorPos() {
        return this.teDoor != null ? this.teDoor.func_174877_v() : null;
    }

    public boolean isInsideTent() {
        return this.teDoor != null ? TentDimension.isTentDimension(this.teDoor.func_145831_w()) : false;
    }

    @Nullable
    public int getDimensionId() {
        return this.teDoor != null ? Integer.valueOf(this.teDoor.func_145831_w().field_73011_w.getDimension()) : null;
    }

    public static enum TentResult {
        NONE,
        BUILT_FIRST,
        UPGRADED;

    }

    public static class PostEnter
    extends TentEvent {
        private final Entity entity;
        private final TentResult tentResult;

        public PostEnter(TileEntityTentDoor door, Entity entityIn, TentResult resultIn) {
            super(door);
            this.entity = entityIn;
            this.tentResult = resultIn;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public boolean isPlayer() {
            return this.entity instanceof EntityPlayer;
        }

        public TentResult getTentResult() {
            return this.tentResult;
        }
    }

    @Cancelable
    public static class PreEnter
    extends TentEvent {
        private final Entity entity;

        public PreEnter(TileEntityTentDoor door, Entity entityIn) {
            super(door);
            this.entity = entityIn;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public boolean isPlayer() {
            return this.entity instanceof EntityPlayer;
        }
    }

    public static class Deconstruct
    extends TentEvent {
        final EntityPlayer player;

        public Deconstruct(TileEntityTentDoor door, EntityPlayer playerIn) {
            super(door);
            this.player = playerIn;
        }

        public ItemStack getTentStack() {
            return this.getData() != null ? this.getData().getDropStack() : ItemStack.field_190927_a;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }
    }
}

