/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.event;

import com.yurtmod.dimension.TentDimension;
import com.yurtmod.dimension.TentTeleporter;
import com.yurtmod.init.TentConfig;
import com.yurtmod.item.ItemTent;
import com.yurtmod.structure.util.StructureData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemChorusFruit;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class TentEventHandler {
    @SubscribeEvent
    public void onPlayerWake(PlayerWakeUpEvent event) {
        if (!event.getEntityPlayer().func_130014_f_().field_72995_K && event.getEntityPlayer().func_130014_f_().func_82736_K().func_82766_b("doDaylightCycle")) {
            MinecraftServer server = event.getEntityPlayer().func_184102_h();
            WorldServer overworld = server.func_71218_a(TentConfig.GENERAL.RESPAWN_DIMENSION);
            WorldServer tentDim = server.func_71218_a(TentDimension.DIMENSION_ID);
            if (TentDimension.isTentDimension(event.getEntityPlayer().func_130014_f_())) {
                boolean shouldChangeTime = TentConfig.GENERAL.ALLOW_SLEEP_TENT_DIM;
                if (TentConfig.GENERAL.IS_SLEEPING_STRICT) {
                    for (EntityPlayer p : overworld.field_73010_i) {
                        if (p == event.getEntityPlayer()) continue;
                        shouldChangeTime &= p.func_70608_bn();
                    }
                }
                if (shouldChangeTime) {
                    long nextDay = overworld.func_72912_H().func_76073_f() + 24000L;
                    overworld.func_72912_H().func_76068_b(nextDay - nextDay % 24000L);
                }
            }
            tentDim.func_72912_H().func_76068_b(overworld.func_72820_D());
            overworld.func_72854_c();
            tentDim.func_72854_c();
        }
    }

    @SubscribeEvent
    public void onSpawnEntity(EntityJoinWorldEvent event) {
        ItemStack stack;
        if (TentConfig.GENERAL.IS_TENT_FIREPROOF && event.getEntity() instanceof EntityItem && (stack = ((EntityItem)event.getEntity()).func_92059_d()) != null && stack.func_77973_b() instanceof ItemTent) {
            event.getEntity().func_184224_h(true);
        }
    }

    @SubscribeEvent
    public void onItemUse(LivingEntityUseItemEvent.Start event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getItem().func_190926_b() && event.getItem().func_77973_b() instanceof ItemChorusFruit && TentEventHandler.canCancelTeleport(player = (EntityPlayer)event.getEntityLiving())) {
            event.setDuration(-100);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.no_teleport", new Object[0]), true);
        }
    }

    @SubscribeEvent
    public void onTeleport(EnderTeleportEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && TentEventHandler.canCancelTeleport(player = (EntityPlayer)event.getEntityLiving())) {
            event.setCanceled(true);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.no_teleport", new Object[0]), true);
        }
    }

    private static boolean canCancelTeleport(EntityPlayer player) {
        return TentConfig.GENERAL.RESTRICT_TELEPORT_TENT_DIM && TentDimension.isTentDimension(player.func_130014_f_()) && !player.func_184812_l_() && !player.field_70170_p.field_72995_K;
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player instanceof EntityPlayerMP && !event.player.func_130014_f_().field_72995_K) {
            int TENTDIM = TentDimension.DIMENSION_ID;
            int RESPAWN = TentConfig.GENERAL.RESPAWN_DIMENSION;
            int CUR_DIM = event.player.func_130014_f_().field_73011_w.getDimension();
            EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
            MinecraftServer mcServer = playerMP.func_184102_h();
            WorldServer tentServer = mcServer.func_71218_a(TENTDIM);
            WorldServer overworld = mcServer.func_71218_a(RESPAWN);
            if (TentConfig.GENERAL.ALLOW_RESPAWN_INTERCEPT && CUR_DIM == TENTDIM) {
                BlockPos respawnPos;
                BlockPos bedPos = playerMP.getBedLocation(TENTDIM);
                BlockPos blockPos = respawnPos = bedPos != null ? EntityPlayer.func_180467_a((World)tentServer, (BlockPos)bedPos, (boolean)false) : null;
                if (null == respawnPos) {
                    bedPos = playerMP.getBedLocation(RESPAWN);
                    BlockPos blockPos2 = respawnPos = bedPos != null ? EntityPlayer.func_180467_a((World)overworld, (BlockPos)bedPos, (boolean)false) : null;
                    if (respawnPos == null) {
                        respawnPos = overworld.field_73011_w.getRandomizedSpawnPoint();
                    }
                    TentTeleporter tel = new TentTeleporter(TentDimension.DIMENSION_ID, overworld, new BlockPos(0, 0, 0), null, respawnPos.func_177958_n(), respawnPos.func_177956_o(), respawnPos.func_177952_p(), event.player.field_70177_z, new StructureData());
                    mcServer.func_184103_al().transferPlayerToDimension(playerMP, RESPAWN, (Teleporter)tel);
                    event.player.func_70634_a((double)respawnPos.func_177958_n(), (double)respawnPos.func_177956_o(), (double)respawnPos.func_177952_p());
                }
            }
        }
    }

    @SubscribeEvent
    public void onNameFormat(PlayerEvent.NameFormat event) {
        String PREFIX = "[Tent Overlord] ";
        String GOLD = "";
        String RESET = "";
        try {
            GOLD = TextFormatting.GOLD.toString();
            RESET = TextFormatting.RESET.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("skyjay1".equals(event.getUsername())) {
            String special = GOLD + PREFIX + RESET;
            event.setDisplayname(special.concat(event.getDisplayname()));
        }
    }
}

