/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.init;

import com.yurtmod.structure.util.StructureDepth;
import com.yurtmod.structure.util.StructureWidth;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Config;

@Config(modid="yurtmod", name="NomadicTents", category="config")
public final class TentConfig {
    public static final ConfigGeneral GENERAL = new ConfigGeneral();
    public static final ConfigTents TENTS = new ConfigTents();

    public static class ConfigTents {
        private static final String NOTE = "Note: Disable recipe by inserting ' \"disabled\":true ' in the JSON file";
        private static final String featureComment = "Enables pre-built features in new tents (torches, campfires, etc)";
        @Config.Name(value="Enable Yurt")
        @Config.Comment(value={"Whether the Yurt can be built and used"})
        public boolean ALLOW_YURT = true;
        @Config.Name(value="Enable Tepee")
        @Config.Comment(value={"Whether the Tepee can be built and used"})
        public boolean ALLOW_TEPEE = true;
        @Config.Name(value="Enable Bedouin")
        @Config.Comment(value={"Whether the Bedouin can be built and used"})
        public boolean ALLOW_BEDOUIN = true;
        @Config.Name(value="Enable Indlu")
        @Config.Comment(value={"Whether the Indlu can be built and used"})
        public boolean ALLOW_INDLU = true;
        @Config.Name(value="Enable Shamiana")
        @Config.Comment(value={"Whether the Shamiana can be built and used"})
        public boolean ALLOW_SHAMIANA = true;
        @Config.Name(value="Max Tiers: Yurt")
        @Config.Comment(value={"Limit the size upgrades a Yurt can recieve. 1=SMALL, 6=MEGA", "Note: Disable recipe by inserting ' \"disabled\":true ' in the JSON file"})
        @Config.RangeInt(min=1, max=6)
        public int TIERS_YURT = StructureWidth.values().length;
        @Config.Name(value="Max Tiers: Tepee")
        @Config.Comment(value={"Limit the size upgrades a Tepee can recieve. 1=SMALL, 6=MEGA", "Note: Disable recipe by inserting ' \"disabled\":true ' in the JSON file"})
        @Config.RangeInt(min=1, max=6)
        public int TIERS_TEPEE = StructureWidth.values().length;
        @Config.Name(value="Max Tiers: Bedouin")
        @Config.Comment(value={"Limit the size upgrades a Bedouin can recieve. 1=SMALL, 6=MEGA", "Note: Disable recipe by inserting ' \"disabled\":true ' in the JSON file"})
        @Config.RangeInt(min=1, max=6)
        public int TIERS_BEDOUIN = StructureWidth.values().length;
        @Config.Name(value="Max Tiers: Indlu")
        @Config.Comment(value={"Limit the size upgrades an Indlu can recieve. 1=SMALL, 6=MEGA", "Note: Disable recipe by inserting ' \"disabled\":true ' in the JSON file"})
        @Config.RangeInt(min=1, max=6)
        public int TIERS_INDLU = StructureWidth.values().length;
        @Config.Name(value="Max Tiers: Shamiana")
        @Config.Comment(value={"Limit the size upgrades a Shamiana can recieve. 1=SMALL, 6=MEGA", "Note: Disable recipe by inserting ' \"disabled\":true ' in the JSON file"})
        @Config.RangeInt(min=1, max=6)
        public int TIERS_SHAMIANA = StructureWidth.values().length;
        @Config.Name(value="Max Depth: Small")
        @Config.Comment(value={"Limit the depth of a Small Tent. 1=No Upgrades, 6=Full Upgrades", "Note: Disable recipe by inserting ' \"disabled\":true ' in the JSON file"})
        @Config.RangeInt(min=1, max=6)
        public int DEPTH_SMALL = StructureDepth.NORMAL.getLayers();
        @Config.Name(value="Max Depth: Medium")
        @Config.Comment(value={"Limit the depth of a Medium Tent. 1=No Upgrades, 6=Full Upgrades", "Note: Disable recipe by inserting ' \"disabled\":true ' in the JSON file"})
        @Config.RangeInt(min=1, max=6)
        public int DEPTH_MEDIUM = StructureDepth.DOUBLE.getLayers();
        @Config.Name(value="Max Depth: Large")
        @Config.Comment(value={"Limit the depth of a Large Tent. 1=No Upgrades, 6=Full Upgrades", "Note: Disable recipe by inserting ' \"disabled\":true ' in the JSON file"})
        @Config.RangeInt(min=1, max=6)
        public int DEPTH_LARGE = StructureDepth.TRIPLE.getLayers();
        @Config.Name(value="Max Depth: Huge")
        @Config.Comment(value={"Limit the depth of a Huge Tent. 1=No Upgrades, 6=Full Upgrades", "Note: Disable recipe by inserting ' \"disabled\":true ' in the JSON file"})
        @Config.RangeInt(min=1, max=6)
        public int DEPTH_HUGE = StructureDepth.QUADRUPLE.getLayers();
        @Config.Name(value="Max Depth: Giant")
        @Config.Comment(value={"Limit the depth of a Giant Tent. 1=No Upgrades, 6=Full Upgrades", "Note: Disable recipe by inserting ' \"disabled\":true ' in the JSON file"})
        @Config.RangeInt(min=1, max=6)
        public int DEPTH_GIANT = StructureDepth.QUINTUPLE.getLayers();
        @Config.Name(value="Max Depth: Mega")
        @Config.Comment(value={"Limit the depth of a Mega Tent. 1=No Upgrades, 6=Full Upgrades", "Note: Disable recipe by inserting ' \"disabled\":true ' in the JSON file"})
        @Config.RangeInt(min=1, max=6)
        public int DEPTH_MEGA = StructureDepth.SEXTUPLE.getLayers();
        @Config.Name(value="Enable Yurt Features")
        @Config.Comment(value={"Enables pre-built features in new tents (torches, campfires, etc)"})
        public boolean ENABLE_YURT_FEATURES = true;
        @Config.Name(value="Enable Tepee Features")
        @Config.Comment(value={"Enables pre-built features in new tents (torches, campfires, etc)"})
        public boolean ENABLE_TEPEE_FEATURES = true;
        @Config.Name(value="Enable Bedouin Features")
        @Config.Comment(value={"Enables pre-built features in new tents (torches, campfires, etc)"})
        public boolean ENABLE_BEDOUIN_FEATURES = true;
        @Config.Name(value="Enable Indlu Features")
        @Config.Comment(value={"Enables pre-built features in new tents (torches, campfires, etc)"})
        public boolean ENABLE_INDLU_FEATURES = true;
        @Config.Name(value="Enable Shamiyana Features")
        @Config.Comment(value={"Enables pre-built features in new tents (torches, campfires, etc)"})
        public boolean ENABLE_SHAMIANA_FEATURES = true;
    }

    public static class ConfigGeneral {
        @Config.Name(value="Dimension ID")
        @Config.Comment(value={"ID for the Tent Dimension.", "Remove this field to automatically find an available ID"})
        @Config.RangeInt(min=-255, max=255)
        public int TENT_DIM_ID = DimensionManager.getNextFreeDimId();
        @Config.Name(value="Home Dimension ID")
        @Config.Comment(value={"The dimension in which players will respawn from the tent dimension as needed"})
        public int RESPAWN_DIMENSION = 0;
        @Config.Name(value="Dimension Blacklist")
        @Config.Comment(value={"Dimensions in which tents cannot be placed"})
        public String[] DIM_BLACKLIST = new String[]{"TENT"};
        @Config.Name(value="Allow Sleep in Tent")
        @Config.Comment(value={"When false, beds used in the Tent Dimension will explode"})
        public boolean ALLOW_SLEEP_TENT_DIM = true;
        @Config.Name(value="Restrict Teleporting")
        @Config.Comment(value={"When true, only creative-mode players can teleport within the Tent Dimension"})
        public boolean RESTRICT_TELEPORT_TENT_DIM = false;
        @Config.Name(value="Allow Respawn Logic")
        @Config.Comment(value={"When true, players who die in Tent Dimension will be sent to overworld IF they have no bed. Disable if buggy"})
        public boolean ALLOW_RESPAWN_INTERCEPT = true;
        @Config.Name(value="Allow Overworld spawnpoint")
        @Config.Comment(value={"When true, sleeping in a tent will set your Overworld spawn to the tent's outside location"})
        public boolean ALLOW_OVERWORLD_SETSPAWN = true;
        @Config.Name(value="Tent Sleeping Strict")
        @Config.Comment(value={"When true, players in a tent can only sleep through the night if overworld players are asleep too"})
        public boolean IS_SLEEPING_STRICT = true;
        @Config.Name(value="Super Mallet Creative Only")
        @Config.Comment(value={"When true, only Creative-mode players can use the Super Tent Mallet"})
        public boolean SUPER_MALLET_CREATIVE_ONLY = false;
        @Config.Name(value="Owner-Only Entrance")
        @Config.Comment(value={"When true, only the player who placed the tent can enter it"})
        public boolean OWNER_ENTRANCE = false;
        @Config.Name(value="Owner-Only Pickup")
        @Config.Comment(value={"When true, only the player who placed the tent can pick it up"})
        public boolean OWNER_PICKUP = false;
        @Config.Name(value="Allow Player Walk-In")
        @Config.Comment(value={"When true, players can enter the tent by walking through the door"})
        public boolean ALLOW_PLAYER_COLLIDE = true;
        @Config.Name(value="Allow Entity Walk-In")
        @Config.Comment(value={"When true, non-player entities can enter the tent by walking through the door"})
        public boolean ALLOW_NONPLAYER_COLLIDE = true;
        @Config.Name(value="Tepee Design Chance")
        @Config.Comment(value={"Percentage chance that a plain tepee block will randomly have a design"})
        @Config.RangeInt(min=0, max=100)
        public int TEPEE_DECORATED_CHANCE = 35;
        @Config.Name(value="Is Tent Fireproof")
        @Config.Comment(value={"When true, the tent item will not be destroyed if it is burned"})
        public boolean IS_TENT_FIREPROOF = false;
        @Config.Name(value="Copy is Creative-Only")
        @Config.Comment(value={"When true, only Creative mode players can duplicate a tent item", "(Note: this is done by clicking a tent door with any item that has NBT tag 'TentCopyTool' set to true)"})
        public boolean COPY_CREATIVE_ONLY = true;
        @Config.Name(value="Enable Weather")
        @Config.Comment(value={"Set to false to disable weather in Tent dimension"})
        public boolean ENABLE_WEATHER = true;
        @Config.Name(value="Safe Teleporting")
        @Config.Comment(value={"Use different teleportation code. Does two things:", "1) Updates XP and 2) Plays Nether sound"})
        public boolean SAFE_TELEPORT = false;
        @Config.Name(value="Use Actual Size")
        @Config.Comment(value={"When true, tents will be the same size on the outside and inside"})
        public boolean USE_ACTUAL_SIZE = false;
        @Config.Name(value="Tent Floor")
        @Config.Comment(value={"Specify the block used for the harvestable layer of all tent floors", "Format: [mod]:[name] ~ Example: minecraft:sand"})
        public String FLOOR_BLOCK = "minecraft:dirt";

        public Block getFloorBlock() {
            Block floor = Block.func_149684_b((String)this.FLOOR_BLOCK);
            if (floor == null || floor == Blocks.field_150484_ah || floor == Blocks.field_150340_R) {
                floor = Blocks.field_150346_d;
            }
            return floor;
        }

        public boolean isDimBlacklisted(World world) {
            String name = world.field_73011_w.func_186058_p().func_186065_b();
            for (String n : this.DIM_BLACKLIST) {
                if (!name.equals(n)) continue;
                return true;
            }
            return false;
        }
    }
}

