/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.init;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class TentSaveData
extends WorldSavedData {
    private static final String ID_COUNT = "IDCount";
    private static final String KEY_SPAWNS = "PlayerSpawnPoints";
    private static final String _UUID = ".UUID";
    private static final String _X = ".X";
    private static final String _Y = ".Y";
    private static final String _Z = ".Z";
    private long idCount = 0L;
    private Map<UUID, BlockPos> prevSpawnMap = new HashMap<UUID, BlockPos>();

    public TentSaveData(String s) {
        super(s);
    }

    public static TentSaveData forWorld(World world) {
        MapStorage storage = world.func_175693_T();
        TentSaveData result = (TentSaveData)storage.func_75742_a(TentSaveData.class, "yurtmod");
        if (result == null) {
            result = new TentSaveData("yurtmod");
            storage.func_75745_a("yurtmod", (WorldSavedData)result);
        }
        return result;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.idCount = nbt.func_74763_f(ID_COUNT);
        NBTTagList tagList = nbt.func_150295_c(KEY_SPAWNS, 9);
        int l = tagList.func_74745_c();
        for (int i = 0; i < l; ++i) {
            NBTTagCompound nbtCompound = tagList.func_150305_b(i);
            if (!nbtCompound.func_74764_b("PlayerSpawnPoints.UUID") || !nbtCompound.func_74764_b("PlayerSpawnPoints.X") || !nbtCompound.func_74764_b("PlayerSpawnPoints.Y") || !nbtCompound.func_74764_b("PlayerSpawnPoints.Z")) continue;
            UUID uuid = UUID.fromString(nbtCompound.func_74779_i("PlayerSpawnPoints.UUID"));
            int x = nbtCompound.func_74762_e("PlayerSpawnPoints.X");
            int y = nbtCompound.func_74762_e("PlayerSpawnPoints.Y");
            int z = nbtCompound.func_74762_e("PlayerSpawnPoints.Z");
            this.prevSpawnMap.put(uuid, new BlockPos(x, y, z));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74772_a(ID_COUNT, this.idCount);
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<UUID, BlockPos> uuid : this.prevSpawnMap.entrySet()) {
            BlockPos prevSpawn = uuid.getValue();
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74778_a("PlayerSpawnPoints.UUID", uuid.toString());
            tagCompound.func_74768_a("PlayerSpawnPoints.X", prevSpawn.func_177958_n());
            tagCompound.func_74768_a("PlayerSpawnPoints.Y", prevSpawn.func_177956_o());
            tagCompound.func_74768_a("PlayerSpawnPoints.Z", prevSpawn.func_177952_p());
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbt.func_74782_a(KEY_SPAWNS, (NBTBase)tagList);
        return nbt;
    }

    public long getNextID() {
        this.func_76185_a();
        return ++this.idCount;
    }

    public long getCurrentID() {
        return this.idCount;
    }

    public void putSpawn(UUID uuid, BlockPos pos) {
        if (uuid != null) {
            this.func_76185_a();
            this.prevSpawnMap.put(uuid, pos);
        }
    }

    public boolean containsSpawn(UUID uuid) {
        return this.prevSpawnMap.containsKey(uuid);
    }

    @Nullable
    public BlockPos getSpawn(UUID uuid) {
        return this.prevSpawnMap.get(uuid);
    }

    @Nullable
    public BlockPos removeSpawn(UUID uuid) {
        this.func_76185_a();
        return this.prevSpawnMap.remove(uuid);
    }
}

