/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.integration;

import com.yurtmod.block.BlockTentDoor;
import com.yurtmod.block.BlockTentFrame;
import com.yurtmod.block.BlockUnbreakable;
import com.yurtmod.block.TileEntityTentDoor;
import com.yurtmod.structure.util.StructureData;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.config.FormattingConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="mcp.mobius.waila.api.IWailaDataProvider", modid="waila")
public final class WailaProvider
implements IWailaDataProvider {
    private static final String KEY_STRUCTURE_DATA = "StructureData";

    @Optional.Method(modid="waila")
    public static void callbackRegister(IWailaRegistrar register) {
        WailaProvider instance = new WailaProvider();
        register.registerStackProvider((IWailaDataProvider)instance, BlockUnbreakable.class);
        register.registerNBTProvider((IWailaDataProvider)instance, BlockTentDoor.class);
        register.registerHeadProvider((IWailaDataProvider)instance, BlockTentFrame.class);
        register.registerBodyProvider((IWailaDataProvider)instance, BlockTentFrame.class);
    }

    @Nonnull
    @Optional.Method(modid="waila")
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        IBlockState state = accessor.getWorld().func_180495_p(accessor.getPosition());
        if (state != null) {
            if (state.func_177230_c() instanceof BlockTentDoor) {
                return new StructureData(accessor.getNBTData().func_74775_l(KEY_STRUCTURE_DATA)).getDropStack();
            }
            if (state.func_177230_c() instanceof BlockTentFrame) {
                return new ItemStack(((BlockTentFrame)state.func_177230_c()).getEnumBlockToBecome().getBlock().func_177230_c());
            }
        }
        return accessor.getStack();
    }

    @Nonnull
    @Optional.Method(modid="waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        TileEntity tileEntity = te;
        IBlockState state = world.func_180495_p(pos);
        if (state != null && state.func_177230_c() instanceof BlockTentDoor && state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            tileEntity = world.func_175625_s(pos.func_177979_c(1));
        }
        if (tileEntity instanceof TileEntityTentDoor) {
            TileEntityTentDoor tetd = (TileEntityTentDoor)tileEntity;
            tag.func_74782_a(KEY_STRUCTURE_DATA, (NBTBase)tetd.getTentData().serializeNBT());
        }
        return tag;
    }

    @Nonnull
    @Optional.Method(modid="waila")
    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block actualBlock = accessor.getBlock();
        if (actualBlock instanceof BlockTentFrame) {
            String header = actualBlock.func_149739_a() + ".name";
            tooltip.set(0, String.format(FormattingConfig.blockFormat, I18n.func_135052_a((String)header, (Object[])new Object[0])));
        }
        return tooltip;
    }

    @Nonnull
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlock() instanceof BlockTentFrame) {
            String progress = "waila.progress";
            int percentInt = (int)((float)accessor.getMetadata() / 7.0f * 100.0f);
            String percent = percentInt + "%";
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)progress, (Object[])new Object[]{percent}));
        }
        return tooltip;
    }
}

