/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.item;

import com.yurtmod.block.TileEntityTentDoor;
import com.yurtmod.dimension.TentDimension;
import com.yurtmod.init.NomadicTents;
import com.yurtmod.init.TentConfig;
import com.yurtmod.init.TentSaveData;
import com.yurtmod.structure.StructureBase;
import com.yurtmod.structure.util.StructureData;
import com.yurtmod.structure.util.StructureDepth;
import com.yurtmod.structure.util.StructureTent;
import com.yurtmod.structure.util.StructureWidth;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTent
extends Item {
    public static final int ERROR_TAG = Short.MIN_VALUE;
    public static final String TENT_DATA = "TentData";
    public static final String TAG_COPY_TOOL = "TentCopyTool";

    public ItemTent() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(NomadicTents.TAB);
        this.func_185043_a(new ResourceLocation("yurtmod", "tent"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(ItemTent.TENT_DATA)) {
                    StructureData data = new StructureData(stack.func_179543_a(ItemTent.TENT_DATA));
                    return data.getTent().getId() * StructureWidth.NUM_ENTRIES + data.getWidth().getId();
                }
                return 0.0f;
            }
        });
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (ItemTent.shouldFixOldStructureData(stack.func_190925_c(TENT_DATA))) {
            NBTTagCompound tag = ItemTent.makeStructureDataFromOld(world, stack.func_179543_a(TENT_DATA));
            stack.func_77978_p().func_74782_a(TENT_DATA, (NBTBase)tag);
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!(worldIn.field_72995_K || TentDimension.isTentDimension(worldIn) || TentConfig.GENERAL.isDimBlacklisted(worldIn))) {
            NBTTagCompound tag;
            BlockPos hitPos = pos;
            ItemStack stack = player.func_184586_b(hand);
            EnumFacing hitSide = side;
            if (worldIn.func_180495_p(pos) == null || stack == null || stack.func_190926_b()) {
                return EnumActionResult.FAIL;
            }
            if (ItemTent.shouldFixOldStructureData(stack.func_190925_c(TENT_DATA))) {
                tag = ItemTent.makeStructureDataFromOld(worldIn, stack.func_179543_a(TENT_DATA));
                stack.func_77978_p().func_74782_a(TENT_DATA, (NBTBase)tag);
            } else if (ItemTent.shouldMakeNewStructureData(stack.func_190925_c(TENT_DATA))) {
                tag = ItemTent.makeStructureData(worldIn, stack);
                stack.func_77978_p().func_74782_a(TENT_DATA, (NBTBase)tag);
            }
            if (!StructureBase.REPLACE_BLOCK_PRED.test(worldIn.func_180495_p(hitPos))) {
                hitPos = hitPos.func_177981_b(1);
            }
            if (!player.func_175151_a(hitPos, hitSide, stack)) {
                return EnumActionResult.FAIL;
            }
            EnumFacing playerFacing = player.func_174811_aO();
            StructureData data = new StructureData(stack.func_179543_a(TENT_DATA));
            StructureWidth width = data.getWidth().getOverworldSize();
            StructureBase struct = data.getStructure();
            if (struct.canSpawn(worldIn, hitPos, playerFacing, width) && struct.generateFrameStructure(worldIn, hitPos, playerFacing, width)) {
                TileEntity te = worldIn.func_175625_s(hitPos);
                if (te instanceof TileEntityTentDoor) {
                    StructureData.applyToTileEntity(player, stack, (TileEntityTentDoor)te);
                } else {
                    NomadicTents.LOGGER.error("Error! Failed to retrieve TileEntityTentDoor at " + hitPos);
                }
                stack.func_190918_g(1);
            }
        }
        return EnumActionResult.PASS;
    }

    public boolean func_82788_x() {
        return true;
    }

    public String func_77667_c(ItemStack stack) {
        StructureData data = new StructureData(stack);
        return "item." + data.getTent().func_176610_l() + "_" + data.getWidth().func_176610_l();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab != NomadicTents.TAB) {
            return;
        }
        StructureDepth depth = StructureDepth.NORMAL;
        for (StructureTent tent : StructureTent.values()) {
            for (StructureWidth size : StructureWidth.values()) {
                StructureData data = new StructureData().setAll(tent, size, depth);
                items.add((Object)data.getDropStack());
            }
        }
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return 0x7FFFFFFE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        StructureData data = new StructureData(stack);
        TextFormatting color = data.getWidth().getTooltipColor();
        tooltip.add(color + I18n.func_135052_a((String)"tooltip.extra_dimensional_space", (Object[])new Object[0]));
        if (data.getTent() == StructureTent.SHAMIANA) {
            String s = I18n.func_135052_a((String)data.getColor().func_176762_d(), (Object[])new Object[0]);
            tooltip.add(TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString() + s.substring(0, 1).toUpperCase() + s.substring(1, s.length()));
        }
        int depthCount = StructureDepth.countUpgrades(data);
        int maxCount = StructureDepth.maxUpgrades(data);
        if (depthCount > 0 || flagIn.func_194127_a() || GuiScreen.func_146272_n()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.depth_upgrades", (Object[])new Object[]{depthCount, maxCount}));
        }
    }

    public static boolean shouldMakeNewStructureData(NBTTagCompound tentData) {
        return tentData.func_74764_b("ID") && tentData.func_74763_f("ID") == -32768L;
    }

    public static NBTTagCompound makeStructureData(World world, ItemStack stack) {
        if (!world.field_72995_K) {
            StructureData data = new StructureData(stack);
            if (data.getID() == -32768L) {
                data.setID(ItemTent.getNextID(world));
            }
            return data.serializeNBT();
        }
        return new NBTTagCompound();
    }

    public static long getNextID(World world) {
        return world.field_72995_K ? -1L : TentSaveData.forWorld(world).getNextID();
    }

    public static boolean shouldFixOldStructureData(NBTTagCompound tentData) {
        return tentData.func_74764_b("StructureOffsetX");
    }

    public static NBTTagCompound makeStructureDataFromOld(World world, NBTTagCompound oldTag) {
        if (!world.field_72995_K) {
            NBTTagCompound dataTag = new NBTTagCompound();
            dataTag.func_74774_a("TentType", (byte)oldTag.func_74765_d("StructureTentType"));
            dataTag.func_74774_a("WidthCur", (byte)oldTag.func_74765_d("StructureWidthCurrent"));
            dataTag.func_74774_a("DepthCur", (byte)oldTag.func_74765_d("StructureDepthCurrent"));
            int offsetX = oldTag.func_74762_e("StructureOffsetX");
            int offsetZ = oldTag.func_74762_e("StructureOffsetZ");
            long ID = TileEntityTentDoor.getTentID(new BlockPos(offsetX * 32, 70, offsetZ * 32));
            dataTag.func_74772_a("ID", ID);
            TentSaveData worldData = TentSaveData.forWorld(world);
            while (worldData.getCurrentID() <= ID) {
                worldData.getNextID();
            }
            return dataTag;
        }
        return new NBTTagCompound();
    }
}

