/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.proxies;

import com.yurtmod.init.Content;
import com.yurtmod.init.NomadicTents;
import com.yurtmod.proxies.CommonProxy;
import com.yurtmod.structure.util.StructureData;
import com.yurtmod.structure.util.StructureTent;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ClientProxy
extends CommonProxy {
    @Override
    public void registerItemColors() {
        ItemColors colors = Minecraft.func_71410_x().getItemColors();
        if (colors != null) {
            colors.func_186730_a((stack, tintIndex) -> {
                StructureData data = new StructureData(stack);
                if (data.getTent() == StructureTent.SHAMIANA) {
                    return data.getColor() == EnumDyeColor.BLACK ? 0x303030 : data.getColor().func_193350_e();
                }
                return -1;
            }, new Item[]{Content.ITEM_TENT});
        }
    }

    @SubscribeEvent
    public static void onRenderEvent(ModelRegistryEvent event) {
        ClientProxy.register(Content.ITEM_TENT, new int[0]);
        ClientProxy.register(Content.ITEM_MALLET, new int[0]);
        ClientProxy.register(Content.ITEM_SUPER_MALLET, new int[0]);
        ClientProxy.register(Content.ITEM_TENT_CANVAS, new int[0]);
        ClientProxy.registerAll(Content.ITEM_YURT_WALL, Content.ITEM_TEPEE_WALL, Content.ITEM_BEDOUIN_WALL, Content.ITEM_INDLU_WALL, Content.ITEM_SHAMIANA_WALL);
        ClientProxy.registerAll(Content.ITEM_UPGRADE_GOLD, Content.ITEM_UPGRADE_OBSDIDIAN, Content.ITEM_UPGRADE_DIAMOND);
        ClientProxy.registerAll(Content.ITEM_DEPTH_UPGRADE_STONE, Content.ITEM_DEPTH_UPGRADE_IRON, Content.ITEM_DEPTH_UPGRADE_GOLD, Content.ITEM_DEPTH_UPGRADE_OBSIDIAN, Content.ITEM_DEPTH_UPGRADE_DIAMOND);
        ClientProxy.register(Content.TENT_BARRIER, new int[0]);
        ClientProxy.register(Content.SUPER_DIRT, new int[0]);
        ClientProxy.register(Content.YURT_WALL_OUTER, new int[0]);
        ClientProxy.register(Content.YURT_WALL_INNER, new int[0]);
        ClientProxy.register(Content.YURT_ROOF, new int[0]);
        ClientProxy.register(Content.BEDOUIN_WALL, new int[0]);
        ClientProxy.register(Content.BEDOUIN_ROOF, new int[0]);
        ClientProxy.register(Content.INDLU_WALL_OUTER, new int[0]);
        ClientProxy.register(Content.INDLU_WALL_INNER, new int[0]);
        ClientProxy.registerAll(Content.TEPEE_WALL_BLANK, Content.TEPEE_WALL_BLACK, Content.TEPEE_WALL_RED, Content.TEPEE_WALL_YELLOW, Content.TEPEE_WALL_ORANGE, Content.TEPEE_WALL_WHITE, Content.TEPEE_WALL_HOPE, Content.TEPEE_WALL_SUN, Content.TEPEE_WALL_CREEPER, Content.TEPEE_WALL_UNIVERSE, Content.TEPEE_WALL_EAGLE, Content.TEPEE_WALL_TRIFORCE, Content.TEPEE_WALL_DREAMCATCHER, Content.TEPEE_WALL_RAIN, Content.TEPEE_WALL_MAGIC);
        ClientProxy.registerAll(Content.SHAMIANA_WALL_BLACK, Content.SHAMIANA_WALL_BLUE, Content.SHAMIANA_WALL_BROWN, Content.SHAMIANA_WALL_CYAN, Content.SHAMIANA_WALL_GRAY, Content.SHAMIANA_WALL_GREEN, Content.SHAMIANA_WALL_LIGHT_BLUE, Content.SHAMIANA_WALL_LIME, Content.SHAMIANA_WALL_MAGENTA, Content.SHAMIANA_WALL_ORANGE, Content.SHAMIANA_WALL_PINK, Content.SHAMIANA_WALL_PURPLE, Content.SHAMIANA_WALL_RED, Content.SHAMIANA_WALL_LIGHT_GRAY, Content.SHAMIANA_WALL_WHITE, Content.SHAMIANA_WALL_YELLOW);
        ClientProxy.registerAll(Content.YURT_DOOR_SML, Content.YURT_DOOR_HGM, Content.TEPEE_DOOR_SML, Content.TEPEE_DOOR_HGM, Content.BEDOUIN_DOOR_SML, Content.BEDOUIN_DOOR_HGM, Content.INDLU_DOOR_SML, Content.INDLU_DOOR_HGM, Content.SHAMIANA_DOOR_SML, Content.SHAMIANA_DOOR_HGM);
        ClientProxy.registerAll(Content.COS_BEDOUIN_ROOF, Content.COS_BEDOUIN_WALL, Content.COS_INDLU_WALL_OUTER, Content.COS_INDLU_WALL_INNER, Content.COS_YURT_ROOF, Content.COS_YURT_WALL_OUTER, Content.COS_YURT_WALL_INNER, Content.COS_TEPEE_WALL_BLANK, Content.COS_TEPEE_WALL_BLACK, Content.COS_TEPEE_WALL_RED, Content.COS_TEPEE_WALL_YELLOW, Content.COS_TEPEE_WALL_ORANGE, Content.COS_TEPEE_WALL_WHITE, Content.COS_TEPEE_WALL_HOPE, Content.COS_TEPEE_WALL_SUN, Content.COS_TEPEE_WALL_CREEPER, Content.COS_TEPEE_WALL_UNIVERSE, Content.COS_TEPEE_WALL_EAGLE, Content.COS_TEPEE_WALL_TRIFORCE, Content.COS_TEPEE_WALL_DREAMCATCHER, Content.COS_TEPEE_WALL_RAIN, Content.COS_TEPEE_WALL_MAGIC, Content.COS_SHAMIANA_WALL_BLACK, Content.COS_SHAMIANA_WALL_BLUE, Content.COS_SHAMIANA_WALL_BROWN, Content.COS_SHAMIANA_WALL_CYAN, Content.COS_SHAMIANA_WALL_GRAY, Content.COS_SHAMIANA_WALL_GREEN, Content.COS_SHAMIANA_WALL_LIGHT_BLUE, Content.COS_SHAMIANA_WALL_LIME, Content.COS_SHAMIANA_WALL_MAGENTA, Content.COS_SHAMIANA_WALL_ORANGE, Content.COS_SHAMIANA_WALL_PINK, Content.COS_SHAMIANA_WALL_PURPLE, Content.COS_SHAMIANA_WALL_RED, Content.COS_SHAMIANA_WALL_LIGHT_GRAY, Content.COS_SHAMIANA_WALL_WHITE, Content.COS_SHAMIANA_WALL_YELLOW);
        int[] progress = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        ClientProxy.register(Content.FRAME_YURT_WALL, progress);
        ClientProxy.register(Content.FRAME_YURT_ROOF, progress);
        ClientProxy.register(Content.FRAME_TEPEE_WALL, progress);
        ClientProxy.register(Content.FRAME_BEDOUIN_WALL, progress);
        ClientProxy.register(Content.FRAME_BEDOUIN_ROOF, progress);
        ClientProxy.register(Content.FRAME_INDLU_WALL, progress);
        ClientProxy.register(Content.FRAME_SHAMIANA_WALL, progress);
    }

    private static void register(Item i, String name, int ... meta) {
        if (meta.length < 1) {
            meta = new int[]{0};
        }
        for (int m : meta) {
            ModelLoader.setCustomModelResourceLocation((Item)i, (int)m, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    private static void register(Item i, int ... meta) {
        ClientProxy.register(i, i.getRegistryName().toString(), meta);
    }

    private static void register(Block b, int ... meta) {
        Item i = Item.func_150898_a((Block)b);
        if (i != null) {
            ClientProxy.register(i, i.getRegistryName().toString().replace("cos_", ""), meta);
        } else {
            NomadicTents.LOGGER.error("Tried to register render for a null ItemBlock. Skipping.");
        }
    }

    private static void registerAll(Item ... items) {
        for (Item i : items) {
            ClientProxy.register(i, new int[0]);
        }
    }

    private static void registerAll(Block ... blocks) {
        for (Block b : blocks) {
            ClientProxy.register(b, new int[0]);
        }
    }
}

