/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.structure;

import com.yurtmod.block.BlockCosmetic;
import com.yurtmod.block.BlockTentDoor;
import com.yurtmod.block.BlockUnbreakable;
import com.yurtmod.block.Categories;
import com.yurtmod.block.TileEntityTentDoor;
import com.yurtmod.dimension.TentDimension;
import com.yurtmod.event.TentEvent;
import com.yurtmod.init.Content;
import com.yurtmod.init.NomadicTents;
import com.yurtmod.init.TentConfig;
import com.yurtmod.structure.util.Blueprint;
import com.yurtmod.structure.util.Blueprints;
import com.yurtmod.structure.util.StructureData;
import com.yurtmod.structure.util.StructureDepth;
import com.yurtmod.structure.util.StructureTent;
import com.yurtmod.structure.util.StructureWidth;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class StructureBase {
    protected StructureData data;
    protected Predicate<IBlockState> TENT_PRED;
    public static final Predicate<IBlockState> REPLACE_BLOCK_PRED = new Predicate<IBlockState>(){

        @Override
        public boolean test(IBlockState b) {
            Material m = b.func_185904_a();
            return m.func_76222_j() || m == Material.field_151579_a || m == Material.field_151585_k || m == Material.field_151587_i || m == Material.field_151586_h || m == Material.field_151584_j || m == Material.field_151597_y || m == Material.field_151582_l || b.func_177230_c() instanceof BlockSnow;
        }
    };

    public StructureBase withData(StructureData structureData) {
        this.data = structureData;
        this.TENT_PRED = b -> this.data.getTent().getInterface().isAssignableFrom(b.func_177230_c().getClass());
        return this;
    }

    public StructureData getData() {
        return this.data;
    }

    public final TentEvent.TentResult generateInTentDimension(int prevDimension, World worldIn, BlockPos doorPos, double prevX, double prevY, double prevZ, float prevFacing, EnumDyeColor color) {
        boolean recolorTent;
        TentEvent.TentResult result = TentEvent.TentResult.NONE;
        BlockPos corner = doorPos.func_177982_a(0, 0, -1 * this.data.getWidth().getDoorZ());
        boolean structureExists = worldIn.func_180495_p(doorPos).func_177230_c() instanceof BlockTentDoor;
        StructureData prevData = structureExists ? StructureBase.getDoorAt(worldIn, doorPos).getTentData() : this.data.copy();
        boolean rebuildTent = !structureExists || this.data.getWidth() != prevData.getWidth();
        boolean buildPlatform = !structureExists || rebuildTent;
        boolean upgradePlatform = structureExists && !buildPlatform && this.data.getDepth() != prevData.getDepth();
        boolean bl = recolorTent = structureExists && prevData.getColor() != color;
        if (!structureExists) {
            result = TentEvent.TentResult.BUILT_FIRST;
        } else if (rebuildTent) {
            this.data.getStructure().remove(worldIn, doorPos, TentDimension.STRUCTURE_DIR, prevData.getWidth());
            result = TentEvent.TentResult.UPGRADED;
        }
        if (recolorTent) {
            result = TentEvent.TentResult.UPGRADED;
        }
        if (!structureExists || rebuildTent || recolorTent) {
            this.generate(worldIn, doorPos, TentDimension.STRUCTURE_DIR, this.data.getWidth(), this.data.getDoorBlock(), this.data.getWallBlock(TentDimension.DIMENSION_ID), this.data.getRoofBlock(TentDimension.DIMENSION_ID));
        }
        if (upgradePlatform) {
            StructureBase.upgradePlatformDepth(worldIn, corner.func_177979_c(1), this.data.getWidth(), prevData.getDepth(), this.data.getDepth());
            result = TentEvent.TentResult.UPGRADED;
        } else if (buildPlatform) {
            StructureBase.generatePlatform(worldIn, corner.func_177979_c(1), this.data.getWidth(), this.data.getDepth());
        }
        StructureBase.updateDoorInfo(worldIn, doorPos, this.data, prevX, prevY, prevZ, prevFacing, prevDimension);
        return result;
    }

    public static final TileEntityTentDoor getDoorAt(World worldIn, BlockPos doorPos) {
        TileEntity te = worldIn.func_175625_s(doorPos);
        if (te instanceof TileEntityTentDoor) {
            return (TileEntityTentDoor)te;
        }
        NomadicTents.LOGGER.error("Error! Failed to retrieve TileEntityTentDoor at " + doorPos.toString());
        return null;
    }

    public static final boolean updateDoorInfo(World worldIn, BlockPos doorPos, StructureData data, double prevX, double prevY, double prevZ, float prevFacing, int prevDimension) {
        TileEntityTentDoor door = StructureBase.getDoorAt(worldIn, doorPos);
        if (door != null) {
            data.setID(TileEntityTentDoor.getTentID(doorPos));
            door.setTentData(data);
            door.setOverworldXYZ(prevX, prevY, prevZ);
            door.setPrevFacing(prevFacing);
            door.setPrevDimension(prevDimension);
            return true;
        }
        return false;
    }

    private static boolean generatePlatform(World worldIn, BlockPos corner, StructureWidth size, StructureDepth depth) {
        int sqWidth = size.getSquareWidth();
        Block bottom = Content.SUPER_DIRT;
        Block floor = TentConfig.GENERAL.getFloorBlock();
        for (int i = 0; i < sqWidth; ++i) {
            for (int j = 0; j < sqWidth; ++j) {
                BlockPos at = corner.func_177982_a(i, 0, j);
                Block blockUp = worldIn.func_180495_p(at.func_177981_b(1)).func_177230_c();
                boolean placeFloor = false;
                Block filler = null;
                if (blockUp instanceof Categories.ITentBlockBase) {
                    placeFloor = true;
                    filler = bottom;
                } else {
                    int maxExpectedHeight = 24;
                    for (int f = 1; f < maxExpectedHeight; ++f) {
                        if (!(worldIn.func_180495_p(at.func_177981_b(f)).func_177230_c() instanceof Categories.ITentBlockBase)) continue;
                        placeFloor = true;
                        filler = floor;
                        break;
                    }
                }
                if (!placeFloor || filler == null) continue;
                int l = depth.getLayers();
                for (int k = 0; k < l; ++k) {
                    Block b = worldIn.func_180495_p(at.func_177979_c(k)).func_177230_c();
                    if (b != Blocks.field_150350_a && !(b instanceof BlockUnbreakable)) continue;
                    worldIn.func_175656_a(at.func_177979_c(k), filler.func_176223_P());
                }
                worldIn.func_180501_a(at.func_177979_c(depth.getLayers()), bottom.func_176223_P(), 2);
            }
        }
        return true;
    }

    private static boolean upgradePlatformDepth(World worldIn, BlockPos corner, StructureWidth size, StructureDepth depthPrev, StructureDepth depthCur) {
        int sqWidth = size.getSquareWidth();
        int numLayers = depthCur.getLayers() - depthPrev.getLayers();
        Block bottom = Content.SUPER_DIRT;
        Block floor = TentConfig.GENERAL.getFloorBlock();
        for (int i = 0; i < sqWidth; ++i) {
            for (int j = 0; j < sqWidth; ++j) {
                BlockPos bottomPos = corner.func_177982_a(i, -depthPrev.getLayers(), j);
                if (worldIn.func_180495_p(bottomPos).func_177230_c() != bottom) continue;
                for (int k = 0; k < numLayers; ++k) {
                    BlockPos at = bottomPos.func_177979_c(k);
                    Block filler = worldIn.func_180495_p(at.func_177981_b(1)).func_177230_c() instanceof BlockUnbreakable && !BlockCosmetic.isCosmetic(worldIn.func_180495_p(at.func_177981_b(1)).func_177230_c()) ? bottom : floor;
                    worldIn.func_175656_a(at, filler.func_176223_P());
                }
                worldIn.func_175656_a(bottomPos.func_177979_c(numLayers), bottom.func_176223_P());
            }
        }
        return false;
    }

    private static boolean removePlatform(World worldIn, BlockPos corner, StructureWidth size, StructureDepth depth) {
        int sqWidth = size.getSquareWidth();
        int layers = depth.getLayers() + 1;
        Block bottom = Content.SUPER_DIRT;
        Block floor = TentConfig.GENERAL.getFloorBlock();
        for (int i = 0; i < sqWidth; ++i) {
            for (int j = 0; j < sqWidth; ++j) {
                for (int k = 0; k < layers; ++k) {
                    BlockPos at = corner.func_177982_a(i, -k, j);
                    Block blockAt = worldIn.func_180495_p(at).func_177230_c();
                    if (blockAt != bottom && blockAt != floor && !(blockAt instanceof BlockUnbreakable)) continue;
                    worldIn.func_180501_a(at, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
        return true;
    }

    public static final BlockPos getPosFromDoor(BlockPos doorPos, BlockPos offset, EnumFacing forward) {
        return StructureBase.getPosFromDoor(doorPos, offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p(), forward);
    }

    public static final BlockPos getPosFromDoor(BlockPos doorPos, int disForward, int disUp, int disRight, EnumFacing forward) {
        EnumFacing right = forward.func_176746_e();
        return doorPos.func_177967_a(forward, disForward).func_177967_a(right, disRight).func_177981_b(disUp);
    }

    public static void buildDoor(World world, BlockPos doorBase, IBlockState door, EnumFacing dir) {
        if (door.func_177230_c() instanceof BlockTentDoor) {
            EnumFacing.Axis axis = dir.func_176740_k() == EnumFacing.Axis.Z ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
            IBlockState doorL = door.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a(BlockTentDoor.AXIS, (Comparable)axis);
            IBlockState doorU = door.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a(BlockTentDoor.AXIS, (Comparable)axis);
            world.func_180501_a(doorBase, doorL, 3);
            world.func_180501_a(doorBase.func_177981_b(1), doorU, 3);
        }
    }

    public void buildLayer(World worldIn, BlockPos door, EnumFacing dirForward, IBlockState state, BlockPos[] coordinates) {
        for (BlockPos coord : coordinates) {
            BlockPos pos = StructureBase.getPosFromDoor(door, coord, dirForward);
            worldIn.func_180501_a(pos, state, 3);
        }
    }

    public boolean generateFrameStructure(World worldIn, BlockPos doorBase, EnumFacing dirForward, StructureWidth size) {
        return this.generate(worldIn, doorBase, dirForward, size, this.data.getDoorBlock(), this.data.getTent().getFrameBlock(false), this.data.getTent().getFrameBlock(true));
    }

    public boolean remove(World worldIn, BlockPos doorPos, EnumFacing dirForward, StructureWidth size) {
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        boolean flag = this.generate(worldIn, doorPos, dirForward, size, air, air, air);
        if (worldIn.func_175625_s(doorPos) instanceof TileEntityTentDoor) {
            worldIn.func_175713_t(doorPos);
        }
        if (worldIn.func_175625_s(doorPos.func_177981_b(1)) instanceof TileEntityTentDoor) {
            worldIn.func_175713_t(doorPos.func_177981_b(1));
        }
        return flag;
    }

    public static final boolean validateArray(World worldIn, BlockPos doorPos, BlockPos[] posArray, EnumFacing facing, Predicate<IBlockState> predicate) {
        for (BlockPos p : posArray) {
            BlockPos check = StructureBase.getPosFromDoor(doorPos, p, facing);
            if (StructureBase.validateBlock(worldIn, check, predicate)) continue;
            return false;
        }
        return true;
    }

    public static final boolean validateBlock(World worldIn, BlockPos pos, Predicate<IBlockState> p) {
        return p.test(worldIn.func_180495_p(pos));
    }

    public EnumFacing getValidFacing(World worldIn, BlockPos doorBase, StructureWidth size) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            boolean isValid = this.isValidForFacing(worldIn, doorBase, size, dir);
            if (!isValid) continue;
            return dir;
        }
        return null;
    }

    public boolean canSpawn(World worldIn, BlockPos doorBase, EnumFacing dirForward, StructureWidth size) {
        Blueprint bp = this.getBlueprints(size);
        if (bp.hasWallCoords() && !StructureBase.validateArray(worldIn, doorBase, bp.getWallCoords(), dirForward, REPLACE_BLOCK_PRED)) {
            return false;
        }
        return !bp.hasRoofCoords() || StructureBase.validateArray(worldIn, doorBase, bp.getRoofCoords(), dirForward, REPLACE_BLOCK_PRED);
    }

    public boolean isValidForFacing(World worldIn, BlockPos doorBase, StructureWidth size, EnumFacing facing) {
        Blueprint bp = this.getBlueprints(size);
        if (bp.hasWallCoords() && !StructureBase.validateArray(worldIn, doorBase, bp.getWallCoords(), facing, this.TENT_PRED)) {
            return false;
        }
        return !bp.hasRoofCoords() || StructureBase.validateArray(worldIn, doorBase, bp.getRoofCoords(), facing, this.TENT_PRED);
    }

    public Blueprint getBlueprints(StructureWidth size) {
        return Blueprints.get(this.getTentType(), size);
    }

    public abstract boolean generate(World var1, BlockPos var2, EnumFacing var3, StructureWidth var4, IBlockState var5, IBlockState var6, IBlockState var7);

    public abstract StructureTent getTentType();
}

