/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.structure.util;

import com.yurtmod.structure.StructureBedouin;
import com.yurtmod.structure.StructureIndlu;
import com.yurtmod.structure.StructureShamiana;
import com.yurtmod.structure.StructureTepee;
import com.yurtmod.structure.StructureYurt;
import com.yurtmod.structure.util.Blueprint;
import com.yurtmod.structure.util.StructureTent;
import com.yurtmod.structure.util.StructureWidth;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class Blueprints {
    private static final Map<TentKey, Blueprint> map = new HashMap<TentKey, Blueprint>();

    private Blueprints() {
    }

    private static boolean put(StructureTent tent, StructureWidth width, Blueprint bp) {
        TentKey key = new TentKey(tent, width);
        map.put(key, bp);
        return true;
    }

    @Nullable
    public static Blueprint get(StructureTent tent, StructureWidth width) {
        TentKey key = new TentKey(tent, width);
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    static {
        for (StructureWidth width : StructureWidth.values()) {
            Blueprints.put(StructureTent.YURT, width, StructureYurt.makeBlueprints(width));
            Blueprints.put(StructureTent.TEPEE, width, StructureTepee.makeBlueprints(width));
            Blueprints.put(StructureTent.BEDOUIN, width, StructureBedouin.makeBlueprints(width));
            Blueprints.put(StructureTent.INDLU, width, StructureIndlu.makeBlueprints(width));
            Blueprints.put(StructureTent.SHAMIANA, width, StructureShamiana.makeBlueprints(width));
        }
    }

    private static final class TentKey {
        private final StructureTent tent;
        private final StructureWidth width;

        private TentKey(StructureTent tentIn, StructureWidth widthIn) {
            this.tent = tentIn;
            this.width = widthIn;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.tent == null ? 0 : this.tent.hashCode());
            result = 31 * result + (this.width == null ? 0 : this.width.hashCode());
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof TentKey && other.getClass() == this.getClass()) {
                TentKey tentKeyOther = (TentKey)other;
                return tentKeyOther.tent == this.tent && tentKeyOther.width == this.width;
            }
            return false;
        }
    }
}

