/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.structure.util;

import com.yurtmod.block.BlockTentDoorHGM;
import com.yurtmod.block.BlockTentDoorSML;
import com.yurtmod.block.TileEntityTentDoor;
import com.yurtmod.init.Content;
import com.yurtmod.init.NomadicTents;
import com.yurtmod.item.ItemTent;
import com.yurtmod.structure.StructureBase;
import com.yurtmod.structure.util.StructureDepth;
import com.yurtmod.structure.util.StructureTent;
import com.yurtmod.structure.util.StructureWidth;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class StructureData
implements INBTSerializable<NBTTagCompound> {
    public static final String KEY_TENT_CUR = "TentType";
    public static final String KEY_WIDTH_CUR = "WidthCur";
    public static final String KEY_DEPTH_CUR = "DepthCur";
    public static final String KEY_ID = "ID";
    public static final String KEY_COLOR = "TentColor";
    private StructureTent tent = StructureTent.getById((byte)0);
    private StructureWidth width = StructureWidth.getById((byte)0);
    private StructureDepth depth = StructureDepth.getById((byte)0);
    private EnumDyeColor color = EnumDyeColor.WHITE;
    private long locationID = -32768L;

    public StructureData() {
    }

    public StructureData(NBTTagCompound nbt) {
        this();
        if (nbt != null) {
            this.deserializeNBT(nbt);
        }
    }

    public StructureData(ItemStack tentStack) {
        this(tentStack != null && !tentStack.func_190926_b() && tentStack.func_77973_b() instanceof ItemTent ? tentStack.func_190925_c("TentData") : null);
    }

    public StructureData setAll(StructureTent tentIn, StructureWidth widthIn, StructureDepth depthIn) {
        this.setCurrent(tentIn, widthIn, depthIn);
        return this;
    }

    public StructureData setCurrent(StructureTent tentCur, StructureWidth widthCur, StructureDepth depthCur) {
        this.tent = tentCur;
        this.width = widthCur;
        this.depth = depthCur;
        return this;
    }

    public StructureData copy() {
        return new StructureData().setCurrent(this.tent, this.width, this.depth).setID(this.locationID).setColor(this.color);
    }

    public boolean isValid() {
        return this.locationID != -32768L;
    }

    public StructureData setTent(StructureTent tentIn) {
        this.tent = tentIn;
        return this;
    }

    public StructureData setWidth(StructureWidth widthIn) {
        this.width = widthIn;
        return this;
    }

    public StructureData setDepth(StructureDepth depthIn) {
        this.depth = depthIn;
        return this;
    }

    public StructureData setID(long id) {
        this.locationID = id;
        return this;
    }

    public StructureData setColor(EnumDyeColor colorIn) {
        this.color = colorIn;
        return this;
    }

    public StructureTent getTent() {
        return this.tent;
    }

    public StructureWidth getWidth() {
        return this.width;
    }

    public StructureDepth getDepth() {
        return this.depth;
    }

    public long getID() {
        return this.locationID;
    }

    public EnumDyeColor getColor() {
        return this.color;
    }

    public IBlockState getDoorBlock() {
        boolean xl = this.getWidth().isXL();
        Block block = this.getDoorBlockRaw(xl);
        PropertyEnum<StructureWidth> sizeEnum = xl ? BlockTentDoorHGM.SIZE : BlockTentDoorSML.SIZE;
        return block.func_176223_P().func_177226_a(sizeEnum, (Comparable)((Object)this.getWidth()));
    }

    private Block getDoorBlockRaw(boolean isXL) {
        switch (this.getTent()) {
            case YURT: {
                return isXL ? Content.YURT_DOOR_HGM : Content.YURT_DOOR_SML;
            }
            case TEPEE: {
                return isXL ? Content.TEPEE_DOOR_HGM : Content.TEPEE_DOOR_SML;
            }
            case BEDOUIN: {
                return isXL ? Content.BEDOUIN_DOOR_HGM : Content.BEDOUIN_DOOR_SML;
            }
            case INDLU: {
                return isXL ? Content.INDLU_DOOR_HGM : Content.INDLU_DOOR_SML;
            }
            case SHAMIANA: {
                return isXL ? Content.SHAMIANA_DOOR_HGM : Content.SHAMIANA_DOOR_SML;
            }
        }
        return Content.YURT_DOOR_SML;
    }

    public IBlockState getRoofBlock(int dimID) {
        return this.tent.getRoofBlock(dimID);
    }

    public IBlockState getFrameBlock(boolean isRoof) {
        return this.tent.getFrameBlock(isRoof);
    }

    public IBlockState getWallBlock(int dimID) {
        return this.tent.getWallBlock(dimID);
    }

    public static boolean shouldUpdate(StructureData oldData, StructureData newData) {
        return oldData.getWidth() != newData.getWidth() || oldData.getDepth() != newData.getDepth() || oldData.getColor() != newData.getColor();
    }

    public static void applyToTileEntity(EntityPlayer player, ItemStack stack, TileEntityTentDoor te) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("TentData")) {
            NomadicTents.LOGGER.error("ItemStack did not have any NBT information to pass to the TileEntity!");
            te.func_145831_w().func_175713_t(te.func_174877_v());
            return;
        }
        te.setTentData(new StructureData(stack));
        te.setOverworldXYZ(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        te.setPrevFacing(player.field_70177_z);
        te.setOwner(EntityPlayer.func_175147_b((String)player.func_70005_c_()));
    }

    public ItemStack getDropStack() {
        return this.writeTo(new ItemStack(Content.ITEM_TENT, 1));
    }

    public ItemStack writeTo(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a("TentData", (NBTBase)this.serializeNBT());
        return stack;
    }

    public StructureBase getStructure() {
        return this.tent.makeStructure(this.copy());
    }

    public static StructureData getRandom(Random rand) {
        StructureTent t = StructureTent.values()[rand.nextInt(StructureTent.values().length)];
        StructureWidth w = StructureWidth.values()[rand.nextInt(StructureWidth.values().length)];
        StructureDepth d = StructureDepth.values()[rand.nextInt(StructureDepth.values().length)];
        return new StructureData().setAll(t, w, d);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.tent != null) {
            nbt.func_74774_a(KEY_TENT_CUR, this.tent.getId());
            nbt.func_74774_a(KEY_WIDTH_CUR, this.width.getId());
            nbt.func_74774_a(KEY_DEPTH_CUR, this.depth.getId());
            nbt.func_74772_a(KEY_ID, this.locationID);
            nbt.func_74768_a(KEY_COLOR, this.color.func_176765_a());
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.tent = StructureTent.getById(nbt.func_74771_c(KEY_TENT_CUR));
        this.width = StructureWidth.getById(nbt.func_74771_c(KEY_WIDTH_CUR));
        this.depth = StructureDepth.getById(nbt.func_74771_c(KEY_DEPTH_CUR));
        this.locationID = nbt.func_74763_f(KEY_ID);
        this.color = nbt.func_74764_b(KEY_COLOR) ? EnumDyeColor.func_176764_b((int)nbt.func_74762_e(KEY_COLOR)) : EnumDyeColor.WHITE;
    }

    public String toString() {
        return "\nStructureData: [TENT = " + this.tent.func_176610_l() + "; WIDTH = " + this.width.func_176610_l() + "; DEPTH = " + this.depth.func_176610_l() + ";\nPREV_WIDTH = ; ID = " + this.locationID + "; COLOR = " + (this.color != null ? this.color.func_176610_l() : "null") + "]";
    }
}

