/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.structure.util;

import com.yurtmod.structure.util.StructureData;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;

public enum StructureDepth implements IStringSerializable
{
    NORMAL(1),
    DOUBLE(2),
    TRIPLE(3),
    QUADRUPLE(4),
    QUINTUPLE(5),
    SEXTUPLE(6);

    private static final int NUM_ENTRIES;
    private final int layers;

    private StructureDepth(int i) {
        this.layers = i;
    }

    public int getLayers() {
        return this.layers;
    }

    public byte getId() {
        return (byte)this.ordinal();
    }

    public static StructureDepth getById(byte id) {
        return StructureDepth.values()[MathHelper.func_76125_a((int)id, (int)0, (int)(NUM_ENTRIES - 1))];
    }

    public static int maxUpgrades(StructureData data) {
        return data.getWidth().getMaxDepth() - 1;
    }

    public static int countUpgrades(StructureData data) {
        return data.getDepth().ordinal();
    }

    public static StructureDepth getByName(String name) {
        for (StructureDepth d : StructureDepth.values()) {
            if (!name.equals(d.func_176610_l())) continue;
            return d;
        }
        return NORMAL;
    }

    public String func_176610_l() {
        return this.toString().toLowerCase();
    }

    static {
        NUM_ENTRIES = StructureDepth.values().length;
    }
}

