/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.structure.util;

import com.yurtmod.block.BlockYurtRoof;
import com.yurtmod.block.Categories;
import com.yurtmod.dimension.TentDimension;
import com.yurtmod.init.Content;
import com.yurtmod.init.TentConfig;
import com.yurtmod.structure.StructureBase;
import com.yurtmod.structure.StructureBedouin;
import com.yurtmod.structure.StructureIndlu;
import com.yurtmod.structure.StructureShamiana;
import com.yurtmod.structure.StructureTepee;
import com.yurtmod.structure.StructureYurt;
import com.yurtmod.structure.util.StructureData;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.IStringSerializable;

public enum StructureTent implements IStringSerializable
{
    YURT(new StructureYurt()){

        @Override
        public boolean isEnabled() {
            return TentConfig.TENTS.ALLOW_YURT;
        }

        @Override
        public boolean areFeaturesEnabled() {
            return TentConfig.TENTS.ENABLE_YURT_FEATURES;
        }

        @Override
        public int getMaxSize() {
            return TentConfig.TENTS.TIERS_YURT;
        }

        @Override
        public Class<? extends Categories.ITentBlockBase> getInterface() {
            return Categories.IYurtBlock.class;
        }

        @Override
        public IBlockState getRoofBlock(int dimID) {
            return Content.YURT_ROOF.func_176223_P().func_177226_a((IProperty)BlockYurtRoof.OUTSIDE, (Comparable)Boolean.valueOf(!TentDimension.isTentDimension(dimID)));
        }

        @Override
        public IBlockState getFrameBlock(boolean isRoof) {
            return isRoof ? Content.FRAME_YURT_ROOF.func_176223_P() : Content.FRAME_YURT_WALL.func_176223_P();
        }

        @Override
        public IBlockState getWallBlock(int dimID) {
            return TentDimension.isTentDimension(dimID) ? Content.YURT_WALL_INNER.func_176223_P() : Content.YURT_WALL_OUTER.func_176223_P();
        }
    }
    ,
    TEPEE(new StructureTepee()){

        @Override
        public boolean isEnabled() {
            return TentConfig.TENTS.ALLOW_TEPEE;
        }

        @Override
        public boolean areFeaturesEnabled() {
            return TentConfig.TENTS.ENABLE_TEPEE_FEATURES;
        }

        @Override
        public int getMaxSize() {
            return TentConfig.TENTS.TIERS_TEPEE;
        }

        @Override
        public Class<? extends Categories.ITentBlockBase> getInterface() {
            return Categories.ITepeeBlock.class;
        }

        @Override
        public IBlockState getWallBlock(int dimID) {
            return Content.TEPEE_WALL_BLANK.func_176223_P();
        }

        @Override
        public IBlockState getRoofBlock(int dimID) {
            return Content.TEPEE_WALL_BLANK.func_176223_P();
        }

        @Override
        public IBlockState getFrameBlock(boolean isRoof) {
            return Content.FRAME_TEPEE_WALL.func_176223_P();
        }
    }
    ,
    BEDOUIN(new StructureBedouin()){

        @Override
        public boolean isEnabled() {
            return TentConfig.TENTS.ALLOW_BEDOUIN;
        }

        @Override
        public boolean areFeaturesEnabled() {
            return TentConfig.TENTS.ENABLE_BEDOUIN_FEATURES;
        }

        @Override
        public int getMaxSize() {
            return TentConfig.TENTS.TIERS_BEDOUIN;
        }

        @Override
        public Class<? extends Categories.ITentBlockBase> getInterface() {
            return Categories.IBedouinBlock.class;
        }

        @Override
        public IBlockState getWallBlock(int dimID) {
            return Content.BEDOUIN_WALL.func_176223_P();
        }

        @Override
        public IBlockState getRoofBlock(int dimID) {
            return Content.BEDOUIN_ROOF.func_176223_P();
        }

        @Override
        public IBlockState getFrameBlock(boolean isRoof) {
            return isRoof ? Content.FRAME_BEDOUIN_ROOF.func_176223_P() : Content.FRAME_BEDOUIN_WALL.func_176223_P();
        }
    }
    ,
    INDLU(new StructureIndlu()){

        @Override
        public boolean isEnabled() {
            return TentConfig.TENTS.ALLOW_INDLU;
        }

        @Override
        public boolean areFeaturesEnabled() {
            return TentConfig.TENTS.ENABLE_INDLU_FEATURES;
        }

        @Override
        public int getMaxSize() {
            return TentConfig.TENTS.TIERS_INDLU;
        }

        @Override
        public Class<? extends Categories.ITentBlockBase> getInterface() {
            return Categories.IIndluBlock.class;
        }

        @Override
        public IBlockState getRoofBlock(int dimID) {
            return Content.INDLU_WALL_OUTER.func_176223_P();
        }

        @Override
        public IBlockState getFrameBlock(boolean isRoof) {
            return Content.FRAME_INDLU_WALL.func_176223_P();
        }

        @Override
        public IBlockState getWallBlock(int dimID) {
            return TentDimension.isTentDimension(dimID) ? Content.INDLU_WALL_INNER.func_176223_P() : Content.INDLU_WALL_OUTER.func_176223_P();
        }
    }
    ,
    SHAMIANA(new StructureShamiana()){

        @Override
        public boolean isEnabled() {
            return TentConfig.TENTS.ALLOW_SHAMIANA;
        }

        @Override
        public boolean areFeaturesEnabled() {
            return TentConfig.TENTS.ENABLE_SHAMIANA_FEATURES;
        }

        @Override
        public int getMaxSize() {
            return TentConfig.TENTS.TIERS_SHAMIANA;
        }

        @Override
        public Class<? extends Categories.ITentBlockBase> getInterface() {
            return Categories.IShamianaBlock.class;
        }

        @Override
        public IBlockState getRoofBlock(int dimID) {
            return Content.SHAMIANA_WALL_WHITE.func_176223_P();
        }

        @Override
        public IBlockState getWallBlock(int dimID) {
            return Content.SHAMIANA_WALL_WHITE.func_176223_P();
        }

        @Override
        public IBlockState getFrameBlock(boolean isRoof) {
            return Content.FRAME_SHAMIANA_WALL.func_176223_P();
        }
    };

    private final StructureBase structure;

    private StructureTent(StructureBase struct) {
        this.structure = struct;
    }

    public StructureBase makeStructure(StructureData data) {
        return this.structure.withData(data);
    }

    public byte getId() {
        return (byte)this.ordinal();
    }

    public static StructureTent getById(byte id) {
        return StructureTent.values()[id];
    }

    public static StructureTent getByName(String name) {
        for (StructureTent t : StructureTent.values()) {
            if (!name.equals(t.func_176610_l())) continue;
            return t;
        }
        return YURT;
    }

    public String func_176610_l() {
        return this.toString().toLowerCase();
    }

    public abstract boolean isEnabled();

    public abstract boolean areFeaturesEnabled();

    public abstract Class<? extends Categories.ITentBlockBase> getInterface();

    public abstract IBlockState getWallBlock(int var1);

    public abstract IBlockState getRoofBlock(int var1);

    public abstract IBlockState getFrameBlock(boolean var1);

    public abstract int getMaxSize();
}

