/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.structure.util;

import com.yurtmod.init.TentConfig;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public enum StructureWidth implements IStringSerializable
{
    SMALL(5, TextFormatting.RED){

        @Override
        public int getMaxDepth() {
            return TentConfig.TENTS.DEPTH_SMALL;
        }
    }
    ,
    MEDIUM(7, TextFormatting.BLUE){

        @Override
        public int getMaxDepth() {
            return TentConfig.TENTS.DEPTH_MEDIUM;
        }
    }
    ,
    LARGE(9, TextFormatting.GREEN){

        @Override
        public int getMaxDepth() {
            return TentConfig.TENTS.DEPTH_LARGE;
        }
    }
    ,
    HUGE(11, TextFormatting.YELLOW){

        @Override
        public int getMaxDepth() {
            return TentConfig.TENTS.DEPTH_HUGE;
        }
    }
    ,
    GIANT(13, TextFormatting.DARK_PURPLE){

        @Override
        public int getMaxDepth() {
            return TentConfig.TENTS.DEPTH_GIANT;
        }
    }
    ,
    MEGA(15, TextFormatting.AQUA){

        @Override
        public int getMaxDepth() {
            return TentConfig.TENTS.DEPTH_MEGA;
        }
    };

    public static final int NUM_ENTRIES;
    private final TextFormatting textFormatting;
    private final int squareWidth;
    private final int doorOffsetZ;

    private StructureWidth(int sq, TextFormatting formatting) {
        this.textFormatting = formatting;
        this.squareWidth = sq;
        this.doorOffsetZ = this.ordinal() + 2;
    }

    public int getSquareWidth() {
        return this.squareWidth;
    }

    public int getDoorZ() {
        return this.doorOffsetZ;
    }

    public TextFormatting getTooltipColor() {
        return this.textFormatting;
    }

    public boolean isXL() {
        return this == HUGE || this == GIANT || this == MEGA;
    }

    public StructureWidth getOverworldSize() {
        if (TentConfig.GENERAL.USE_ACTUAL_SIZE) {
            return this;
        }
        if (this.isXL()) {
            return MEDIUM;
        }
        return SMALL;
    }

    public static StructureWidth getSmallest() {
        return StructureWidth.values()[0];
    }

    public static StructureWidth getLargest() {
        return StructureWidth.values()[NUM_ENTRIES - 1];
    }

    public byte getId() {
        return (byte)this.ordinal();
    }

    public static StructureWidth getById(byte id) {
        return StructureWidth.values()[MathHelper.func_76125_a((int)id, (int)0, (int)(NUM_ENTRIES - 1))];
    }

    @Nullable
    public static StructureWidth getByName(String name) {
        if (name != null && !name.isEmpty()) {
            for (StructureWidth w : StructureWidth.values()) {
                if (!name.equals(w.func_176610_l())) continue;
                return w;
            }
        }
        return null;
    }

    public String func_176610_l() {
        return this.toString().toLowerCase();
    }

    public abstract int getMaxDepth();

    static {
        NUM_ENTRIES = StructureWidth.values().length;
    }
}

