/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

public class MathUtils {
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float PId2 = 1.5707964f;
    private static final float[] ASIN_TABLE;

    public static float asin(float value) {
        return ASIN_TABLE[(int)((double)(value + 1.0f) * 32767.5) & 0xFFFF];
    }

    public static float acos(float value) {
        return 1.5707964f - ASIN_TABLE[(int)((double)(value + 1.0f) * 32767.5) & 0xFFFF];
    }

    public static int getAverage(int[] vals) {
        if (vals.length <= 0) {
            return 0;
        }
        int sum = MathUtils.getSum(vals);
        int avg = sum / vals.length;
        return avg;
    }

    public static int getSum(int[] vals) {
        if (vals.length <= 0) {
            return 0;
        }
        int sum = 0;
        for (int i2 = 0; i2 < vals.length; ++i2) {
            int val = vals[i2];
            sum += val;
        }
        return sum;
    }

    public static int roundDownToPowerOfTwo(int val) {
        int po2 = rk.c(val);
        if (val == po2) {
            return po2;
        }
        return po2 / 2;
    }

    public static boolean equalsDelta(float f1, float f2, float delta) {
        return Math.abs(f1 - f2) <= delta;
    }

    public static float toDeg(float angle) {
        return angle * 180.0f / rk.PI;
    }

    public static float toRad(float angle) {
        return angle / 180.0f * rk.PI;
    }

    public static float roundToFloat(double d2) {
        return (float)((double)Math.round(d2 * 1.0E8) / 1.0E8);
    }

    static {
        int i2;
        ASIN_TABLE = new float[65536];
        for (i2 = 0; i2 < 65536; ++i2) {
            MathUtils.ASIN_TABLE[i2] = (float)Math.asin((double)i2 / 32767.5 - 1.0);
        }
        for (i2 = -1; i2 < 2; ++i2) {
            MathUtils.ASIN_TABLE[(int)(((double)i2 + 1.0) * 32767.5) & 0xFFFF] = (float)Math.asin(i2);
        }
    }
}

