/*
 * Decompiled with CFR 0.152.
 */
package net.insane96mcp.progressivebosses.events.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.insane96mcp.progressivebosses.events.entities.ai.DragonMinionAIAttack;
import net.insane96mcp.progressivebosses.events.entities.ai.DragonMinionAIAttackNearest;
import net.insane96mcp.progressivebosses.lib.LootTables;
import net.insane96mcp.progressivebosses.lib.ModConfig;
import net.insane96mcp.progressivebosses.lib.Reflection;
import net.insane96mcp.progressivebosses.lib.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseChargingPlayer;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class Dragon {
    public static void SetStats(EntityJoinWorldEvent event) {
        if (event.getWorld().field_73011_w.getDimension() != 1) {
            return;
        }
        if (!(event.getEntity() instanceof EntityDragon)) {
            return;
        }
        EntityDragon dragon = (EntityDragon)event.getEntity();
        NBTTagCompound tags = dragon.getEntityData();
        boolean alreadySpawned = tags.func_74767_n("progressivebosses:spawned");
        if (alreadySpawned) {
            return;
        }
        tags.func_74757_a("progressivebosses:spawned", true);
        int radius = 160;
        BlockPos pos1 = new BlockPos(-radius, -radius, -radius);
        BlockPos pos2 = new BlockPos(radius, radius, radius);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2);
        List players = event.getWorld().func_72872_a(EntityPlayerMP.class, bb);
        if (players.size() == 0) {
            return;
        }
        float killedCount = 0.0f;
        for (EntityPlayerMP player : players) {
            NBTTagCompound playerTags = player.getEntityData();
            int c = playerTags.func_74762_e("progressivebosses:killeddragons");
            if (c == 0) {
                Reflection.Set(Reflection.DragonFightManager_previouslyKilled, dragon.func_184664_cU(), false);
            }
            killedCount += (float)c;
        }
        if (killedCount == 0.0f) {
            return;
        }
        if (!ModConfig.config.dragon.general.sumKilledDragonsDifficulty && killedCount > 0.0f) {
            killedCount /= (float)players.size();
        }
        Dragon.SetHealth(dragon, killedCount);
        Dragon.SetArmor(dragon, killedCount);
        tags.func_74776_a("progressivebosses:difficulty", killedCount);
    }

    private static void SetHealth(EntityDragon dragon, float killedCount) {
        IAttributeInstance attribute = dragon.func_110148_a(SharedMonsterAttributes.field_111267_a);
        attribute.func_111128_a(attribute.func_111125_b() + (double)(killedCount * ModConfig.config.dragon.health.bonusPerDifficulty));
        dragon.func_70606_j((float)attribute.func_111125_b());
    }

    private static void SetArmor(EntityDragon dragon, float killedCount) {
        IAttributeInstance attribute = dragon.func_110148_a(SharedMonsterAttributes.field_188791_g);
        float armor = killedCount * ModConfig.config.dragon.armor.bonusPerDifficulty;
        if (armor > ModConfig.config.dragon.armor.maximum) {
            armor = ModConfig.config.dragon.armor.maximum;
        }
        attribute.func_111128_a((double)armor);
    }

    private static void DropMoreExperience(EntityDragon dragon, World world) {
        int i;
        if (dragon.field_70995_bG != 150) {
            return;
        }
        NBTTagCompound tags = dragon.getEntityData();
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        for (int xp = (int)(500.0f * (ModConfig.config.dragon.rewards.bonusExperience * difficulty / 100.0f)); xp > 0; xp -= i) {
            i = EntityXPOrb.func_70527_a((int)xp);
            dragon.field_70170_p.func_72838_d((Entity)new EntityXPOrb(dragon.field_70170_p, dragon.field_70165_t, dragon.field_70163_u, dragon.field_70161_v, i));
        }
    }

    public static void OnDeath(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof EntityDragon)) {
            return;
        }
        EntityDragon dragon = (EntityDragon)event.getEntity();
        NBTTagCompound tags = dragon.getEntityData();
        if (tags.func_74767_n("progressivebosses:hasbeenkilled")) {
            return;
        }
        tags.func_74757_a("progressivebosses:hasbeenkilled", true);
        int radius = 160;
        BlockPos pos1 = new BlockPos(-radius, -radius, -radius);
        BlockPos pos2 = new BlockPos(radius, radius, radius);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2);
        List players = dragon.field_70170_p.func_72872_a(EntityPlayerMP.class, bb);
        if (players.size() == 0) {
            return;
        }
        int c = 0;
        int eggsToDrop = 0;
        for (EntityPlayerMP player : players) {
            NBTTagCompound playerTags = player.getEntityData();
            c = playerTags.func_74762_e("progressivebosses:killeddragons");
            if (c == 0) {
                ++eggsToDrop;
            }
            if (c >= ModConfig.config.wither.general.maxDifficulty) continue;
            playerTags.func_74768_a("progressivebosses:killeddragons", c + 1);
        }
        tags.func_74768_a("progressivebosses:eggstodrop", eggsToDrop);
    }

    public static void OnPlayerDamage(LivingHurtEvent event) {
        if (!(event.getSource().func_76364_f() instanceof EntityDragon)) {
            return;
        }
        EntityDragon dragon = (EntityDragon)event.getSource().func_76364_f();
        NBTTagCompound tags = dragon.getEntityData();
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty == 0.0f) {
            return;
        }
        event.setAmount(event.getAmount() * (difficulty * (ModConfig.config.dragon.attack.bonusDamage / 100.0f) + 1.0f));
    }

    private static void DropEgg(EntityDragon dragon, World world) {
        if (dragon.field_70995_bG != 100) {
            return;
        }
        NBTTagCompound tags = dragon.getEntityData();
        int eggsToDrop = tags.func_74762_e("progressivebosses:eggstodrop");
        if (dragon.func_184664_cU() != null && !dragon.func_184664_cU().func_186102_d()) {
            --eggsToDrop;
        }
        for (int i = 0; i < eggsToDrop; ++i) {
            world.func_175656_a(new BlockPos(0, 255 - i, 0), Blocks.field_150380_bt.func_176223_P());
        }
    }

    public static void Update(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof EntityDragon)) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        EntityDragon dragon = (EntityDragon)event.getEntity();
        NBTTagCompound tags = dragon.getEntityData();
        Dragon.ChargePlayer(dragon);
        Dragon.SpawnEndermites(dragon, world);
        Dragon.SpawnShulkers(dragon, world);
        Dragon.Heal(dragon, tags);
        Dragon.DropEgg(dragon, world);
        Dragon.DropMoreExperience(dragon, world);
    }

    private static void ChargePlayer(EntityDragon dragon) {
        EntityPlayer player;
        if (dragon.func_184664_cU() == null) {
            return;
        }
        NBTTagCompound tags = dragon.getEntityData();
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        float chance = ModConfig.config.dragon.attack.fullChanceToAttack / 100.0f / 23.0f;
        chance *= difficulty;
        int crystalsAlive = dragon.func_184664_cU().func_186092_c() + 1;
        chance *= 1.0f / (float)crystalsAlive;
        if (Math.random() < (double)chance && dragon.func_184670_cT().func_188756_a().func_188652_i() == PhaseList.field_188741_a && (player = dragon.field_70170_p.func_184142_a((Entity)dragon, 100.0, 150.0)) != null) {
            dragon.func_184670_cT().func_188758_a(PhaseList.field_188749_i);
            ((PhaseChargingPlayer)dragon.func_184670_cT().func_188757_b(PhaseList.field_188749_i)).func_188668_a(new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        }
    }

    private static void Heal(EntityDragon dragon, NBTTagCompound tags) {
        if (ModConfig.config.dragon.health.maximumBonusRegen == 0.0f) {
            return;
        }
        if (dragon.field_70173_aa % 20 != 0) {
            return;
        }
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty == 0.0f) {
            return;
        }
        float heal = difficulty * ModConfig.config.dragon.health.bonusRegenPerSpawned;
        float maxHeal = ModConfig.config.dragon.health.maximumBonusRegen;
        if (heal > maxHeal) {
            heal = maxHeal;
        }
        float health = dragon.func_110143_aJ();
        if (dragon.func_110143_aJ() < dragon.func_110138_aP() && dragon.func_110143_aJ() > 0.0f) {
            dragon.func_70606_j(health + heal);
        }
    }

    private static void SpawnEndermites(EntityDragon dragon, World world) {
        if (ModConfig.config.dragon.larvae.maxSpawned == 0) {
            return;
        }
        NBTTagCompound tags = dragon.getEntityData();
        tags.func_74757_a("mobsrandomizzation:preventProcessing", true);
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty < (float)ModConfig.config.dragon.larvae.difficultyToSpawnOneMore) {
            return;
        }
        int cooldown = tags.func_74762_e("progressivebosses:endermites_cooldown");
        if (cooldown > 0) {
            tags.func_74768_a("progressivebosses:endermites_cooldown", cooldown - 1);
        } else {
            int cooldownReduction = (int)(difficulty * (float)ModConfig.config.dragon.larvae.cooldownReduction);
            cooldown = MathHelper.func_76136_a((Random)world.field_73012_v, (int)(ModConfig.config.dragon.larvae.minCooldown - cooldownReduction), (int)(ModConfig.config.dragon.larvae.maxCooldown - cooldownReduction));
            tags.func_74768_a("progressivebosses:endermites_cooldown", cooldown);
            int i = 1;
            while ((float)i <= difficulty && i / ModConfig.config.dragon.larvae.difficultyToSpawnOneMore <= ModConfig.config.dragon.larvae.maxSpawned) {
                if (i % ModConfig.config.dragon.larvae.difficultyToSpawnOneMore == 0) {
                    EntityEndermite endermite = new EntityEndermite(world);
                    NBTTagCompound endermiteTags = endermite.getEntityData();
                    endermiteTags.func_74777_a("scalinghealth:difficulty", (short)-1);
                    float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                    float x = (float)(Math.cos(angle) * (double)3.15f);
                    float z = (float)(Math.sin(angle) * (double)3.15f);
                    int y = world.func_175672_r(new BlockPos((double)x, 255.0, (double)z)).func_177956_o();
                    IAttributeInstance attribute = endermite.func_110148_a(SharedMonsterAttributes.field_111263_d);
                    attribute.func_111128_a(attribute.func_111125_b() * 1.5);
                    attribute = endermite.func_110148_a(SharedMonsterAttributes.field_111265_b);
                    attribute.func_111128_a(64.0);
                    attribute = endermite.func_110148_a(SharedMonsterAttributes.field_111267_a);
                    attribute.func_111128_a(4.0);
                    endermite.func_70606_j((float)attribute.func_111125_b());
                    endermite.func_70107_b((double)x, (double)y, (double)z);
                    endermite.func_96094_a("Dragon's Larva");
                    EntityAITasks.EntityAITaskEntry toRemove = null;
                    for (EntityAITasks.EntityAITaskEntry task : endermite.field_70714_bg.field_75782_a) {
                        if (!(task.field_75733_a instanceof EntityAIWatchClosest)) continue;
                        toRemove = task;
                    }
                    if (toRemove != null) {
                        endermite.field_70714_bg.field_75782_a.remove(toRemove);
                    }
                    endermite.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)endermite, EntityPlayer.class, 64.0f));
                    for (EntityAITasks.EntityAITaskEntry targetTask : endermite.field_70715_bh.field_75782_a) {
                        if (!(targetTask.field_75733_a instanceof EntityAINearestAttackableTarget)) continue;
                        toRemove = targetTask;
                    }
                    if (toRemove != null) {
                        endermite.field_70715_bh.field_75782_a.remove(toRemove);
                    }
                    endermite.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)endermite, EntityPlayer.class, false));
                    Reflection.Set(Reflection.EntityLiving_experienceValue, endermite, 1);
                    world.func_72838_d((Entity)endermite);
                }
                ++i;
            }
        }
    }

    private static void SpawnShulkers(EntityDragon dragon, World world) {
        if (ModConfig.config.dragon.minions.difficultyToSpawn <= 0) {
            return;
        }
        NBTTagCompound tags = dragon.getEntityData();
        tags.func_74757_a("mobsrandomizzation:preventProcessing", true);
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty < (float)ModConfig.config.dragon.minions.difficultyToSpawn) {
            return;
        }
        int cooldown = tags.func_74762_e("progressivebosses:shulkers_cooldown");
        if (cooldown > 0) {
            tags.func_74768_a("progressivebosses:shulkers_cooldown", cooldown - 1);
        } else {
            int cooldownReduction = (int)(difficulty * (float)ModConfig.config.dragon.minions.spawnCooldownReduction);
            cooldown = MathHelper.func_76136_a((Random)world.field_73012_v, (int)(ModConfig.config.dragon.minions.minCooldown - cooldownReduction), (int)(ModConfig.config.dragon.minions.maxCooldown - cooldownReduction));
            tags.func_74768_a("progressivebosses:shulkers_cooldown", cooldown);
            EntityShulker shulker = new EntityShulker(world);
            NBTTagCompound shulkerTags = shulker.getEntityData();
            shulkerTags.func_74777_a("scalinghealth:difficulty", (short)-1);
            float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            float x = (float)(Math.cos(angle) * (double)Utils.Math.getFloat(world.field_73012_v, 15.0f, 40.0f));
            float z = (float)(Math.sin(angle) * (double)Utils.Math.getFloat(world.field_73012_v, 15.0f, 40.0f));
            float y = world.func_175672_r(new BlockPos((double)x, 255.0, (double)z)).func_177956_o();
            IAttributeInstance followRange = shulker.func_110148_a(SharedMonsterAttributes.field_111265_b);
            followRange.func_111128_a(64.0);
            shulker.func_70107_b((double)x, (double)y, (double)z);
            NBTTagCompound compound = new NBTTagCompound();
            shulker.func_70014_b(compound);
            compound.func_74774_a("Color", (byte)15);
            shulker.func_70037_a(compound);
            shulker.func_96094_a("Dragon's Minion");
            ArrayList<EntityAITasks.EntityAITaskEntry> toRemove = new ArrayList<EntityAITasks.EntityAITaskEntry>();
            for (EntityAITasks.EntityAITaskEntry task : shulker.field_70714_bg.field_75782_a) {
                if (task.field_75733_a instanceof EntityAIWatchClosest) {
                    toRemove.add(task);
                }
                if (!Reflection.EntityShulker_AIAttack.isInstance(task.field_75733_a)) continue;
                toRemove.add(task);
            }
            for (EntityAITasks.EntityAITaskEntry entityAITaskEntry : toRemove) {
                shulker.field_70714_bg.field_75782_a.remove(entityAITaskEntry);
            }
            toRemove.clear();
            for (EntityAITasks.EntityAITaskEntry targetTask : shulker.field_70715_bh.field_75782_a) {
                if (!(targetTask.field_75733_a instanceof EntityAINearestAttackableTarget)) continue;
                toRemove.add(targetTask);
            }
            for (EntityAITasks.EntityAITaskEntry entityAITaskEntry : toRemove) {
                shulker.field_70715_bh.field_75782_a.remove(entityAITaskEntry);
            }
            toRemove.clear();
            shulker.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)shulker, EntityPlayer.class, 64.0f));
            shulker.field_70714_bg.func_75776_a(1, (EntityAIBase)new DragonMinionAIAttack(shulker));
            shulker.field_70715_bh.func_75776_a(2, (EntityAIBase)new DragonMinionAIAttackNearest(shulker));
            Reflection.Set(Reflection.EntityLiving_deathLootTable, shulker, LootTables.dragonMinion);
            Reflection.Set(Reflection.EntityLiving_experienceValue, shulker, 2);
            world.func_72838_d((Entity)shulker);
        }
    }
}

