/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys;

import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.logging.log4j.Logger;
import vibrantjourneys.ICommonProxy;
import vibrantjourneys.init.PVJBiomes;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.init.PVJCrafting;
import vibrantjourneys.init.PVJEntities;
import vibrantjourneys.init.PVJItems;
import vibrantjourneys.init.PVJRegistryEvents;
import vibrantjourneys.init.PVJTileEntities;
import vibrantjourneys.init.PVJWorldGen;
import vibrantjourneys.util.BiomeReference;
import vibrantjourneys.util.PVJConfig;
import vibrantjourneys.util.PVJEvents;
import vibrantjourneys.util.Reference;
import vibrantjourneys.worldgen.PVJTerrainGenEvents;

@Mod(modid="pvj", name="Project: Vibrant Journeys", version="1.6.4", dependencies="after:biomesoplenty;after:traverse", acceptedMinecraftVersions="[1.12.2]")
public class ProjectVibrantJourneys {
    @Mod.Instance(value="pvj")
    public static ProjectVibrantJourneys instance;
    @SidedProxy(clientSide="vibrantjourneys.ClientProxy", serverSide="vibrantjourneys.ServerProxy")
    public static ICommonProxy proxy;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        if (Loader.isModLoaded((String)"biomesoplenty")) {
            logger.info("Project: Vibrant Journeys detected that you also have Biomes O' Plenty installed! Enjoy your adventures!");
            Reference.isBOPLoaded = true;
        }
        if (Loader.isModLoaded((String)"traverse")) {
            logger.info("Project: Vibrant Journeys detected that you also have Traverse installed! Safe travels!");
            Reference.isTraverseLoaded = true;
        }
        if (Loader.isModLoaded((String)"sereneseasons")) {
            logger.info("Project: Vibrant Journeys detected that you also have Serene Seasons installed! Good choice!");
            Reference.isSereneSeasonsLoaded = true;
        }
        PVJEntities.initEntities();
        PVJBlocks.initBlocks();
        PVJItems.initItems();
        PVJBiomes.initBiomes();
        PVJTileEntities.initTileEntities();
        MinecraftForge.EVENT_BUS.register((Object)new PVJRegistryEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PVJConfig.ConfigEventHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerTESRs();
        PVJCrafting.initCrafting();
        BiomeReference.loadAllBiomeReferences();
        PVJWorldGen.initWorldGen();
        PVJEntities.addSpawns();
        if (PVJConfig.misc.restrictSquidsToOceans) {
            EntityRegistry.removeSpawn(EntitySquid.class, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (Biome[])BiomeReference.getBiomes(BiomeReference.FRESHWATER_BIOMES));
        }
        proxy.registerBlockColors();
        MinecraftForge.EVENT_BUS.register((Object)new PVJEvents());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new PVJTerrainGenEvents());
    }
}

