/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.biomes;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BiomeOvergrownSpires
extends Biome {
    private static final IBlockState JUNGLE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private static final IBlockState OAK_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    protected static final IBlockState GRASS = Blocks.field_150349_c.func_176223_P();
    protected static final WorldGenCanopyTree ROOF_TREE = new WorldGenCanopyTree(false);
    private long worldSeed;
    private NoiseGeneratorPerlin pillarNoise;
    private NoiseGeneratorPerlin pillarRoofNoise;

    public BiomeOvergrownSpires(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76760_I.field_76832_z = 20;
        this.field_76760_I.field_76803_B = 35;
        this.field_76760_I.field_76799_E = 9;
        this.field_76760_I.field_76802_A = 3;
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityParrot.class, 40, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityOcelot.class, 2, 1, 1));
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        int num = rand.nextInt(100);
        if (num > 80) {
            return field_76757_N;
        }
        if (num > 60) {
            return new WorldGenShrub(JUNGLE_LOG, OAK_LEAF);
        }
        if (num > 35) {
            return new WorldGenTrees(false, 4 + rand.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
        }
        if (num > 10) {
            return ROOF_TREE;
        }
        return field_76758_O;
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        if (this.pillarNoise == null || this.pillarRoofNoise == null || this.worldSeed != worldIn.func_72905_C()) {
            Random random = new Random(this.worldSeed);
            this.pillarNoise = new NoiseGeneratorPerlin(random, 4);
            this.pillarRoofNoise = new NoiseGeneratorPerlin(random, 1);
        }
        this.worldSeed = worldIn.func_72905_C();
        double d4 = 0.0;
        int i = (x & 0xFFFFFFF0) + (z & 0xF);
        int j = (z & 0xFFFFFFF0) + (x & 0xF);
        double d0 = Math.min(Math.abs(noiseVal), this.pillarNoise.func_151601_a((double)i * 0.25, (double)j * 0.25));
        if (d0 > 0.0) {
            d4 = d0 * d0 * 2.5;
            double d2 = Math.abs(this.pillarRoofNoise.func_151601_a((double)i * 0.001953125, (double)j * 0.001953125));
            double d3 = Math.ceil(d2 * 50.0) + 14.0;
            if (d4 > d3) {
                d4 = d3;
            }
            d4 += 64.0;
        }
        int k1 = x & 0xF;
        int l1 = z & 0xF;
        int i2 = worldIn.func_181545_F();
        IBlockState iblockstate = this.field_76753_B;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = -1;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (chunkPrimerIn.func_177856_a(l1, j1, k1).func_185904_a() == Material.field_151579_a && j1 < (int)d4) {
                chunkPrimerIn.func_177855_a(l1, j1, k1, field_185365_a);
            }
            if (j1 <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(l1, j1, k1, field_185367_c);
                continue;
            }
            IBlockState iblockstate1 = chunkPrimerIn.func_177856_a(l1, j1, k1);
            if (iblockstate1.func_185904_a() == Material.field_151579_a) {
                l = -1;
                continue;
            }
            if (iblockstate1.func_177230_c() != Blocks.field_150348_b) continue;
            if (l == -1) {
                if (k <= 0) {
                    iblockstate = field_185366_b;
                } else if (j1 >= i2 - 4 && j1 <= i2 + 1) {
                    iblockstate = this.field_76753_B;
                }
                if (j1 < i2 && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = field_185372_h;
                }
                l = k + Math.max(0, j1 - i2);
                if (j1 >= i2 - 1) {
                    chunkPrimerIn.func_177855_a(l1, j1, k1, this.field_76752_A);
                    continue;
                }
                chunkPrimerIn.func_177855_a(l1, j1, k1, this.field_76753_B);
                continue;
            }
            if (l <= 0) continue;
            --l;
            chunkPrimerIn.func_177855_a(l1, j1, k1, field_185365_a);
        }
    }

    public WorldGenerator func_76730_b(Random rand) {
        return rand.nextInt(4) == 0 ? new WorldGenTallGrass(BlockTallGrass.EnumType.FERN) : new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }
}

