/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.entities.neutral;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vibrantjourneys.entities.ai.EntityAIStareAt;
import vibrantjourneys.entities.ai.EntityWatcherAttack;
import vibrantjourneys.util.PVJLootTableList;

public class EntityWatcher
extends EntityMob {
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityWatcher.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityLivingBase targetedEntity;
    private int clientSideAttackTime;

    public EntityWatcher(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIStareAt((EntityLiving)this, EntityPlayer.class, 90.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityWatcherAttack(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70181_x = 0.0;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.hasTargetedEntity()) {
            this.clientSideAttackTime = this.clientSideAttackTime < this.getAttackDuration() ? ++this.clientSideAttackTime : 0;
        }
    }

    public float getAttackAnimationScale() {
        return (float)this.clientSideAttackTime / (float)this.getAttackDuration();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(90.0);
    }

    public void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    @Nullable
    public EntityLivingBase getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    public int getAttackDuration() {
        return 70;
    }

    protected ResourceLocation func_184647_J() {
        return PVJLootTableList.WATCHER;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (TARGET_ENTITY.equals(key)) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v));
    }
}

