/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.entities.renderer;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vibrantjourneys.entities.neutral.EntityCoyote;
import vibrantjourneys.entities.renderer.LayerCoyoteCollar;
import vibrantjourneys.entities.renderer.models.ModelCoyote;

@SideOnly(value=Side.CLIENT)
public class RenderCoyote
extends RenderLiving<EntityCoyote> {
    private static final ResourceLocation COYOTE = new ResourceLocation("pvj", "textures/entity/coyote/coyote.png");
    private static final ResourceLocation TAMED_COYOTE = new ResourceLocation("pvj", "textures/entity/coyote/coyote_tame.png");
    private static final ResourceLocation ANGRY_BOI = new ResourceLocation("pvj", "textures/entity/coyote/coyote_angry.png");

    public RenderCoyote(RenderManager manager) {
        super(manager, (ModelBase)new ModelCoyote(), 0.5f);
        this.func_177094_a(new LayerCoyoteCollar(this));
    }

    protected float handleRotationFloat(EntityCoyote livingBase, float partialTicks) {
        return livingBase.getTailRotation();
    }

    public void doRender(EntityCoyote entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity.isWolfWet()) {
            float f = entity.func_70013_c() * entity.getShadingWhileWet(partialTicks);
            GlStateManager.func_179124_c((float)f, (float)f, (float)f);
        }
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected void preRenderCallback(EntityCoyote entitylivingbaseIn, float partialTickTime) {
        GlStateManager.func_179152_a((float)0.9f, (float)0.9f, (float)0.9f);
    }

    protected ResourceLocation getEntityTexture(EntityCoyote entity) {
        if (entity.func_70909_n()) {
            return TAMED_COYOTE;
        }
        return entity.isAngry() ? ANGRY_BOI : COYOTE;
    }

    public static class Factory
    implements IRenderFactory<EntityCoyote> {
        public Render<? super EntityCoyote> createRenderFor(RenderManager manager) {
            return new RenderCoyote(manager);
        }
    }
}

