/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.init;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import vibrantjourneys.ProjectVibrantJourneys;
import vibrantjourneys.entities.item.EntityCoconut;
import vibrantjourneys.entities.item.EntityPVJBoat;
import vibrantjourneys.entities.monster.EntityBanshee;
import vibrantjourneys.entities.monster.EntityGoon;
import vibrantjourneys.entities.monster.EntityIceCube;
import vibrantjourneys.entities.monster.EntityShade;
import vibrantjourneys.entities.monster.EntitySkeletalKnight;
import vibrantjourneys.entities.neutral.EntityCoyote;
import vibrantjourneys.entities.neutral.EntityGhost;
import vibrantjourneys.entities.neutral.EntityGrizzlyBear;
import vibrantjourneys.entities.neutral.EntityWatcher;
import vibrantjourneys.entities.passive.EntityBeachStarfish;
import vibrantjourneys.entities.passive.EntityClam;
import vibrantjourneys.entities.passive.EntityDuck;
import vibrantjourneys.entities.passive.EntityFirefly;
import vibrantjourneys.entities.passive.EntityFly;
import vibrantjourneys.entities.passive.EntitySmallSpider;
import vibrantjourneys.entities.passive.EntitySnail;
import vibrantjourneys.entities.passive.EntityStarfish;
import vibrantjourneys.util.BiomeReference;
import vibrantjourneys.util.PVJConfig;

public class PVJEntities {
    public static int id = 1;
    public static final ArrayList<EntityEntry> ENTITIES = new ArrayList();

    public static void initEntities() {
        PVJEntities.registerEntityWithEgg("pvj_snail", EntitySnail.class, 64, 7161149, 6781788);
        PVJEntities.registerEntityWithEgg("pvj_fly", EntityFly.class, 64, 0x669999, 0x737373);
        PVJEntities.registerEntityWithEgg("pvj_firefly", EntityFirefly.class, 64, 4146493, 15261757);
        PVJEntities.registerEntityWithEgg("pvj_small_spider", EntitySmallSpider.class, 64, 6656, 0x4D0000);
        PVJEntities.registerEntityWithEgg("pvj_starfish", EntityStarfish.class, 64, 7161149, 6781788);
        PVJEntities.registerEntityWithEgg("pvj_clam", EntityClam.class, 64, 6775884, 4868150);
        PVJEntities.registerEntityWithEgg("pvj_duck", EntityDuck.class, 64, 4269084, 611110);
        PVJEntities.registerEntityWithEgg("pvj_grizzly_bear", EntityGrizzlyBear.class, 64, 8013099, 3940627);
        PVJEntities.registerEntityWithEgg("pvj_coyote", EntityCoyote.class, 64, 12757645, 9794896);
        PVJEntities.registerEntityWithEgg("pvj_ghost", EntityGhost.class, 64, 0xB3B3B3, 0x404040);
        PVJEntities.registerEntityWithEgg("pvj_shade", EntityShade.class, 64, 0x333333, 0x595959);
        PVJEntities.registerEntityWithEgg("pvj_banshee", EntityBanshee.class, 64, 0x333333, 5467507);
        PVJEntities.registerEntityWithEgg("pvj_icecube", EntityIceCube.class, 64, 6742271, 0xCCF5FF);
        PVJEntities.registerEntityWithEgg("pvj_skeletal_knight", EntitySkeletalKnight.class, 64, 0xA6A6A6, 0x808080);
        PVJEntities.registerEntityWithEgg("pvj_goon", EntityGoon.class, 64, 0xA6A6A6, 0x808080);
        PVJEntities.registerEntityWithEgg("pvj_watcher", EntityWatcher.class, 64, 0xB5B3B3, 0x404044);
        PVJEntities.registerEntity("pvj_beach_starfish", EntityBeachStarfish.class, 64);
        PVJEntities.registerEntity("pvj_boat", EntityPVJBoat.class, 64);
        PVJEntities.registerEntity("pvj_coconut", EntityCoconut.class, 64);
    }

    private static <T extends Entity> void registerEntity(String name, Class<T> entityClass, int trackingRange) {
        ResourceLocation entityResource = new ResourceLocation("pvj", name);
        EntityEntry entity = EntityEntryBuilder.create().entity(entityClass).id(entityResource, id++).name(name).tracker(trackingRange, 3, true).build();
        ENTITIES.add(entity);
    }

    private static <T extends Entity> void registerEntityWithEgg(String name, Class<T> entityClass, int trackingRange, int eggPrimary, int eggSecondary) {
        ResourceLocation entityResource = new ResourceLocation("pvj", name);
        EntityEntry entity = EntityEntryBuilder.create().entity(entityClass).id(entityResource, id++).name(name).tracker(trackingRange, 3, true).egg(eggPrimary, eggSecondary).build();
        ENTITIES.add(entity);
    }

    public static void addSpawns() {
        if (PVJConfig.master.enablePassiveMobs) {
            PVJEntities.addSpawn(EntitySnail.class, PVJConfig.entities.snailSpawnWeight, 2, 4, EnumCreatureType.AMBIENT, BiomeReference.getBiomes(BiomeReference.FRESHWATER_BIOMES));
            PVJEntities.addSpawn(EntityFly.class, PVJConfig.entities.flySpawnWeight, 3, 4, EnumCreatureType.AMBIENT, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES));
            PVJEntities.addSpawn(EntityFly.class, PVJConfig.entities.flySwampSpawnWeight, 4, 5, EnumCreatureType.AMBIENT, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP).toArray(new Biome[0]));
            PVJEntities.addSpawn(EntityFirefly.class, PVJConfig.entities.fireflySpawnWeight, 4, 9, EnumCreatureType.AMBIENT, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES));
            PVJEntities.addSpawn(EntitySmallSpider.class, PVJConfig.entities.spiderSpawnWeight, 1, 6, EnumCreatureType.AMBIENT, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES));
            PVJEntities.addSpawn(EntityStarfish.class, PVJConfig.entities.starfishWeight, 1, 4, EnumCreatureType.AMBIENT, BiomeReference.getBiomes(BiomeReference.MARINE_BIOMES));
            PVJEntities.addSpawn(EntityBeachStarfish.class, PVJConfig.entities.starfishWeight, 1, 4, EnumCreatureType.AMBIENT, BiomeReference.getBiomes(BiomeReference.BEACH_BIOMES));
            PVJEntities.addSpawn(EntityDuck.class, PVJConfig.entities.duckWeight, 2, 4, EnumCreatureType.CREATURE, BiomeReference.getBiomes(BiomeReference.DUCK_BIOMES));
            PVJEntities.addSpawn(EntityClam.class, PVJConfig.entities.clamWeight, 1, 3, EnumCreatureType.WATER_CREATURE, BiomeReference.getBiomes(BiomeReference.FRESHWATER_BIOMES));
            EntitySpawnPlacementRegistry.setPlacementType(EntityStarfish.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
            EntitySpawnPlacementRegistry.setPlacementType(EntityClam.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        } else {
            ProjectVibrantJourneys.logger.info("Passive mobs disabled");
        }
        if (PVJConfig.master.enableNeutralMobs) {
            PVJEntities.addSpawn(EntityGhost.class, PVJConfig.entities.ghostSpawnWeight, 1, 4, EnumCreatureType.MONSTER, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES_MINUS_MUSHROOM));
            PVJEntities.addSpawn(EntityGrizzlyBear.class, PVJConfig.entities.grizzlyBearSpawnWeight, 1, 2, EnumCreatureType.CREATURE, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS).toArray(new Biome[0]));
            PVJEntities.addSpawn(EntityWatcher.class, PVJConfig.entities.watcherSpawnWeight, 2, 4, EnumCreatureType.MONSTER, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END).toArray(new Biome[0]));
            PVJEntities.addSpawn(EntityCoyote.class, PVJConfig.entities.coyoteSpawnWeight, 1, 1, EnumCreatureType.CREATURE, BiomeReference.getBiomes(BiomeReference.COYOTE_BIOMES));
        } else {
            ProjectVibrantJourneys.logger.info("Neutral mobs disabled");
        }
        if (PVJConfig.master.enableAggressiveMobs) {
            PVJEntities.addSpawn(EntityShade.class, PVJConfig.entities.shadeSpawnWeight, 1, 3, EnumCreatureType.MONSTER, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES_MINUS_MUSHROOM));
            PVJEntities.addSpawn(EntityBanshee.class, PVJConfig.entities.bansheeSpawnWeight, 1, 3, EnumCreatureType.MONSTER, BiomeReference.getBiomes(BiomeReference.SNOWY_BIOMES));
            PVJEntities.addSpawn(EntityShade.class, PVJConfig.entities.shadeRoofedForestSpawnWeight, 1, 3, EnumCreatureType.MONSTER, Biomes.field_150585_R, Biomes.field_185430_ab);
            PVJEntities.addSpawn(EntitySkeletalKnight.class, PVJConfig.entities.skeletalKnightWeight, 1, 3, EnumCreatureType.MONSTER, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES_MINUS_MUSHROOM));
            PVJEntities.addSpawn(EntityIceCube.class, PVJConfig.entities.icecubeSpawnWeight, 2, 3, EnumCreatureType.MONSTER, BiomeReference.getBiomes(BiomeReference.SNOWY_BIOMES));
            PVJEntities.addSpawn(EntityGoon.class, PVJConfig.entities.goonSpawnWeight, 1, 1, EnumCreatureType.MONSTER, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES_MINUS_MUSHROOM));
        } else {
            ProjectVibrantJourneys.logger.info("Aggressive mobs disabled");
        }
        if (PVJConfig.entities.junglesSpawnCaveSpiders) {
            PVJEntities.addSpawn(EntityCaveSpider.class, 50, 1, 3, EnumCreatureType.MONSTER, BiomeReference.getBiomes(BiomeReference.JUNGLE_TREES));
        } else {
            ProjectVibrantJourneys.logger.info("Cave spiders in jungles disabled");
        }
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("pvj", "pvj_shade"), (int)100);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("pvj", "pvj_skeletal_knight"), (int)100);
    }

    public static void addSpawn(Class<? extends EntityLiving> entityClass, int weightedProb, int min, int max, EnumCreatureType typeOfCreature, Biome ... biomes) {
        if (weightedProb > 0) {
            double multiplier = 1.0;
            if (typeOfCreature == EnumCreatureType.AMBIENT || typeOfCreature == EnumCreatureType.CREATURE) {
                multiplier = (double)PVJConfig.global.animalsDensity / 100.0;
            }
            if (typeOfCreature == EnumCreatureType.MONSTER) {
                multiplier = (double)PVJConfig.global.mobsDensity / 100.0;
            }
            EntityRegistry.addSpawn(entityClass, (int)((int)((double)weightedProb * multiplier)), (int)min, (int)max, (EnumCreatureType)typeOfCreature, (Biome[])biomes);
        }
    }
}

