/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.tileentities;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockFire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vibrantjourneys.blocks.BlockMysticalGrill;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.init.PVJItems;
import vibrantjourneys.util.PVJConfig;

public class TileEntityMysticalGrill
extends TileEntity
implements ITickable {
    public static final Potion[] BENEFICIAL_POTIONS = new Potion[]{Potion.func_180142_b((String)"speed"), Potion.func_180142_b((String)"haste"), Potion.func_180142_b((String)"strength"), Potion.func_180142_b((String)"instant_health"), Potion.func_180142_b((String)"jump_boost"), Potion.func_180142_b((String)"regeneration"), Potion.func_180142_b((String)"resistance"), Potion.func_180142_b((String)"fire_resistance"), Potion.func_180142_b((String)"water_breathing"), Potion.func_180142_b((String)"invisibility"), Potion.func_180142_b((String)"health_boost"), Potion.func_180142_b((String)"absorption"), Potion.func_180142_b((String)"luck")};
    private ItemStack food = ItemStack.field_190927_a;
    private int cookTime = 0;
    private boolean isCooking = false;
    private int netherWartCount = 0;
    private boolean hasEssence = false;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isCooking && !this.canCook()) {
                this.isCooking = false;
                this.field_145850_b.func_175656_a(this.func_174877_v(), PVJBlocks.mystical_grill.func_176223_P().func_177226_a((IProperty)BlockMysticalGrill.IS_COOKING, (Comparable)Boolean.valueOf(false)));
            }
            if (this.isCooking) {
                if (this.cookTime >= PVJConfig.misc.mysticalGrillCookTime) {
                    ItemStack cookedItem = this.getCookedFood(this.food);
                    this.setFood(cookedItem);
                    this.isCooking = false;
                    this.netherWartCount = 0;
                    this.hasEssence = false;
                    this.cookTime = 0;
                    IBlockState cauldron = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
                    int level = cauldron.func_177230_c().func_176201_c(cauldron) - 1;
                    this.field_145850_b.func_175656_a(this.field_174879_c.func_177977_b(), cauldron.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(level)));
                    this.field_145850_b.func_175656_a(this.func_174877_v(), PVJBlocks.mystical_grill.func_176223_P().func_177226_a((IProperty)BlockMysticalGrill.IS_COOKING, (Comparable)Boolean.valueOf(false)));
                } else {
                    ++this.cookTime;
                }
            } else if (this.canCook()) {
                this.isCooking = true;
                this.field_145850_b.func_175656_a(this.func_174877_v(), PVJBlocks.mystical_grill.func_176223_P().func_177226_a((IProperty)BlockMysticalGrill.IS_COOKING, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public boolean isCooking() {
        return this.isCooking;
    }

    public int getNetherWartCount() {
        return this.netherWartCount;
    }

    public boolean addNetherWart() {
        if (this.netherWartCount < 5) {
            ++this.netherWartCount;
            this.updateTE();
            return true;
        }
        return false;
    }

    public boolean hasEssence() {
        return this.hasEssence;
    }

    public boolean addUnstableEssence() {
        if (this.hasEssence) {
            return false;
        }
        this.hasEssence = true;
        this.updateTE();
        return true;
    }

    public boolean canCook() {
        IBlockState state;
        return this.getCookedFood(this.food) != ItemStack.field_190927_a && this.getNetherWartCount() == 5 && this.hasEssence() && (this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(2)).func_177230_c() instanceof BlockFire || this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(2)).func_177230_c() == Blocks.field_189877_df) && (state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b())).func_177230_c() == Blocks.field_150383_bp && state.func_177230_c().func_176201_c(state) > 0;
    }

    public ItemStack getCookedFood(ItemStack item) {
        ItemStack cookedFood = ItemStack.field_190927_a;
        if (item.func_77973_b() == Items.field_151147_al) {
            cookedFood = PotionUtils.func_185184_a((ItemStack)new ItemStack(PVJItems.mystical_porkchop), this.getRandomEffects());
        }
        if (item.func_77973_b() == Items.field_151082_bd) {
            cookedFood = PotionUtils.func_185184_a((ItemStack)new ItemStack(PVJItems.mystical_beef), this.getRandomEffects());
        }
        if (item.func_77973_b() == Items.field_151076_bf) {
            cookedFood = PotionUtils.func_185184_a((ItemStack)new ItemStack(PVJItems.mystical_chicken), this.getRandomEffects());
        }
        if (item.func_77973_b() == Items.field_179561_bm) {
            cookedFood = PotionUtils.func_185184_a((ItemStack)new ItemStack(PVJItems.mystical_mutton), this.getRandomEffects());
        }
        if (item.func_77973_b() == Items.field_151115_aP && item.func_77960_j() == 0) {
            cookedFood = PotionUtils.func_185184_a((ItemStack)new ItemStack(PVJItems.mystical_cod), this.getRandomEffects());
        }
        if (item.func_77973_b() == Items.field_151115_aP && item.func_77960_j() == 1) {
            cookedFood = PotionUtils.func_185184_a((ItemStack)new ItemStack(PVJItems.mystical_salmon), this.getRandomEffects());
        }
        if (item.func_77973_b() == Items.field_151174_bG) {
            cookedFood = PotionUtils.func_185184_a((ItemStack)new ItemStack(PVJItems.mystical_potato), this.getRandomEffects());
        }
        if (item.func_77973_b() == Items.field_179558_bo) {
            cookedFood = PotionUtils.func_185184_a((ItemStack)new ItemStack(PVJItems.mystical_rabbit), this.getRandomEffects());
        }
        return cookedFood;
    }

    public ArrayList<PotionEffect> getRandomEffects() {
        Potion effect2;
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        int size = BENEFICIAL_POTIONS.length;
        Potion effect = BENEFICIAL_POTIONS[this.field_145850_b.field_73012_v.nextInt(size)];
        if (effect == (effect2 = BENEFICIAL_POTIONS[this.field_145850_b.field_73012_v.nextInt(size)])) {
            int duration = effect.func_76403_b() ? 0 : 1200 + this.field_145850_b.field_73012_v.nextInt(1200);
            effects.add(new PotionEffect(effect, duration, 1));
        } else {
            int duration = effect.func_76403_b() ? 0 : 800 + this.field_145850_b.field_73012_v.nextInt(800);
            int duration2 = effect2.func_76403_b() ? 0 : 800 + this.field_145850_b.field_73012_v.nextInt(800);
            effects.add(new PotionEffect(effect, duration, 0));
            effects.add(new PotionEffect(effect2, duration2, 0));
        }
        return effects;
    }

    public ItemStack getFood() {
        return this.food;
    }

    public void setFood(ItemStack item) {
        this.food = item;
        this.updateTE();
    }

    public void updateTE() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.cookTime = compound.func_74762_e("CookTime");
        this.food = compound.func_74764_b("Item") ? new ItemStack(Item.func_111206_d((String)compound.func_74779_i("Item")), 1, compound.func_74762_e("Data")) : ItemStack.field_190927_a;
        this.isCooking = compound.func_74767_n("IsCooking");
        this.netherWartCount = compound.func_74762_e("NetherWart");
        this.hasEssence = compound.func_74767_n("HasEssence");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CookTime", this.cookTime);
        if (this.food != ItemStack.field_190927_a) {
            ResourceLocation resource = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.food.func_77973_b());
            compound.func_74778_a("Item", resource == null ? "" : resource.toString());
            compound.func_74768_a("Data", this.food.func_77960_j());
        }
        compound.func_74757_a("IsCooking", this.isCooking);
        compound.func_74768_a("NetherWart", this.netherWartCount);
        compound.func_74757_a("HasEssence", this.hasEssence);
        return compound;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 7, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return !(newState.func_177230_c() instanceof BlockMysticalGrill);
    }
}

