/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.util;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vibrantjourneys.blocks.plant.BlockShortGrass;
import vibrantjourneys.entities.neutral.EntityWatcher;
import vibrantjourneys.entities.passive.EntityFirefly;
import vibrantjourneys.init.PVJItems;
import vibrantjourneys.items.ItemMysticalFood;
import vibrantjourneys.util.BiomeReference;
import vibrantjourneys.util.PVJConfig;

public class PVJEvents {
    @SubscribeEvent
    public void onBreakGrass(BlockEvent.HarvestDropsEvent event) {
        Block block = event.getState().func_177230_c();
        if (!PVJConfig.misc.doGrassDropSeeds && (block instanceof BlockTallGrass || block instanceof BlockShortGrass)) {
            boolean flag = false;
            for (ItemStack item : event.getDrops()) {
                if (item.func_77973_b() != Items.field_151014_N) continue;
                flag = true;
            }
            if (flag) {
                event.getDrops().clear();
            }
        }
    }

    @SubscribeEvent
    public void feedWolfEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        EntityWolf wolf;
        if (event.getTarget() instanceof EntityWolf && (wolf = (EntityWolf)event.getTarget()).func_70909_n() && wolf.func_70902_q() == event.getEntityPlayer() && event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() instanceof ItemMysticalFood) {
            wolf.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"strength"), 1200));
            wolf.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"regeneration"), 1200, 2));
            wolf.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"speed"), 1200));
            wolf.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"resistance"), 1200));
        }
    }

    @SubscribeEvent
    public void onWatcherSpawn(LivingSpawnEvent.CheckSpawn event) {
        Biome biome;
        if (event.getEntityLiving() instanceof EntityWatcher) {
            Random random = event.getWorld().field_73012_v;
            int x = random.nextInt(50) - random.nextInt(50);
            int y = random.nextInt(40) - random.nextInt(40);
            int z = random.nextInt(50) - random.nextInt(50);
            BlockPos pos = new BlockPos((double)(event.getX() + (float)x), (double)(event.getY() + (float)y), (double)(event.getZ() + (float)z));
            while (!event.getWorld().func_175623_d(pos)) {
                x = random.nextInt(50) - random.nextInt(50);
                y = random.nextInt(40) - random.nextInt(40);
                z = random.nextInt(50) - random.nextInt(50);
                pos = new BlockPos((double)(event.getX() + (float)x), (double)(event.getY() + (float)y), (double)(event.getZ() + (float)z));
            }
            event.getEntityLiving().func_70107_b((double)(event.getX() + (float)x), (double)(event.getY() + (float)y), (double)(event.getZ() + (float)z));
        }
        if (event.getEntityLiving() instanceof EntityFirefly && !PVJConfig.entities.firefliesSpawnInSnowBiomes && BiomeReference.SNOWY_BIOMES.contains(biome = event.getWorld().getBiomeForCoordsBody(event.getEntityLiving().func_180425_c()))) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void dropSquid(LivingDropsEvent event) {
        if (PVJConfig.entities.squidsDropFood && event.getEntityLiving() instanceof EntitySquid) {
            ItemStack squid = new ItemStack(PVJItems.raw_squid);
            if (event.getSource() == DamageSource.field_76370_b) {
                squid = new ItemStack(PVJItems.cooked_squid);
            }
            EntityItem drop = new EntityItem(event.getEntityLiving().func_130014_f_());
            BlockPos pos = event.getEntityLiving().func_180425_c();
            drop.func_92058_a(squid);
            drop.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            event.getEntityLiving().func_130014_f_().func_72838_d((Entity)drop);
        }
    }
}

